/* Chime player for PM PostNotes        */
/*                                      */
/* Adapted from example in mcirexx.inf  */ 
/* This .cmd file is called from within */
/* PM PostNotes                         */

/* Load and initialize Multimedia REXX support */
call RXFUNCADD 'mciRxInit','MCIAPI','mciRxInit'
call mciRxInit

/* Parse arguments - repeat [wave] [count] times */
parse arg count wave .

/* Open the default digital audio device for exclusive use */
rc = mciRxSendString('open waveaudio alias wave wait', 'RetStr', '0', '0')
 
/* Check for an error, exit */
if rc <> 0 then
   signal error


/* Load [wave] file */
rc = mciRxSendString('load wave '||wave||' wait', 'RetStr', '0', '0')
 
/* Set the time format to milliseconds */
call mciRxSendString 'set wave time format ms', 'RetStr', '0', '0'

/* play wave [count] times */
do count
   /* Play the multimedia file, wait for completion */
   call mciRxSendString 'play wave wait', 'RetStr', '0', '0'
 
   /* "Rewind" to the beginning of the file */
   call mciRxSendString 'seek wave to start wait', 'RetStr', '0', '0'

   /* Add a timer to pause a 1/2 second */
   call TIME 'R'
   rc = TIME('E')
   do until rc = .5
      rc = TIME('E')
      if rc > .5 then
         rc = .5
   end
end

/* Close the device context */
call mciRxSendString 'close wave', 'RetStr', '0', '0'
 
/* Ensure proper termination of Multimedia REXX */
call mciRxExit
 
exit(0)
   
error:
call mciRxExit
exit(1)