# This file is an Msub script.

# See documention at the end of the script, after the last !end

#
# DECLARATIONS:
#


	# :b = blanks, whitespace except $^

!:b=[\ \9]*


	# :s = search- or replace-expression:
	# Begins with a significant (non-space) character, but not # or !

!:s=[^"#!":w].*


#
# SUBROUTINE doit.
# ARGUMENT: A regular expression with insignificant leading whitespace
#	removed, but not trailing, and including a trailing $
#	(end-of-line).
# DOES: do_todays_work(); /* always a useful subroutine :-) */
# RETURN VALUE: Expressions with proper quotes.
#
!sub doit
	# Leave existing quotes alone:
	\"[^\"$^]*\"
	`

	\'[^\'$^]*\'
	`

	"\"[^a-zA-Z$^]
	`

	# Leave trailing whitespace alone:
	:b$
	`

	# Quote spaces, three different ways:
	
	# 1. If followed by a quote, include it in the quote:
	~1" "+~1~2[\'\"]~2
	~2~1

	# 2. Otherwise, if there are more of them, enclose in quotes:
	/' '' '+/[^:w\'\"]
	\"`\"

	# 3. Just one, use a backslash.
	/' '/[^:w\'\"]
	"\ "
!end

	# Do changes on search- and replace-lines:
^:b/:s$/
\doit(`)

	# In an option like "!:x=sth", "sth" is a regular expression
	# that must be worked on.
^:b"!":b":":b[a-zA-Z]:b"="?:b/[^:b$^'='].*$/
\doit(`)

!newpass

	# Continued lines. Work on the continuation.
"\":b$^:b/[^:b$^].*$/
\doit(`)

!end

==================================================
===  Change of semantics for space character  ====
==================================================

What is changing?
=================
Starting with version 1.3, a space character that is not within "..." or
'...' quotes, or preceeded with \, will be ignored. Meaning that e.g. a
search-replace pair such as 
	John Doe
	someone unknown
will search for "JohnDoe" and replace it with "someoneunknown". 

So what do *I* need to do about it?
===================================
You must make sure the significant spaces in your old scripts are quoted.
You don't need to do that by hand, that's what this script is for. Just
run this script on your old scripts, and they will be properly updated.

The script is not perfect: It is assumed, that continued lines contains
regular expressions to be updated, and that ".." og '..' quotes are not
broken across lines (which is poor style but presently possible).

Why this change?
================
Because it will give you greater freedom to format your search- and
replace-expressions, making them more readable.  Which is important
because, as I've said before, writing regular expressions is a kind of
programming.

Sorry for the inconvenience, but I didn't get it quite right the first
time.

-Anders 
