//
// $Header: D:/ext2-os2/vfs/RCS/ll_rwblk.c,v 1.3 1995/08/16 17:30:31 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0

#include <fsh.h>


#include <os2/types.h>
#include <os2/os2proto.h>
#include <os2/errors.h>

#include <os2/log.h>         /* Prototypes des fonctions de log.c                      */

#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <linux/sched.h>
#include <linux/locks.h>


//
// WARNING !!! Unlike Linux ll_rw_block, here ll_rw_block is SYNCHRONOUS because FSH_DOVOLIO is.
// If we wanted an asynchronous version we could for instance use the extended strategy interface
// if the block device supports it.
//
void ll_rw_block(int rw, int nr, struct buffer_head **bh) {
    int rc;
    int i;
    int nb_sec;
    int rwmode;

    switch (rw) {
        case READ  : 
        case READA :
            rwmode = DVIO_OPREAD;
            break;
        case WRITE  :
        case WRITEA :
            rwmode = DVIO_OPWRITE;
            break;
        default :
            kernel_printf("ll_rw_block() - Invalid flag %d", rw);
            return;
    }
    for (i = 0 ; i < nr ; i++) {
	lock_buffer(bh[i]);
        bh[i]->b_uptodate = 0;
        nb_sec = (UINT16) bh[i]->dev->sectors_per_block;
        if ((rc = FSH_DOVOLIO( 
                               rwmode,
                               DVIO_ALLFAIL | DVIO_ALLABORT | DVIO_ALLRETRY,
                               bh[i]->b_dev,
                               bh[i]->b_data,
                               &nb_sec,
                               bh[i]->b_blocknr * bh[i]->dev->sectors_per_block
                              )) != NO_ERROR) {
            kernel_printf("FSH_DOVOLIO() - rc = 0x%04X - blk_no = %lu", rc, bh[i]->b_blocknr);
        }
        bh[i]->b_uptodate = 1;
        bh[i]->b_dirt     = 0;
	unlock_buffer(bh[i]);


    }
}