//
// $Header: D:/ext2-os2/include/os2/RCS/os2proto.h,v 1.4 1995/08/16 17:39:31 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#ifndef __OS2PROTO_H
#define __OS2PROTO_H

#include <fsh.h>
#include <os2/types.h>

//
// From isfat.c
//
int isfat(pchar component);

//
// From pathutil.c
//
pchar DecoupePath(pchar path, pchar component);
void ExtractPath(pchar Name, pchar Path);
void ExtractName(pchar Name, pchar Nom);


// 
// From log.c
//
#ifdef FS_DEBUG
int kernel_printf(const char *fmt, ...);
#else
extern _inline int kernel_printf(const char *fmt, ...) {return 0;}
#endif
#define printk kernel_printf

//
// From devhelp.c and devhelp2.asm
//
int FS_DevHelp_VMAlloc(unsigned long taille, unsigned long PhysAddr, unsigned long Flags, PUINT32 LinAddr);
int FS_DevHelp_VMFree(unsigned long LinAddr);
int FS_DevHelp_GetDOSVar(unsigned char index, char _FS_PTR _FS_PTR value);
void FS_DevHelp_ProcRun(unsigned long event_id);
void FS_DevHelp_ProcBlock(unsigned long event_id);
int FS_DevHelp_Beep(int Frequence, int Duree);

//
// From devhelp.c
// 
int gettime(unsigned long _FS_PTR ptime);

//
// From util.c
//
unsigned long updcrc(unsigned char *s, unsigned n);

//
// From fs_find.c
//
void date_unix2dos(long unix_date,unsigned short _FS_PTR time, unsigned short _FS_PTR date);

//
// From attr.c
//
void DOS_To_Linux_Attrs(struct inode *inode, unsigned short DOS_attrs);
unsigned short Linux_To_DOS_Attrs(struct inode *inode, char *component);

//
// From volume.c
//
extern int Check_Ext2fs_magic(struct vpfsi *pvpfsi, unsigned short hVPB);
extern int lazy_write(struct super_block *sb);
extern int sync_volume(struct super_block *sb);

//
// cli/sti
//
void _inline sti(void) {
    __asm {
        sti
    }
}

void _inline cli(void) {
    __asm {
        cli
    }
}

//
// from maperr.c
//
extern int map_err(int err);


//
// Memory allocation routines
//
__inline char *G_malloc(unsigned long cbSize) {
    unsigned short seg;
    int            rc;

    if ((rc = FSH_SEGALLOC(SA_FRING0 | SA_FSWAP, cbSize, &seg)) != NO_ERROR) {
        kernel_printf("ERROR - FSH_SEGALLOC returned %d", rc);
        return 0;
    }

    return (char *)(((unsigned long)seg) << 16);
}

__inline int G_free(char *ptr) {
    int rc;

    if ((rc = FSH_SEGFREE((unsigned short)(((unsigned long) ptr) >> 16))) != NO_ERROR) {
        kernel_printf("ERROR - FSH_SEGFREE returned %d", rc);
    }
    return rc;

}

//
// Dumb panic macro - initiates a system halt
//
#define os2_panic(panicmsg) FSH_INTERR(("EXT2-fs panic : "panicmsg), sizeof("EXT2-fs panic : "panicmsg))
#endif
