//
// $Header: D:/ext2-os2/ext2/RCS/super.c,v 1.4 1995/08/16 17:34:45 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#ifdef OS2
#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0

#include <fsh.h>
#include <os2/types.h>
#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <os2/os2proto.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <linux/sched.h>
#include <linux/locks.h>
#include <os2/log.h>
#endif


#ifndef OS2
NORET_TYPE void ext2_panic (struct super_block * sb, const char * function,
			    const char * fmt, ...)
{
	char buf[1024];
	va_list args;

	if (!(sb->s_flags & MS_RDONLY)) {
		sb->u.ext2_sb.s_mount_state |= EXT2_ERROR_FS;
		sb->u.ext2_sb.s_es->s_state |= EXT2_ERROR_FS;
		mark_buffer_dirty(sb->u.ext2_sb.s_sbh, 1);
		sb->s_dirt = 1;
	}
	va_start (args, fmt);
	vsprintf (buf, fmt, args);
	va_end (args);
	panic ("EXT2-fs panic (device %d/%d): %s: %s\n",
	       MAJOR(sb->s_dev), MINOR(sb->s_dev), function, buf);
}

void ext2_error (struct super_block * sb, const char * function,
		 const char * fmt, ...)
{
	char buf[1024];
	va_list args;

	if (!(sb->s_flags & MS_RDONLY)) {
		sb->u.ext2_sb.s_mount_state |= EXT2_ERROR_FS;
		sb->u.ext2_sb.s_es->s_state |= EXT2_ERROR_FS;
		mark_buffer_dirty(sb->u.ext2_sb.s_sbh, 1);
		sb->s_dirt = 1;
	}
	va_start (args, fmt);
	vsprintf (buf, fmt, args);
	va_end (args);
	if (test_opt (sb, ERRORS_PANIC) ||
	    (sb->u.ext2_sb.s_es->s_errors == EXT2_ERRORS_PANIC &&
	     !test_opt (sb, ERRORS_CONT) && !test_opt (sb, ERRORS_RO)))
		panic ("EXT2-fs panic (device %d/%d): %s: %s\n",
		       MAJOR(sb->s_dev), MINOR(sb->s_dev), function, buf);
	printk (KERN_CRIT "EXT2-fs error (device %d/%d): %s: %s\n",
		MAJOR(sb->s_dev), MINOR(sb->s_dev), function, buf);
	if (test_opt (sb, ERRORS_RO) ||
	    (sb->u.ext2_sb.s_es->s_errors == EXT2_ERRORS_RO &&
	     !test_opt (sb, ERRORS_CONT) && !test_opt (sb, ERRORS_PANIC))) {
		printk ("Remounting filesystem read-only\n");
		sb->s_flags |= MS_RDONLY;
	}
}

void ext2_warning (struct super_block * sb, const char * function,
		   const char * fmt, ...)
{
	char buf[1024];
	va_list args;

	va_start (args, fmt);
	vsprintf (buf, fmt, args);
	va_end (args);
	printk (KERN_WARNING "EXT2-fs warning (device %d/%d): %s: %s\n",
		MAJOR(sb->s_dev), MINOR(sb->s_dev), function, buf);
}

#else

void ext2_panic (struct super_block * sb, const char *function,
			    const char *fmt, ...)
{
        int rc = ERROR_INTERRUPT;
	char buf[256];
	va_list args;

	va_start (args, fmt);
	vsprintf (buf, fmt, args);
	va_end (args);

        kernel_printf("*********************************************************************");
        kernel_printf("EXT2-fs panic device %d : %s : %s\r\n\r\n"
                       "Please run e2fsck from Linux\r\n", sb->s_dev, function, buf);
        kernel_printf("*********************************************************************");
	FS_DevHelp_Beep(1000, 200);
        while (rc == ERROR_INTERRUPT) { 
            rc = FSH_SEMWAIT(&(sb->s_semerror), TO_INFINITE);
            kernel_printf("ext2_panic - Interrupt");
        }
//        FSH_INTERR(buf2, strlen(buf2));
}

void ext2_error (struct super_block * sb, const char *function,
			    const char *fmt, ...)
{
	int rc = ERROR_INTERRUPT;
	char buf[256];
	va_list args;

	va_start (args, fmt);
	vsprintf (buf, fmt, args);
	va_end (args);

        kernel_printf("*********************************************************************");
        kernel_printf("EXT2-fs error device %d : %s : %s", sb->s_dev, function, buf);
        kernel_printf("*********************************************************************");
	FS_DevHelp_Beep(1000, 200);
	FS_DevHelp_Beep(1000, 200);
        while (rc == ERROR_INTERRUPT) { 
            rc = FSH_SEMWAIT(&(sb->s_semerror), TO_INFINITE);
            kernel_printf("ext2_panic - Interrupt");
        }
}

void ext2_warning (struct super_block * sb, const char *function,
		   const char *fmt, ...)
{
	char buf[256];
	va_list args;

	va_start (args, fmt);
	vsprintf (buf, fmt, args);
	va_end (args);
	kernel_printf( "EXT2-fs warning (device %d): %s: %s",
		sb->s_dev, function, buf);
}

#endif

void ext2_put_super (struct super_block  *sb)
{
#ifndef OS2
	int db_count;
	int i;
#else
	long db_count;
	long i;
#endif
	lock_super (sb);
	if (!(sb->s_flags & MS_RDONLY)) {
		sb->u.ext2_sb.s_es->s_state = sb->u.ext2_sb.s_mount_state;
		mark_buffer_dirty(sb->u.ext2_sb.s_sbh, 1);
	}
#ifndef OS2
	sb->s_dev = 0;
#endif
	db_count = sb->u.ext2_sb.s_db_per_group;
	for (i = 0; i < db_count; i++)
		if (sb->u.ext2_sb.s_group_desc[i])
			brelse (sb->u.ext2_sb.s_group_desc[i]);
#ifndef OS2
	kfree_s (sb->u.ext2_sb.s_group_desc,
		 db_count * sizeof (struct buffer_head *));
#endif
	for (i = 0; i < EXT2_MAX_GROUP_LOADED; i++)
		if (sb->u.ext2_sb.s_inode_bitmap[i])
			brelse (sb->u.ext2_sb.s_inode_bitmap[i]);
	for (i = 0; i < EXT2_MAX_GROUP_LOADED; i++)
		if (sb->u.ext2_sb.s_block_bitmap[i])
			brelse (sb->u.ext2_sb.s_block_bitmap[i]);

	brelse (sb->u.ext2_sb.s_sbh);
	unlock_super (sb);
	return;
}
