/***************************************************/
/* REXX Procedure to perform incremental backups   */
/***************************************************/
'@ECHO OFF'
av = 'YES'                /* AutoVerify = YES | NO */

/***************************************************/
/* Extract the date and change to mm/dd/yy format  */
/***************************************************/
odate = Date('O')
Parse Value odate With yy '/' mm '/' dd
rundate = mm'/'dd'/'yy

/***************************************************/
/* Initialize REXXUtil environment (if not present)*/
/***************************************************/
rxload = RxFuncQuery('SysLoadFuncs')
If rxload Then
   Do
      Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      Call sysloadfuncs
   End

/***************************************************/
/* Extract the drives available on the system      */
/***************************************************/
drives = SysDriveMap('C:', 'LOCAL')

/***************************************************/
/* Load number of drives into table root           */
/***************************************************/
drive.0 = Words(drives)

/***************************************************/
/* Load the table with the available drive letters */
/***************************************************/
Do x=1 To drive.0 By 1
   Parse Value drives With drive.x drives
End

/***************************************************/
/* Perform a differential backup of FAT and HPFS   */
/* drives.  Perform the backup only if there are   */
/* files on the drive with their archive bit set.  */
/***************************************************/
Do x=1 To drive.0 By 1
   filesys = FileType(drive.x)
   If filesys = 'HPFS' | filesys = 'FAT' Then
      Do
         done = 0
         loop = 3         /* Maximum error retries */
         rc = SysFileTree(drive.x||'*.*', 'files', 'SO', '+****')
         If files.0 > 0 Then
            Do
               Call VERIFY
               If result = 1 Then
                  Do Forever Until done
                     'BACKMAST /D:'drive.x '/BD:"INCR' drive.x rundate'" /AV:NO'

/***************************************************/
/* If (and only if) the backup was successful,     */
/* reset the "Archive" bit on all files backed up. */
/***************************************************/
                     If rc = 0 Then
                        Do
                           If Translate(av) = 'YES' Then
                              'BACKMAST /D:'drive.x '/V:"INCR' drive.x rundate'"'
                           Do y=1 to files.0 By 1
                              'ATTRIB -A "' || files.y || '"'
                           End
                           done = 1
                        End
                     Else

/***************************************************/
/* If the backup was not successful, attempt a     */
/* limited number of retries (base on "loop").     */
/***************************************************/
                        Do
                           loop = loop - 1
                           If loop = 0 Then
                              done = 1
                        End
                  End
            End
      End
End

/***************************************************/
/* All done, end processing.                       */
/***************************************************/
CLEANUP:
   If rxload Then
      Call SysDropFuncs
   Exit

/***************************************************/
/* Verify whether or not an incremental is required*/
/***************************************************/
VERIFY:
   bkup = 0
   Do y=1 to files.0 By 1
      fn = Filespec('N', files.y)
      Select
         When Translate(fn) = 'EA DATA. SF' Then
            Nop
         When Translate(fn) = 'WP ROOT. SF' Then
            Nop
         When Translate(fn) = 'SWAPPER.DAT' Then
            Nop
         Otherwise
            bkup = 1
      End
      If bkup Then Leave y
   End
   Return bkup
