/***************************************************/
/* REXX Procedure to perform full backups          */
/***************************************************/
'@ECHO OFF'
logswitch = 1
av = 'YES'                /* AutoVerify = YES | NO */
prompt = 'YES'            /* Prompt on new drive   */

/***************************************************/
/* Extract the date and change to mm/dd/yy format  */
/***************************************************/
odate = Date('O')
Parse Value odate With yy '/' mm '/' dd
rundate = mm'/'dd'/'yy

/***************************************************/
/*  Initialize Visual REXX environment if          */
/*  prompting has been enabled.                    */
/***************************************************/
If Translate(prompt) = 'YES' Then
   Do
      Call RxFuncAdd 'VInit', 'VREXX', 'VINIT'
      initcode = VInit()
      If initcode = 'ERROR' Then
         signal CLEANUP
      Call VDialogPos 25, 75
   End

/***************************************************/
/* Initialize REXXUtil environment (if not present)*/
/***************************************************/
rxload = RxFuncQuery('SysLoadFuncs')
If rxload Then
   Do
      Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
      Call sysloadfuncs
   End

/***************************************************/
/* Set error traps to force clean up on failures   */
/***************************************************/
Signal On Failure Name CLEANUP
Signal On Halt Name CLEANUP
Signal On Syntax Name CLEANUP

/***************************************************/
/*  Initialize Visual REXX button values           */
/***************************************************/
Ok         = 1
Cancel     = 2
OkOrCancel = 3
Yes        = 4
No         = 5
YesOrNo    = 6

/***************************************************/
/*  Locate the active BackMaster directory         */
/***************************************************/
bmname = SysSearchPath('PATH', 'BACKMAST.EXE')
bmdrive = Filespec('D', bmname)
bmpath = Filespec('P', bmname)
bmpath = bmdrive||bmpath

/***************************************************/
/* Extract the drives available on the system      */
/***************************************************/
drives = SysDriveMap('C:', 'LOCAL')

/***************************************************/
/* Load number of drives into table root           */
/***************************************************/
drive.0 = Words(drives)

/***************************************************/
/* Load the table with the available drive letters */
/***************************************************/
Do x=1 To drive.0 By 1
   Parse Value drives With drive.x drives
End

/***************************************************/
/* Perform a full backup of all FAT or HPFS drives.*/
/* Perform the backup only if the user specifies   */
/* that it is to occur.                            */
/***************************************************/
Do x=1 To drive.0 By 1
   filesys = FileType(drive.x)
   If filesys = 'HPFS' | filesys = 'FAT' Then
      Do
         If Translate(prompt) = 'YES' Then
            Do
               title = 'Full backup of Drive '||drive.x
               msg.0 = 4
               msg.1 = 'Volume name is'
               msg.2 = '      FULL '||drive.x||' '||rundate
               msg.3 = ''
               msg.4 = 'Proceed with backup?'
               answer = VMsgBox(title, msg, YesOrNo)
            End
         Else
            answer = 'YES'
         If answer = 'YES' Then
            Do
               done = 0
               loop = 3   /* No. of retry attempts */
               If logswitch Then
                  Do
                     rc = SysFileTree(bmpath||'BACKMAST.OLD', 'file', 'F')
                     If file.0 <> 0 Then
                        Call SysFileDelete bmpath||'BACKMAST.OLD'
                     rc = SysFileTree(bmpath||'BACKMAST.LOG', 'file', 'F')
                     If file.0 <> 0 Then
                        'REN' bmpath||'BACKMAST.LOG' bmpath||'BACKMAST.OLD'
                     logswitch = 0
                  End
               Do Forever Until done
                  'BACKMAST /D:'drive.x '/BF:"FULL' drive.x rundate'" /AV:NO'
                  If rc = 0 Then
                     Do
                       done = 1
                       If Translate(av) = 'YES' Then
                          'BACKMAST /D:'drive.x '/V:"FULL' drive.x rundate'"'
                     End
                  Else
                     Do
                        loop = loop - 1
                        If loop = 0 Then
                           done = 1
                     End
               End
            End
      End
End

/***************************************************/
/* All done, end processing.                       */
/***************************************************/
CLEANUP:
   If Translate(prompt) = 'YES' Then
      Call 'VExit'
   If rxload Then
      Call SysDropFuncs  /* Drop only if we loaded */
   Exit
