//Header file
// M\Cooper, 3425 Chestnut Ridge Rd., Grantsville, MD 21536-9801
// Email: thegrendel@aol.com

/***************************************************************************/

extern "C" two_tone(),
	   blatt(),
    beep1();

#define PLAY 1
#define GAME_OVER 1
#define QUIT 2	
#define ESC 27
#define MAXLEN 4
#define BUFSIZE 12
#define BLK_TIME 226
#define NAME_POS 190
#define Y_TIMEPOS 300
#define POS_OFFSET 158
#define POS1_OFFSET 130
#define COLORS 15
#define PATTERNS 11
#define RADIUS 50
#define X_C 315
#define Y_C 225
#define MOVES_X 316
#define MOVES_Y 440
#define BKGRND_COLOR WHITE

typedef enum { FALSE, TRUE } BOOLEAN;
enum FLAG { OFF, ON };
enum Player { WHITE_, BLACK_ };

char *player[] = { "White", "Black" },
     esc_msg[] =   "Press ESC to exit",
     title_msg[] = "Countdown Timer";

void graphics_setup( int ),
     exit__(),
     erase();



class CountdownTimer
   {
   protected:
      int hours,
	  minutes,
	  moves,
	  warning,
	  text_color;
      char line_clear [ BUFSIZE ];
      Player p;
      FLAG running_flag,
	   visual_ticking_flag,
	   time_warning_flag;
      time_t seconds,
	     total_seconds,
	     total_seconds_mem,
	     start_t,
	     end_t,
	     startn_t,
	     interval_t,
	     running_t;
   public:
      CountdownTimer()
	  {
	   hours = 0; minutes = 3; moves = 0; seconds = 0L;
	   total_seconds = total_seconds_mem = (long)hours * 3600L + (long)minutes * 60L;
	  }
      CountdownTimer( int hrs, int min, time_t sec, Player pl )
	  {
	  hours = hrs; minutes = min; seconds = sec; moves = 0;
	  total_seconds = (long)hours * 3600L + (long)minutes * 60L + seconds;
	  total_seconds_mem = total_seconds;
	  p = pl;
	  }
      CountdownTimer( int min, time_t sec, Player pl )
	  { 
	  sec += (long)min * 60L;
	  total_seconds = total_seconds_mem = sec; 
	  hours = sec / 3600;
	  minutes = ( sec % 3600 ) / 60;
	  seconds = sec % 60;
	  moves = 0;
	  p = pl;
	  }
      CountdownTimer( int hrs, int min, Player pl )
	 {
	 hours = hrs; minutes = min; seconds = 0L; moves = 0;
	 total_seconds = total_seconds_mem = (long)hours * 3600L + (long)minutes * 60L;
	 p = pl;
	 }
      CountdownTimer( time_t sec, Player pl )
	  {
	  total_seconds = total_seconds_mem = sec;
	  convert( sec );
	  p = pl;
	  moves = 0;
	  }

      CountdownTimer( int min )
	 {
	 hours = min / 60;
	 minutes = min % 60;
	 seconds = 0L; moves = 0;
	 total_seconds = total_seconds_mem = (long)min * 60L;
	 }

      void convert( time_t sec )
	  { 
	  hours = sec / 3600;
	  sec %= 3600;
	  minutes = sec / 60;
	  seconds = sec % 60;
	  }

      void display_time()
	  {
	  char dbuff [ BUFSIZE ];

	     sprintf( dbuff,  "%02d:%02d:%02ld", hours, minutes, seconds );
 
	     erase_numbers();  // Wipe off old time.
	     
	     setcolor( text_color );
	     outtextxy( BLK_TIME, Y_TIMEPOS, dbuff );
	     sprintf( line_clear, dbuff );
	  }

      BOOLEAN timeout()
	 {
	 if( !hours )
	    if( !minutes )
	       if( !seconds )
		  {
		  two_tone();
		  return ( TRUE );
		  }
	 return ( FALSE );
	 }

void exit_()
{ 
   char ch;

      setcolor( BKGRND_COLOR );
      settextstyle( TRIPLEX_FONT, HORIZ_DIR, 1 );
      outtextxy( NAME_POS, 100, "Press a key to stop timer" );
      setcolor( CYAN );
      outtextxy( NAME_POS, 100, "Press a key to reset timer" );
      ch = getch();
      if( ch == ESC )
	 exit__(); // Quit.

      setcolor( BKGRND_COLOR );
      outtextxy( NAME_POS, 100, "Press a key to reset timer" );
      setcolor( BLUE );
      outtextxy( NAME_POS, 100, "Press a key to stop timer" );

      return;
}

      void initialize_clock()
      {
      running_flag = OFF;  //Clock is running.
      running_t = 0;
      start_t = time( NULL );
      }

      void clock_on(),
	   erase_numbers(),
	   display_moves(),
	   reset_timer(),
	   erase();

      friend void play();

	
    }; //end class defn.

