.. the following code generates the gauss knots

function legendre (n)
	p0=1; p1=[0,1];
	loop 2 to n;
		p=((0|(2*#-1)*p1)-((#-1)*(p0|0|0)))/#;
		p0=p1; p1=p;
	end;
	return p1
endfunction

function gaussparam (n)
## returns the knots and alphas of gauss integration at n points in
## [-1,1]. Returns {gaussz,gaussa}.
	p=legendre(n);
	z=sort(re(polysolve(p)));
	Z=dup(z,n)^dup((0:n-1)',n);
	a=Z\(2/(1:n)'*mod(1:n,2)');
	return {z,a'}
endfunction




