/*
 * Copyright (c) 1995 Eugene W. Stark
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Eugene W. Stark.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 5. No copying or redistribution in any form for commercial purposes is
 *    permitted without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY EUGENE W. STARK (THE AUTHOR) ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * XREF ID --> pointer index routines
 *
 * If too much time is being spent in this code, replace it with something
 * more sophisticated.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "index.h"

#ifndef HAVE_STRDUP
char *strdup(const char *s);
#endif

struct ientry {
  char *id;
  void *value;
  struct ientry *next;
};

void out_of_memory();

#define HASHSIZE 5003
#define HASHMULT 251

struct ientry *hashtab[HASHSIZE];

int hash(char *id)
{
  unsigned int h = 0;
  while(*id) {
    h = (h * HASHMULT) + *id;
    id++;
  }
  return(h % HASHSIZE);
}

int index_enter(char *id, void *value)
{
  int h;
  struct ientry *ip, *pip, *new;

  h = hash(id);
  for(ip = hashtab[h], pip = NULL; ip != NULL; pip = ip, ip = ip->next) {
    if(!strcmp(ip->id, id)) {
      fprintf(stderr, "Multiply defined cross-reference ID: %s\n", id);
      return(-1);
    }
  }
  if((new = malloc(sizeof(struct ientry))) == NULL)
    out_of_memory();
  if((new->id = strdup(id)) == NULL)
    out_of_memory();
  new->value = value;
  new->next = NULL;
  if(pip == NULL) {
    hashtab[h] = new;
  } else {
    pip->next = new;
  }
  return(0);
}

void *index_find(char *id)
{
  int h;
  struct ientry *ip;

  h = hash(id);
  for(ip = hashtab[h]; ip != NULL; ip = ip->next) {
    if(!strcmp(ip->id, id))
      return(ip->value);
  }
  return(NULL);
}
