   NAME

      TREE - generate directory tree(s) and output them


   SYNOPSIS

      TREE [/W] [/F<configuration File>] [<drive>: [<drive>: [...]]]


   SYSTEM REQUIREMENTS

   	  IBM compatible PC
   	  512k RAM
   	  DOS version 3.0+


   DESCRIPTION

      TREE will read each of the specified drives, or the current drive if none
      is specified, and add up the sizes of all of the files in each directory,
      displaying the results as shown below:

       TREE  	12/12/1992  12:12pm

       Volume: DOS_401_C (7/7/92)
         Size: 41,870,240 bytes
         Free: 35,947,380 bytes

         Branch   Single
          Total      Dir
         ------   ------
          5923K     427K  C:\
                   2228K  DOS
          2730K       0K  APPS
                   1276K    PIM
          1454K     568K    WORDPROC
                    886K       DOCS
			        491K  PICTURES

	  The date and time listed at the top of the display are the date and
	  time at which the tree(s) were generated.

	  The Volume line shows the Volume label and the date it was created or last
	  modified.

	  The Size line shows the total number of bytes of storage on the drive.

	  The Free line shows the number of bytes available for use on the drive.

	  The Single Dir column reflects all allocated space for the files in each
	  directory, but does not include the space allocated to each directory for
	  maintainance of information about the files and subdirectories it
	  contains.

	  An entry in the Branch Total column will be displayed when a directory has
	  subdirectories.  This value is the sum of the sizes of the directory and
	  its subdirectories.  The Branch Total entry for the root directory, which
	  is shown as the drive letter with a colon and backslash (i.g. C:\), is the
	  exception to this, in that it is the value DOS reports as being used
	  on the drive.  This value will be higher than a simple summation of all
	  of the Single Dir entries, since it includes the space allocated for the
	  subdirectories' file information, the fixed-sized root directory, the
	  FAT (File Allocation Table), and other reserved space.

	  If more than one drive is specified on the command line, TREE will attempt
	  to fit as many as possible side by side.  If not all fit on the same dis-
	  play, TREE will continue to display as many as will fit on the next dis-
	  play, and so on, until the list of drives is exhausted.

	  If so specified in the configuration file, TREE will send commands to the
	  printer (or any other device which accepts characters per inch {CPI} set-
	  tings) to set any number of CPI so that TREE may fit as many trees side by
	  side as possible while filling the horizontal space as completely as
	  possible.


   OPTIONS

   	  /W(rite default configuration file)
   	  		This option will write a configuration file named DEFAULT.TCG in the
   	  		same directory as the executable file.  This file contains the
   	  		defaults TREE will use if it can't find DEFAULT.TCG in the current
   	  		directory or in the directory in which TREE.EXE is located.  If
   	  		DEFAULT.TCG already exists, TREE will ask if it should be over-
   	  		written.  Once the file is written, TREE exits and will ignore
   	  		other input on the command line.

  	  /F<configuration File>
  	  		This option causes TREE to use the specified configuration file.
  	  		If no extension is specified, .TCG is appended to the name.  TREE
  	  		will look for the configuration file in the specified directory (if
  	  		none is specified, this will be the DOS current directory), and then
  	  		in the directory in which TREE.EXE is located.  If this switch is
  	  		not specified, TREE will look for a file named DEFAULT.TCG first in
  	  		the DOS current directory, and then in the same directory as the
  	  		executable; if this file is not found, TREE will use its default
  	  		option values (see options and their default values below under
  	  		configuration files.)


   CONFIGURATION FILES

	  The first line of a TREE configuration file must be

	  [Tree configuration file]

	  This line, as well as all other lines in the configuration file, may
	  be in upper or lower case or any mixture of the two.

	  Comments or other information which should not be interpreted may be
	  started with a right angle bracket ('>') character.  Commented lines
	  must begin with this character and comments may not be placed on the
	  same line as an option.

	  The intent of the configuration file concept in connection with this
	  program is that more than one will be used, say one for the screen
	  and another for the printer.

	  A complete list of available options may be found in DEFAULT.TCG,
	  which accompanies this package, or which may be generated by running
	  TREE.EXE with the /W option (see OPTIONS, above.)

	  An option is set by placing the name of the option followed by an equal
	  sign followed by the value to which it is to be set.  Only one option
	  should appear on each line.  Blank lines are permitted.  Any option
	  which is not specified will be set to the default value, which may be
	  determined by generating DEFAULT.TCG with the /W command line option.
	  The available options, their default values in parentheses, and a descrip-
	  tion of each follows.

		DisplayDateAndTime (= Yes)
			 If this is set to Yes, the date and time the tree(s) were generated
			 appears at the top of each display

		DisplayBranchTotals (= Yes)
			 If this is set to Yes, the Branch Totals column is displayed.

		DisplayDirectorySizes (= Yes)
			 If this is set to Yes, the Dir Sizes column is displayed.

		DisplayVolumeLabel (= Yes)
			 If this is set to Yes, the volume label and its date of creation
			 or last modification is displayed.

		DisplaySizeAndFreeSpace (= Yes)
			 If this is set to Yes, the Size and Free lines, which show the
			 amounts of total and free space on the drive, respectively, will
			 be displayed.

		SortDirectories (= Yes)
			 If this is set to Yes, the entries in each subdirectory are
			 alphabetized in ascending order.  If this is set to No, the
			 directories are displayed in the same order in which they are
			 stored on the drive.  This order will not ordinarily be alpha-
			 betical.

		FixedColumns (= 80)
			 If this option is specified, TREE will not attempt to manipulate
			 the number of characters per inch (CPI) in the display, so any
			 PrintSetCPI specifications in the same file as a FixedColumns
			 specification will be ignored.  If you wish to allow TREE to set
			 the display CPI, do not specify this option.

		OutputDevice (= CON)
			 If CON (the DOS filename for the console, the output component of
			 which is the screen) is specified, all displays will be sent to
			 the console stream.  This stream may be redirected from the command
			 line to any file or device or piped to another application.

			 Any file which may be created by DOS, or device whose name is known
			 to DOS may be specified here.  If a file which already exists is
			 specified, it will be overwritten without warning (CAREFUL!).

		PrintWidthInches (= <no default value>)
			 This option is used in conjunction with the PrintSetCPI option
			 to determine the number of available columns in the display.
			 Printers which print on 8-1/2"x11" paper will probably be able
			 to use 8.0 inches horizontally.  Check your printer manual.
			 If neither this option nor FixedColumns is specified, TREE will not
			 be able to generate a display.

	 The last three options share the same settings format.  Printer commands
	 may be specified byte by byte or in string format, or any combination of
	 the two.  Consult your printer (or other device) manual for a list
	 of the possible commands.  An example of these is

	  				PrintSetup 0x20 027 57 '\n\x87\33' "ABCD"
	  				            1   2   3   4 5   6     7

	     1. The first byte sent is specified in hexadecimal format (0x + number)
	     2. The second is in octal format (0 + number)
	     3. The third is in decimal format
	     4. The fourth is within quotes and is one of several C language
	        escape codes which have special meanings.  These follow:

	         \n  line feed
	         \r  carriage return
	         \t  horizontal tab
	         \v  vertical tab
	         \f  form feed
	         \a  bell (if the printer has a bell, it will sound)
	         \b  backspace

	        These must be specified in lower case.  A backslash followed by
	        a non-numeric character (within quotes) which is not one of the
	        above will be sent verbatim, i.g. \Q sends a Q to the output device.
	     5. The fifth byte is in quoted hex format (backslash x {or X} followed
	        by a hex number.
	     6. The sixth byte is in quoted octal format (backslash followed by an
	        octal number.
	     7. The seventh through tenth bytes are specified verbatim.  Anything
	        appearing within quotes, with all exceptions noted above, will be
	        sent exactly as shown.  Any quotes may be double or single.

	    PrintSetup (= <no default value>)
			 This option will send the specified string of characters in the
			 format shown above to the output device before any other output
			 is sent.  This option may be specified whether or not FixedColumns
			 is specified.

	    PrintReset (= <no default value>)
			 This option will send the specified string of characters in the
			 format shown above to the output device after all other output
			 has been sent.  This option may be specified whether or not
			 FixedColumns is specified.

	    PrintSetCPI (= <no default value>)
			 This option may be specified as many times as necessary in order
			 to fully describe the CPI settings you wish to use on the output
			 device.  The format of the setting for this option is a number
			 specifying the characters per inch (this number must be base 10,
			 but may be non-integral) followed by the string of characters to
			 send to the output device which will set this CPI.  The following
			 example sets the output device to 10 CPI (this is not a functioning
			 example -- consult your device manual for the correct command{s}):

			 		PrintSetCPI = 10 033 ':'

			 The following example sets the output device to 17 CPI (this is
			 not a functioning example -- consult your device manual for the
			 correct command{s}):

			 		PrintSetCPI = 17 "\x1b-"

			 In order to allow TREE to fit as many trees as possible side by
			 side, but to make the characters as wide as possible when the
			 number of trees will allow it, it is suggested that all of your
			 device's CPI settings be specified in the configuration file
			 for the printer (the author names this file PRINTER.TCG -- if
			 you have more than one printer and wish to use both, you will
			 need a configuration file for each.)  For example, the following
			 is the section from the author's PRINTER.TCG which describes the
			 printer's CPI settings (the author has a Seikosha SP-2000 Plus
			 in IBM Proprinter II compatible mode):

					PrintSetCPI = 10 18
					PrintSetCPI = 12 '\x1b:'
					PrintSetCPI = 17 0x12 0x0f


   DISCLAIMER

      Use of this software constitutes agreement that the author of this soft-
      ware may not be held responsible for any damages, to include loss or
      corruption of data, incurred through its use.

   	  The default configuration of this program will not write to anything.
   	  Care should be taken when writing or rewriting configuration files
   	  to avoid loss of data.


   HELP

	  If you discover bugs or care to comment on the software in any other
	  fashion, the author may be contacted as follows:

	  Snailmail: S.A. Rowe
	             160 Groton Ave.
	             Cortland, NY 13045

	  Email: SARowe1@aol.com



Copyright (c) 1995 S.A. Rowe

