/****************************************************************/
/*  Installation Procedure for CCW for OS/2 Demonstration       */
/*                                                              */
/****************************************************************/
/*  Overall function:                                           */
/*    -Initialization                                           */
/*    -determine OS/2 Version                                   */
/*    -Determine Target drive and subdirectory                  */
/*    -Install                                                  */
/*      -Copy files to target directories                       */
/*      -Unpack                                                 */
/*      -erase packed files                                     */
/*      -Create Object on Desktop                               */
/*                                                              */
/****************************************************************/
/* initialization */
'@ECHO OFF'
ver = os2ver()
if ver>=2 then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
   end

/* get the system boot drive */
drives='CDEFGHIJK'
i=0
do until ( lines(substr(drives,i,1)':\os2\cmd.exe')=1  |  i=8 )
   i=i+1
   end
bdrive = substr(drives,i,1)

/* menu to determine where it should be installed */
idrive = bdrive
ipath='\ccw_demo'
do until ok='A'
   'CLS'
   say '     ******************************************************************'
   say '                       CCW for OS/2 Demonstration'
   say '                             Installation'
   say '     ******************************************************************'
   say ''
   say '     NOTE: You will need approximately 3 MB to unpack the Demo'
   say ''
   say '     The Demo will be'
   say '      installed on drive:  'idrive''
   say '            in directory:  'ipath||copies(' ',40-length(ipath))''
   say ''
   say '===> If this is OK,               type A, then press Enter'
   say '===> to specify another location, type C, then press Enter'
   say '===> to quit installation,        type Q, then press Enter'
   say ''
   pull ok; ok=strip(ok); ok=left(ok,1)
   if ok='Q' then exit
   if ok='C' then do
      say ''
      say '==> Type the letter of the drive on'
      say '==> which to install, then press Enter'
      pull idrive
      idrive = left(idrive,1)
      say '==> Default path is \ccw_demo, type a new path if you wish, then press Enter'
      say '==> If ccw_demo is ok, press Enter'
      pull ipath
      if ipath = "" then ipath = '\ccw_demo'
      if left(ipath,1)<>'\' then ipath = '\'ipath
      end /* of if ok=no */
   end /* of do until ok=yes */



/****************************************************************/
/*  Install the diskette                                        */
/*                                                              */
/****************************************************************/
/* install it */
idrive':'       /* get to the drive */
'MD' ipath      /*   and directory  */
'CD' ipath

say ''
say 'Copying files from Diskette'
'COPY A:demo.exe' ipath
if rc=1 then do
  'CD\'
  exit
end
say ''
say 'Unpacking files...'
'demo'
'ERASE demo.exe'
say ''
say 'Finished unpacking.'
say ''


/****************************************************************/
/*  Create the CCW for OS/2 Object                              */
/****************************************************************/
say ''
say 'Creating an object on your desktop...'

object.class = 'WPProgram'
object.title = 'CCW Demo'
object.location = '<WP_DESKTOP>'
object.update = 'UPDATE'
object.setup = 'EXENAME='idrive':'ipath'\ccwtmmnl.exe;'
object.setup = object.setup'STARTUPDIR='idrive':'ipath';'
object.setup = object.setup'PARAMETERS=ccwdemo.pkg /noabout /nobookmark'
Created = BldObj()
if rc=1 then do
  'cd\'
  exit
end

/****************************************************************/
/*  Installation completed                                      */
/*                                                              */
/****************************************************************/
cls
say ''
say ''
say '     ******************************************************************'
say '     '
say '                      Installation Completed.'
say '     '
say '          A CCW for OS/2 demo object has been created on your'
say '          desktop.  Double-click on it to start.'
say '     '
say '     ******************************************************************'


exit
/****************************************************************/
/*  Get the OS/2 Version                                        */
/*                                                              */
/****************************************************************/
OS2Ver: procedure
PreQ = queued()
'@VER | RXQUEUE /LIFO'
Output = ''
do while queued() > PreQ
  Output = Output linein('QUEUE:')
  end
Ver = '?'
do while Output <> '' & Ver = '?'
   parse var Output Test Output
   if verify(Test, '0123456789.') = 0 then Ver = Test
   end
return Ver

/****************************************************************/
/* Build Object - create an object                              */
/*                                                              */
/****************************************************************/
BldObj: Procedure Expose object.
   result = SysCreateObject(object.class, object.title, object.location,,
                            object.setup, object.update) /* Generic create using

 global var */
   If result<>1 Then Do
      Say object.title 'not created, return code='result
      end
   else say object.title 'object created'
Return result
