/* XSDK.H */

#ifndef _XSDK_H
#define _XSDK_H

/****************************************************************************/
/*			Synchronet External Program Software Development Kit			*/
/*							1993 Digital Dynamics							*/
/****************************************************************************/

/****************************************************************************/
/* This source code file is public domain and may be modified, compiled 	*/
/* distributed, or used in any way, in part or whole for any purposes		*/
/* without the consent or notification of Digital Dynamics. 				*/
/*																			*/
/* We only request that you display to the user, at some point, in your 	*/
/* program the character "XSDK" and the version number.                     */
/* example: bprintf("XSDK v%s",xsdk_ver);                                   */
/****************************************************************************/

/****************************************************************************/
/* The source code for two external programs developed by Digital Dynamics	*/
/* using XSDK (Synchronet Blackjack [SBJ] and Synchronet BBS List [SBL])	*/
/* are available to the public domain as examples of how to implement the	*/
/* functions and variables included in this software development kit.		*/
/****************************************************************************/


/****************************************************/
/* For use with Borland/Turbo C and C++ compilers.	*/
/* Tabstop set to 4.								*/
/****************************************************/

/*********************************************/
/* Standard Borland/Turbo C/C++ Header Files */
/*********************************************/
#include <io.h>
#include <dos.h>
#include <bios.h>
#include <time.h>
#include <ctype.h>
#include <stdio.h>
#include <share.h>
#include <conio.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <malloc.h>
#include <sys/stat.h>
#include <sys/types.h>

#ifdef __TURBOC__
    #include <dir.h>
#endif

#ifdef __WATCOMC__
	#include <graph.h>
#endif

#define GLOBAL extern	/* turns XSDKVAR.C into a header file */
#include "xsdkvars.c"

#ifdef __cplusplus
	extern "C" {
#endif

extern char *xsdk_ver;	/* XSDK version number */
extern int mswtyp;		/* MSwait type */

/***********************/
/* Function Prototypes */
/***********************/
void bputs(char *str);
void rputs(char *str);
int  bprintf(char *fmt, ...);
int  rprintf(char *fmt, ...);
int  bstrlen(uchar *str);
void outchar(char ch);
void mnemonics(char *str);
void pause(void);
char yesno(char *str);
char noyes(char *str);
char inkey(int mode);
char getkey(int mode);
int  getkeys(char *str, int max);
int  getnum(int max);
void attr(char atr);
void cls(void);
void ctrl_a(char x);
int  nopen(char *str, int access);
void truncsp(uchar *str);
void initdata(void);
void checktimeleft(void);
void printfile(char *str);
int  getstr(char *str, int maxlen, int mode);
void redrwstr(char *strin, int i, int l, char mode);
char stripattr(char *strin);
char *username(uint usernumber);
uint usernumber(char *username);
char fexist(char *filespec);
long flength(char *filespec);
char *ultoac(ulong l, char *string);
ulong ahtoul(char *str);
void printnodedat(uchar number, node_t node);
void nodesync(void);
void putnodedat(uchar number, node_t node);
void getnodedat(uchar number, node_t *node, char lockit);
void putsmsg(int usernumber, char *strin);
void getsmsg(int usernumber);
void putnmsg(int num, char *strin);
void getnmsg(void);
int whos_online(char listself);
void nodemsg(void);
void dv_pause(void);
void ungetkey(char ch);
void checkline(void);
void mswait(int ms);
void center(char *str);

#ifdef __cplusplus
	}
#endif


#endif	/* Don't add anything after this #endif */
