Unit SlctDir;
{========================================================================}
Interface
  Uses
    Dos;
  Function SelectDir(Var FileAreaPath : PathStr) : Byte;
{========================================================================}
Implementation
  Uses
    CopyMove, Crt, MfmDefs, MfmStr, Screen;
  Type
    ListPtr = ^ListRecord;
    ListRecord = Record
      Next, Prev : ListPtr;
      Attr : Byte;
      Name : String[12];
    End;
  Var
    DirInfo : SearchRec;
    FirstEntry, CurrentEntry, TempEntry : ListPtr;
    TempRecord : ListRecord;
    NoOfEntries, CurrentEntryNo : Word;
    NoEntryToShow : Byte;
    CurrentDrive : Byte;
    ForChar : Char;
    Msr : Registers;
    DriveList, TempString, OldPath : String;
{========================================================================}
Procedure BuildDirList(FileSpec : PathStr);
  Begin
    FirstEntry := NIL; NoOfEntries := 0;
    FindFirst(FileSpec, AnyFile, DirInfo);
    While DosError = 0 Do
    Begin
      If DirInfo.Name = '.' Then FindNext(DirInfo);
      If (DirInfo.Attr And Directory) = Directory Then
      Begin
        New(CurrentEntry); Inc(NoOfEntries);
        If FirstEntry = NIL Then
        Begin
          FirstEntry := CurrentEntry;
          CurrentEntry^.Prev := NIL;
        End
        Else
        Begin
          CurrentEntry^.Prev := TempEntry;
          TempEntry^.Next := CurrentEntry;
        End;
        CurrentEntry^.Next := NIL;
        CurrentEntry^.Attr := DirInfo.Attr;
        CurrentEntry^.Name := DirInfo.Name;
        TempEntry := CurrentEntry;
      End;
      FindNext(DirInfo);
    End;
  End;
{========================================================================}
Procedure SortDirList;
  Var
    Exchange : Boolean;
  Begin
    If FirstEntry <> NIL Then
    Begin
      New(TempEntry);
      Repeat
        Exchange := False;
        CurrentEntry := FirstEntry;
        While CurrentEntry^.Next <> NIL Do
        Begin
          If CurrentEntry^.Name > CurrentEntry^.Next^.Name Then
          Begin
            TempEntry^.Attr := CurrentEntry^.Attr;
            CurrentEntry^.Attr := CurrentEntry^.Next^.Attr;
            CurrentEntry^.Next^.Attr := TempEntry^.Attr;
            TempEntry^.Name := CurrentEntry^.Name;
            CurrentEntry^.Name := CurrentEntry^.Next^.Name;
            CurrentEntry^.Next^.Name := TempEntry^.Name;
            Exchange := True;
          End;
          CurrentEntry := CurrentEntry^.Next;
        End;
      Until (Not Exchange);
      Dispose(TempEntry);
    End;
  End;
{========================================================================}
Procedure RemoveDirList;
  Begin
    If FirstEntry <> NIL Then
    Begin
      CurrentEntry := FirstEntry;
      While CurrentEntry^.Next <> NIL Do
      Begin
        TempEntry := CurrentEntry;
        CurrentEntry := CurrentEntry^.Next;
        Dispose(TempEntry);
      End;
      Dispose(CurrentEntry);
    End;
  End;
{========================================================================}
Function DisplayEntryNo(EntryNo : Byte) : String;
  Var
    EntryNoCtr : Byte;
  Begin
    If FirstEntry <> NIL Then
    Begin
      TempEntry := FirstEntry; EntryNoCtr := 1;
      While (EntryNoCtr < EntryNo) And (EntryNoCtr < NoOfEntries) Do
      Begin
        TempEntry := TempEntry^.Next;
        Inc(EntryNoCtr);
      End;
      If EntryNoCtr = EntryNo Then
      Begin
        DisplayEntryNo := TempEntry^.Name+Copy('            ',1,12-Length(TempEntry^.Name));
        TempRecord.Attr := TempEntry^.Attr;
        TempRecord.Name := TempEntry^.Name;
      End
      Else
      Begin
        DisplayEntryNo := '            ';
        TempRecord.Attr := 0;
        TempRecord.Name := '';
      End;
    End
    Else
    Begin
      DisplayEntryNo := 'None';
    End;
  End;
{========================================================================}
Procedure DisplayEntryList(StartFrom : Word; Col, Row : Byte);
  Var
    Lsi : Word;
  Begin
    If FirstEntry <> NIL Then
    Begin
      AnsiGotoXY(Col,Row);
      If StartFrom > 1 Then AnsiWriteLn(LightMagenta,Black,' ^ ') Else AnsiWriteLn(LightRed,Black,'');
      Inc(Row);
      For Lsi := StartFrom To StartFrom+(NoEntryToShow-1) Do
      Begin
        AnsiGoWrite(Col,Row,LightCyan,Black,No,DisplayEntryNo(Lsi));
        Inc(Row);
      End;
      AnsiGotoXY(Col,Row);
      If NoOfEntries > StartFrom+(NoEntryToShow-1) Then
        AnsiWriteLn(LightMagenta,Black,' v ') Else AnsiWriteLn(LightRed,Black,'');
      Inc(Row);
    End;
  End;
{========================================================================}
Procedure DoubleBox(Col, Row, Height, Width, TextColor, BackColor : Byte);
  Var
    Dbb : Byte;
  Begin
    AnsiGoWrite(Col,Row,TextColor,BackColor,No,'');
    For Dbb := 1 To Width-1 Do AnsiWrite(TextColor,BackColor,'');
    AnsiWrite(TextColor,BackColor,'');
    For Dbb := 1 To Height+1 Do
    Begin
      AnsiGoWrite(Col,Row+Dbb,TextColor,BackColor,No,'');
      AnsiGoWrite(Col+Width,Row+Dbb,TextColor,BackColor,No,'');
    End;
    AnsiGoWrite(Col,Row+Dbb,TextColor,BackColor,No,'');
    For Dbb := 1 To Width-1 Do AnsiWrite(TextColor,BackColor,'');
    AnsiWrite(TextColor,BackColor,'');
  End;
{========================================================================}
Function SelectDir(Var FileAreaPath : PathStr) : Byte;
  Const
    NoOfFiles = 15;
    Col = 2;
    Row = 2;
  Var
    SelPos, Sfb : Byte;
    Sfc : Char;
    TopChanged : Boolean;
    TopEntry : Word;
    D: DirStr;
    N: NameStr;
    E: ExtStr;
    NewPath : PathStr;
  Begin
    NewPath := FileAreaPath+'*.*';
    SelectDir := 0;
    FSplit(FExpand(NewPath),D,N,E);
    If Length(D) > 3 Then
    Begin
      OldPath := D+N+E;
      FSplit(FExpand(D+'..\'+N+E),D,N,E);
      NewPath := D+N+E;
    End;
    BuildDirList(NewPath);
    SortDirList;
    If FirstEntry <> NIL Then
    Begin
      SelPos := 1;
      TopEntry := 1;
      For SelPos := NoOfEntries DownTo 1 Do
      Begin
        If D+AllTrim(DisplayEntryNo(SelPos))+'\*.*' = OldPath Then Break;
      End;
      If SelPos > NoOfFiles Then TopEntry := SelPos-(NoOfFiles Div 2) Else TopEntry := 1;
      TopChanged := True;
      NoEntryToShow := NoOfFiles;
      DoubleBox(Col,Row,NoEntryToShow,15,LightRed,Black);
      AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,White,Black,1);
      Repeat
        If TopChanged Then
        Begin
          DisplayEntryList(TopEntry,Col+2,Row);
          AnsiGoWrite(41,15,Yellow,Black,No,'D');
          AnsiWrite(Magenta,Black,' - ');
          AnsiWrite(LightGreen,Black,'Change Drive');
          AnsiGoWrite(41,16,Yellow,Black,No,'Q');
          AnsiWrite(Magenta,Black,' - ');
          AnsiWrite(LightGreen,Black,'Quit Directory Select');
          AnsiGoWrite(41,17,Yellow,Black,No,'4');
          AnsiWrite(Magenta,Black,' - ');
          AnsiWrite(LightGreen,Black,'Change to Root Directory');
          AnsiGoWrite(41,18,Yellow,Black,No,'6');
          AnsiWrite(Magenta,Black,' - ');
          AnsiWrite(LightGreen,Black,'Change Directory');
          CenterWrite(23,LightGray,Black,Pgmid);
          TopChanged := False;
        End;
        AnsiGotoXY(50,1); AnsiClearToEol;
        If SelPos = 0 Then
        Begin
          AnsiWrite(LightBlue,Black,Copy(NewPath,1,3));
        End
        Else
        Begin
          If (Pos('..',DisplayEntryNo(SelPos)) > 0) Or (Pos('None',DisplayEntryNo(SelPos)) > 0) Then
          Begin
            AnsiWrite(LightBlue,Black,D);
          End
          Else
          Begin
            AnsiWrite(LightBlue,Black,AllTrim(D+DisplayEntryNo(SelPos))+'\');
          End;
        End;
        Repeat
          Sfb := GetInput;
          Sfc := Upcase(Chr(Sfb));
          If Sfb = 0 Then
          Begin
            Sfb := GetInput;
            Case Sfb Of
              71 : Sfc := '7';
              72 : Sfc := '8';
              73 : Sfc := '9';
              75 : Sfc := '4';
              77 : Sfc := '6';
              79 : Sfc := '1';
              80 : Sfc := '2';
              81 : Sfc := '3';
            End;
          End;
        Until Sfc In [^M,^Q,^[,'1','2','3','4','6','7','8','9','D','Q'];
        Case Sfc Of
          '1' : Begin
                  If SelPos < NoOfEntries Then
                  Begin
                    If SelPos > 0 Then AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,LightGray,Black,0);
                    SelPos := NoOfEntries;
                    If NoOfEntries > NoOfFiles Then
                    Begin
                      TopEntry := (NoOfEntries-NoOfFiles)+1;
                      TopChanged := True;
                    End;
                    AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,White,Black,1);
                  End;
                End;
          '2' : Begin
                  If SelPos < NoOfEntries Then
                  Begin
                    If (SelPos-TopEntry)+2 > NoOfFiles Then
                    Begin
                      Inc(TopEntry);
                      TopChanged := True;
                      Inc(SelPos);
                    End
                    Else
                    Begin
                      If SelPos > 0 Then AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,LightGray,Black,0);
                      Inc(SelPos);
                      AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,White,Black,1);
                    End;
                  End;
                End;
          '3' : Begin
                  If SelPos < NoOfEntries Then
                  Begin
                    If SelPos > 0 Then AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,LightGray,Black,0);
                    If NoOfEntries < NoOfFiles Then
                    Begin
                      SelPos := NoOfEntries;
                    End
                    Else
                    Begin
                      If SelPos+NoOfFiles < NoOfEntries Then
                      Begin
                        SelPos := SelPos+NoOfFiles;
                        TopEntry := TopEntry+NoOfFiles;
                        TopChanged := True;
                      End
                      Else
                      Begin
                        SelPos := NoOfEntries;
                        TopEntry := (NoOfEntries-NoOfFiles)+1;
                        TopChanged := True;
                      End;
                    End;
                    AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,White,Black,1);
                  End;
                End;
          '4' : Begin
                  If SelPos > 0 Then
                  Begin
                    AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,LightGray,Black,0);
                    TopEntry := 1;
                    TopChanged := True;
                    SelPos := 0;
                  End;
                End;
          '7' : Begin
                  If SelPos > 1 Then
                  Begin
                    AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,LightGray,Black,0);
                    SelPos := 1;
                    AnsiPutPtr(Col+1,Col+14,Row+1,White,Black,1);
                  End;
                  If TopEntry > 1 Then
                  Begin
                    TopEntry := 1;
                    TopChanged := True;
                  End;
                End;
          '8' : Begin
                  If SelPos > 1 Then
                  Begin
                    If SelPos = TopEntry Then
                    Begin
                      Dec(TopEntry);
                      TopChanged := True;
                      Dec(SelPos);
                    End
                    Else
                    Begin
                      AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,LightGray,Black,0);
                      Dec(SelPos);
                      AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,White,Black,1);
                    End;
                  End;
                End;
          '9' : Begin
                  If SelPos > 1 Then
                  Begin
                    AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,LightGray,Black,0);
                    If NoOfEntries < NoOfFiles Then
                    Begin
                      SelPos := 1;
                    End
                    Else
                    Begin
                      If SelPos-NoOfFiles > 1 Then
                      Begin
                        SelPos := SelPos-NoOfFiles;
                        If TopEntry > NoOfFiles Then
                        Begin
                          TopEntry := TopEntry-NoOfFiles;
                        End
                        Else
                        Begin
                          TopEntry := SelPos;
                        End;
                        TopChanged := True;
                      End
                      Else
                      Begin
                        SelPos := 1;
                        TopEntry := 1;
                        TopChanged := True;
                      End;
                    End;
                    AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,White,Black,1);
                  End;
                End;
          'D' : Begin
                  DriveList := '';
                  Msr.Ah := $19;
                  MsDos(Msr);
                  CurrentDrive := Msr.Al;
                  For ForChar := 'A' To 'Z' Do
                  Begin
                    Msr.Ah := $0E;
                    Msr.Dl := Ord(ForChar) - Ord('A');
                    MsDos(Msr);
                    Msr.Ah := $19;
                    MsDos(Msr);
                    If Msr.Al = Msr.Dl Then DriveList := DriveList+(Char(Msr.Al+Ord('A')))+': ';
                  End;
                  Msr.Ah := $0E;
                  Msr.Dl := CurrentDrive;
                  MsDos(Msr);
                  AnsiGoWrite(1,25,Yellow,Black,Yes,DriveList);
                  AnsiGoWrite(41,21,LightGray,Black,Yes,'Select drive: ');
                  Repeat
                    Sfc := Upcase(ReadKey);
                    If Pos(Sfc,DriveList) > 0 Then
                    Begin
                      If DiskFree(Ord(Sfc) - Ord('@')) < 0 Then
                      Begin
                        DoubleBox(1,20,1,31,LightRed+Blink,Black);
                        AnsiGoWrite(3,21,White,Black,No,'Unable to read from drive '+Sfc+':');
                        Sfc := '_';
                      End;
                    End;
                  Until (Pos(Sfc,DriveList) > 0) Or (Sfc In [^Q,#27]);
                  If Not (Sfc In [^Q,#27]) Then
                  Begin
                    If Sfc = Copy(FileAreaPath,1,1) Then
                    Begin
                      NewPath := FileAreaPath+'*.*';
                      SelectDir := 0;
                      FSplit(FExpand(NewPath),D,N,E);
                      If Length(D) > 3 Then
                      Begin
                        OldPath := D+N+E;
                        FSplit(FExpand(D+'..\'+N+E),D,N,E);
                        NewPath := D+N+E;
                      End;
                    End
                    Else
                    Begin
                      GetDir(Ord(Sfc)-(Ord('A')-1),TempString);
                      AnsiGoWrite(41,21,LightGray,Black,Yes,TempString);
                      If Copy(TempString,Length(TempString),1) <> '\' Then TempString := TempString+'\';
                      FSplit(FExpand(TempString+N+E),D,N,E);
                      NewPath := D+N+E;
                    End;
                    RemoveDirList;
                    BuildDirList(NewPath);
                    SortDirList;
                    SelPos := 1;
                    TopEntry := 1;
                    If Sfc = Copy(FileAreaPath,1,1) Then
                    Begin
                      For SelPos := NoOfEntries DownTo 1 Do
                      Begin
                        If D+AllTrim(DisplayEntryNo(SelPos))+'\*.*' = OldPath Then Break;
                      End;
                      If SelPos > NoOfFiles Then TopEntry := SelPos-(NoOfFiles Div 2) Else TopEntry := 1;
                    End;
                    TopChanged := True;
                    NoEntryToShow := NoOfFiles;
                    AnsiClearScreen;
                    DoubleBox(Col,Row,NoEntryToShow,15,LightRed,Black);
                    AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,White,Black,1);
                    Sfc := ' ';
                  End;
                End;
        End;
        If (Sfc = '6') And (TempRecord.Attr = Directory) Then
        Begin
          FSplit(FExpand(D+TempRecord.Name+'\'+N+E),D,N,E);
          OldPath := NewPath;
          NewPath := D+N+E;
          RemoveDirList;
          BuildDirList(NewPath);
          SortDirList;
          If TempRecord.Name = '..' Then
          Begin
            For SelPos := NoOfEntries DownTo 1 Do
            Begin
              If D+AllTrim(DisplayEntryNo(SelPos))+'\*.*' = OldPath Then Break;
            End;
            If SelPos > NoOfFiles Then TopEntry := SelPos-(NoOfFiles Div 2) Else TopEntry := 1;
          End
          Else
          Begin
            SelPos := 1;
            TopEntry := 1;
          End;
          TopChanged := True;
          NoEntryToShow := NoOfFiles;
          AnsiClearScreen;
          DoubleBox(Col,Row,NoEntryToShow,15,LightRed,Black);
          AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,White,Black,1);
          Sfc := ' ';
        End;
      Until Sfc In [^M,^Q,^[,'Q'];
      AnsiPutPtr(Col+1,Col+14,Row+(SelPos-TopEntry)+1,LightGray,Black,0);
      If Sfc In [^Q,^[,'Q'] Then
      Begin
        If Sfc = ^Q Then SelectDir := 253; {Quit to DOS}
        If Sfc In [^[,'Q'] Then SelectDir := 252; {Quit Select Directory}
      End
      Else
      Begin
        If SelPos = 0 Then
        Begin
          FileAreaPath := Copy(NewPath,1,3);
        End
        Else
        Begin
          If (Pos('..',DisplayEntryNo(SelPos)) > 0) Or (Pos('None',DisplayEntryNo(SelPos)) > 0) Then
          Begin
            FileAreaPath := D;
          End
          Else
          Begin
            FileAreaPath := AllTrim(D+DisplayEntryNo(SelPos))+'\';
          End;
        End;
      End;
      CurrentEntryNo := SelPos;
    End;
    RemoveDirList;
  End;
{========================================================================}
Begin
End.
{========================================================================}
