Unit Screen;
{========================================================================}
Interface
  Uses
    Crt, Dos;
  Type
    ReDirectToType = (Console,ComPort1,ComPort2,StandardIO);
  Var
    ReDirectTo : RedirectToType;
  Function GetInput : Byte;
  Procedure MfmWrite(InString : String);
  Procedure MfmWriteLn(InString : String);
  Procedure NewTextColor(NewColor : byte);
  Procedure NewTextBackground(NewColor : Byte);
  Procedure AnsiClearScreen;
  Procedure AnsiClearToEOL;
  Procedure AnsiGotoXY(Col,Row : Byte);
  Procedure AnsiGoWrite(Col,Row,TextColor,BackColor : Byte; ClrToEol : Boolean; InString : String);
  Procedure AnsiPutPtr(Col1,Col2,Row,TextColor,BackColor,PutOrTake : Byte);
  Procedure AnsiWrite(TextColor,BackColor : Byte; InString : String);
  Procedure AnsiWriteLn(TextColor,BackColor : Byte; InString : String);
{========================================================================}
Implementation
  Uses
    Fossil, MfmDefs;
{========================================================================}
Function GetInput : Byte;
  Var
    Msr : Registers;
    NoInputPending : Boolean;
  Begin
    If ReDirectTo In [Console,StandardIO] Then
    Begin
      Msr.Ah := $07;
      MsDos(Msr);
      GetInput := Msr.Al;
    End
    Else
    Begin
      NoInputPending := True;
      While NoInputPending Do
      Begin
        Msr.Ax := $0300;
        If RedirectTo = ComPort1 Then Msr.Dx := 0 Else Msr.Dx := 1;
        Intr($14,Msr);
        If (Msr.Ax And $0080) <> $0080 Then Halt(255);
        If (Msr.Ax And $0100) = $0100 Then NoInputPending := False;
      End;
      Msr.Ax := $0200;
      If RedirectTo = ComPort1 Then Msr.Dx := 0 Else Msr.Dx := 1;
      Intr($14,Msr);
      GetInput := Msr.Al;
    End;
  End;
{========================================================================}
Procedure MfmWrite(InString : String);
  Var
    Mwb : Byte;
  Begin
    If ReDirectTo In [Console,StandardIO] Then
    Begin
      Write(InString);
    End
    Else
    Begin
      Case ReDirectTo Of
        ComPort1 : ComPort := 0;
        ComPort2 : ComPort := 1;
      End;
      For Mwb := 1 To Length(InString) Do P_Intr_14($01,Ord(InString[Mwb]));
    End;
  End;
{========================================================================}
Procedure MfmWriteLn(InString : String);
  Begin
    MfmWrite(InString+CrLf);
  End;
{========================================================================}
Procedure NewTextColor(NewColor : byte);
  Var
    NewColorAnsi : String[6];
    Flash : Boolean;
  Begin
    If ReDirectTo = Console Then
    Begin
      TextColor(NewColor);
    End
    Else
    Begin
      If NewColor > 128 Then
      Begin
        NewColor := NewColor - 128;
        Flash := True;
      End
      Else
      Begin
        Flash := False;
      End;
      Case NewColor of
        0 : NewColorAnsi := '30'; {BLACK}
        1 : NewColorAnsi := '34'; {BLUE}
        2 : NewColorAnsi := '32'; {GREEN}
        3 : NewColorAnsi := '36'; {CYAN}
        4 : NewColorAnsi := '31'; {RED}
        5 : NewColorAnsi := '35'; {MAGENTA}
        6 : NewColorAnsi := '33'; {BROWN}
        7 : NewColorAnsi := '37'; {LIGHTGRAY}
        8 : NewColorAnsi := '1;30'; {DARKGRAY}
        9 : NewColorAnsi := '1;34'; {LIGHTBLUE}
        10: NewColorAnsi := '1;32'; {LIGHTGREEN}
        11: NewColorAnsi := '1;36'; {LIGHTCYAN}
        12: NewColorAnsi := '1;31'; {LIGHTRED}
        13: NewColorAnsi := '1;35'; {LIGHTMAGENTA}
        14: NewColorAnsi := '1;33'; {YELLOW}
        15: NewColorAnsi := '1;37'; {WHITE}
      End;
      If Flash Then NewColorAnsi := '5;'+NewColorAnsi Else NewColorAnsi := '0;'+NewColorAnsi;
      MfmWrite(^[+'['+NewColorAnsi+'m');
    End;
  End;
{========================================================================}
Procedure NewTextBackground(NewColor : Byte);
  Var
    NewColorAnsi : String[6];
  Begin
    If ReDirectTo = Console Then
    Begin
      TextBackground(NewColor);
    End
    Else
    Begin
      Case NewColor of
        0 : NewColorAnsi := '40'; {BLACK}
        1 : NewColorAnsi := '44'; {BLUE}
        2 : NewColorAnsi := '42'; {GREEN}
        3 : NewColorAnsi := '46'; {CYAN}
        4 : NewColorAnsi := '41'; {RED}
        5 : NewColorAnsi := '45'; {MAGENTA}
        6 : NewColorAnsi := '43'; {BROWN}
        7 : NewColorAnsi := '47'; {LIGHTGRAY}
      End;
      MfmWrite(^[+'['+NewColorAnsi+'m');
    End;
  End;
{========================================================================}
Procedure AnsiClearScreen;
  Begin
    If ReDirectTo = Console Then ClrScr Else MfmWrite(^[+'[2J');
  End;
{========================================================================}
Procedure AnsiClearToEOL;
  Begin
    If ReDirectTo = Console Then ClrEol Else MfmWrite(^[+'[K');
  End;
{========================================================================}
Procedure AnsiGotoXY(Col,Row : Byte);
  Var
    Xpos, Ypos : String[2];
  Begin
    If ReDirectTo = Console Then
    Begin
      GotoXY(Col,Row);
    End
    Else
    Begin
      Str(Col,Xpos); Str(Row,Ypos);
      MfmWrite(^[+'['+Ypos+';'+Xpos+'H');
    End;
  End;
{========================================================================}
Procedure AnsiGoWrite(Col,Row,TextColor,BackColor : Byte; ClrToEol : Boolean; InString : String);
  Begin
    AnsiGotoXY(Col,Row);
    If ClrToEol Then AnsiClearToEOL;
    AnsiWrite(TextColor,BackColor,InString);
  End;
{========================================================================}
Procedure AnsiPutPtr(Col1,Col2,Row,TextColor,BackColor,PutOrTake : Byte);
  Begin
    If PutOrTake = 0 Then
    Begin
      AnsiGoWrite(Col1,Row,TextColor,BackColor,No,' ');
      AnsiGoWrite(Col2,Row,TextColor,BackColor,No,' ');
    End
    Else
    Begin
      AnsiGoWrite(Col1,Row,TextColor,BackColor,No,'>');
      AnsiGoWrite(Col2,Row,TextColor,BackColor,No,'<');
    End;
  End;
{========================================================================}
Procedure AnsiWrite(TextColor,BackColor : Byte; InString : String);
  Begin
    NewTextColor(TextColor);
    NewTextBackGround(BackColor);
    MfmWrite(InString);
  End;
{========================================================================}
Procedure AnsiWriteLn(TextColor,BackColor : Byte; InString : String);
  Begin
    NewTextColor(TextColor);
    NewTextBackGround(BackColor);
    MfmWriteLn(InString);
  End;
{========================================================================}
Begin
End.
{========================================================================}
