Unit SaveKill;
{========================================================================}
Interface
  Uses
    Dos, MfmDefs;
  Function SizeOfFilesBbs(FileArea : String) : LongInt;
  Function InMainList(TempEntry : ListPtr) : Boolean;
  Procedure EraseKillList;
  Procedure Mfm2Bbs2Bak(InString : PathStr);
  Procedure SaveList;
  Procedure RemoveList;
{========================================================================}
Implementation
  Uses
    Crt, General, MfmStr, Screen, Quit;
{========================================================================}
Function SizeOfFilesBbs(FileArea : String) : LongInt;
  Var
    FilesBbs : File Of Byte;
    SizeOfFile : LongInt;
  Begin
    Assign(FilesBbs,FileArea+'FILES.BBS');
    {$I-} Reset(FilesBbs); {$I+}
    If IOresult = 0 Then
    Begin
      SizeOfFilesBbs := FileSize(FilesBbs);
      Close(FilesBbs);
    End
    Else
    Begin
      SizeOfFilesBbs := 0;
    End;
  End;
{========================================================================}
Function InMainList(TempEntry : ListPtr) : Boolean;
  Begin
    NextPrintEntry := FirstEntry; InMainList := False;
    While NextPrintEntry^.NextEntry <> NIL Do
    Begin
      If NextPrintEntry^.FileName = TempEntry^.FileName Then InMainList := True;
      NextPrintEntry := NextPrintEntry^.NextEntry;
    End;
  End;
{========================================================================}
Procedure EraseKillList;
  Var
    FileToErase : File;
  Begin
    While KillEntry <> NIL Do
    Begin
      FindFirst(FileAreaPath+KillEntry^.FileName,Archive,DirInfo);
      If DosError = 0 Then
      Begin
        If (Not InMainList(KillEntry)) Then
        Begin
          If UpperString(KillEntry^.FileName) <> 'FILES.BBS' Then
          Begin
            Assign(FileToErase,FileAreaPath+KillEntry^.FileName);
            Erase(FileToErase);
          End;
        End;
      End;
      OldEntry := KillEntry;
      If KillEntry^.PrevEntry = KillEntry Then
      Begin
        Dispose(KillEntry);
        KillEntry := NIL;
      End
      Else
      Begin
        KillEntry^.PrevEntry^.NextEntry := KillEntry^.NextEntry;
        KillEntry^.NextEntry^.PrevEntry := KillEntry^.PrevEntry;
        KillEntry := KillEntry^.NextEntry;
      End;
      If KillEntry <> NIL Then Dispose(OldEntry);
    End;
  End;
{========================================================================}
Procedure Mfm2Bbs2Bak(InString : PathStr);
  Begin
    MyRename(InString+'FILES.BBS',InString+'FILES.BAK');
    MyRename(InString+'FILES.MFM',InString+'FILES.BBS');
  End;
{========================================================================}
Procedure SaveList;
  Var
    Slc : Char;
  Begin
    AnsiGoWrite(1,25,White,Black,Yes,'This will DELETE killed files and update FILES.BBS, Are you sure? ');
    Repeat
      Gbx := GetInput;
      Slc := Upcase(Chr(Gbx));
    Until Slc In ['N','Y'];
    MfmWrite(Slc);
    If Slc = 'Y' Then
    Begin
      Assign(FileList,FileAreaPath+'FILES.MFM');
      {$I-} ReWrite(FileList); {$I+}
      If IOresult = 0 Then
      Begin
        NextPrintEntry := FirstEntry;
        While NextPrintEntry^.NextEntry <> NIL Do
        Begin
          If NextPrintEntry^.TypeOfRecord <> Orphan Then
          Begin
            If NextPrintEntry^.TypeOfRecord <> Comment Then
            Begin
              Write(FileList,NextPrintEntry^.FileName);
              Write(FileList,Copy('         ',1,13-Length(NextPrintEntry^.FileName))+' ');
            End;
            WriteLn(FileList,NextPrintEntry^.Description);
          End;
          NextPrintEntry := NextPrintEntry^.NextEntry;
        End;
        If NextPrintEntry^.TypeOfRecord <> Orphan Then
        Begin
          Write(FileList,NextPrintEntry^.FileName);
          Write(FileList,' ');
          WriteLn(FileList,NextPrintEntry^.Description);
        End;
        Close(FileList);
        Mfm2Bbs2Bak(FileAreaPath);
        EraseKillList;
        AnsiGotoXY(1,25); AnsiClearToEOL;
      End;
      AreaChanged := True;
      AddAreaToList(CurrentAreaName);
      Altered := False;
    End;
    AnsiGotoXY(80,24);
  End;
{========================================================================}
Procedure RemoveList;
  Begin
    If Altered Then
    Begin
      SaveList;
      Altered := False;
    End;
    BeginSort := NIL; EndSort := NIL;
    NextPrintEntry := FirstEntry;
    While NextPrintEntry^.NextEntry <> NIL Do
    Begin
      NextPrintEntry := NextPrintEntry^.NextEntry;
      Dispose(NextPrintEntry^.PrevEntry);
    End;
    Dispose(NextPrintEntry);
  End;
{========================================================================}
Begin
End.
{========================================================================}
