Unit RenFind;
{========================================================================}
Interface
  Function ValidFileName(FileName : String) : Boolean;
  Procedure RenameFile;
  Procedure FindString(TypeOfSearch : Char);
{========================================================================}
Implementation
  Uses
    Crt, Display, Dos, Edit, MfmDefs, MfmStr, Screen;
{========================================================================}
Function ValidFileName(FileName : String) : Boolean;
  Begin
    If (Pos('.',FileName) <= 9)
    And (Rpos('.',FileName) <= 4)
    And (Length(FileName) > 0)
    And (Copy(FileName,1,1) <> '.') Then
    Begin
      ValidFileName := True;
    End
    Else
    Begin
      ValidFileName := False;
    End;
  End;
{========================================================================}
Procedure RenameFile;
  Var
    NewFileName : String[12];
    FileToRename : File;
    Rfc : Char;
  Begin
    If CurrentEntry^.TypeOfRecord = FileRecord Then
    Begin
      AnsiGoWrite(1,25,White,Black,Yes,'Enter file name to rename '+CurrentEntry^.FileName+' to: ');
      OffSet := 31 + Length(CurrentEntry^.FileName);
      NewFileName := UpperString(EditLine('',12,25,Offset));
      If ValidFileName(NewFileName) Then
      Begin
        FindFirst(FileAreaPath+NewFileName,AnyFile,DirInfo);
        If DosError <> 0 Then
        Begin
          AnsiGoWrite(1,25,White,Black,Yes,'Rename '+CurrentEntry^.FileName+' to '+NewFileName+' (Y/N)? ');
          Repeat
            Gbx := GetInput;
            Rfc := Upcase(Chr(Gbx));
          Until Rfc In ['N','Y'];
          MfmWrite(Rfc);
          If Rfc = 'Y' Then
          Begin
            Altered := True;
            Assign(FileToRename,FileAreaPath+CurrentEntry^.FileName);
            Rename(FileToRename,FileAreaPath+NewFileName);
            CurrentEntry^.FileName := NewFileName;
            NextPrintEntry := CurrentEntry;
            DisplayRecord(Row); DisplayCurrentLocation;
          End;
        End;
      End;
      AnsiGotoXY(80,24);
    End;
  End;
{========================================================================}
Procedure FindString(TypeOfSearch : Char);
  Var
    Found : Boolean;
    Counter : Byte;
  Begin
    AnsiGoWrite(1,25,White,Black,Yes,'Enter string to search for: '+StringToFind);
    StringToFind := UpperString(EditLine(StringToFind,12,25,28));
    NextPrintEntry := CurrentEntry; Found := False;
    While (Not Found) And (NextPrintEntry^.NextEntry <> NIL) Do
    Begin
      NextPrintEntry := NextPrintEntry^.NextEntry;
      If Pos(StringToFind,UpperString(NextPrintEntry^.FileName)) > 0 Then Found := True;
      Case TypeOfSearch Of
        'B' : Begin
                If Pos(StringToFind,UpperString(NextPrintEntry^.FileName)) > 0 Then Found := True;
                If Pos(StringToFind,UpperString(NextPrintEntry^.Description)) > 0 Then Found := True;
              End;
        'D' : Begin
                If Pos(StringToFind,UpperString(NextPrintEntry^.Description)) > 0 Then Found := True;
              End;
        'F' : Begin
                If Pos(StringToFind,UpperString(NextPrintEntry^.FileName)) > 0 Then Found := True;
              End;
      End;
    End;
    If Found Then
    Begin
      Counter := 10;
      CurrentEntry := NextPrintEntry;
      While (Counter > 1) And (NextPrintEntry^.PrevEntry <> NIL) Do
      Begin
        Dec(Counter);
        NextPrintEntry := NextPrintEntry^.PrevEntry;
      End;
      TopEntry := NextPrintEntry;
      AnsiGoWrite(1,25,White,Black,Yes,StringToFind+' found!');
      Row := 11 - Counter;
      DisplayScreen;
    End
    Else
    Begin
      AnsiGoWrite(1,25,White,Black,Yes,StringToFind+' NOT found!');
      DisplayCurrentLocation;
    End;
  End;
{========================================================================}
Begin
End.
{========================================================================}
