Unit Quit;
{========================================================================}
Interface
  Procedure QuitMfm;
  Procedure ChangeFileDate;
  Procedure AddAreaToList(AreaToAdd : String);
  Procedure BuildFbList;
{========================================================================}
Implementation
  Uses
    Crt, Display, Dos, Edit, MfmDefs, SaveKill, Screen;
  Type
    FbPtrType = ^FbRecType;
    FbRecType = Record
      Next, Prev : FbPtrType;
      Area : String;
    End;
  Var
    FirstFbPtr, CurrentFbPtr, TempFbPtr : FbPtrType;
{========================================================================}
Procedure QuitMfm;
  Var
    Qc : Char;
  Begin
    AnsiGotoXY(1,25); AnsiClearToEOL;
    If Result < 253 Then
    Begin
      MfmWrite('Are you sure? ');
      Repeat
        Gbx := GetInput;
        Qc := Upcase(Chr(Gbx));
      Until Qc In ['N','Y'];
      MfmWrite(Qc);
      If Qc = 'N' Then
      Begin
        AnsiGotoXY(1,25); AnsiClearToEOL;
        Exit;
      End;
    End;
    If Altered Then SaveList;
    If RunFb Then BuildFbList;
    NewTextColor(LightGray); NewTextBackground(Black);
    AnsiClearScreen;
    Halt(0);
  End;
{========================================================================}
Procedure ChangeFileDate;
  Var
    Cdc : Char;
    Year, Month, Day, DayOfWeek, Hour, Minute, Second, Sec100 : Word;
    FileToDate : File;
    DateTimeString : String[17];
  Begin
    If CurrentEntry^.TypeOfRecord = FileRecord Then
    Begin
      AnsiGoWrite(1,25,White,Black,Yes,'Change date to current, special or abort? (C/S/A) ');
      Repeat
        Gbx := GetInput;
        Cdc := Upcase(Chr(Gbx));
      Until Cdc In ['C','S','A'];
      MfmWrite(Cdc);
      If Cdc In ['C','S'] Then
      Begin
        Case Cdc Of
          'C' : Begin
                  GetDate(Year, Month, Day, DayOfWeek);
                  GetTime(Hour, Minute, Second, Sec100);
                  Date.Year := Year; Date.Month := Month; Date.Day := Day;
                  Date.Hour := Hour; Date.Min := Minute; Date.Sec := Second;
                  PackTime(Date, CurrentEntry^.FileDate);
                End;
          'S' : Begin
                  AnsiGotoXY(1,25); AnsiClearToEOL;
                  DateTimeString := GetDateString(CurrentEntry^.FileDate)+' '+GetTimeString(CurrentEntry^.FileDate);
                  MfmWrite(DateTimeString);
                  DateTimeString := EditLine(DateTimeString,17,25,0);
                  AnsiGotoXY(40,25); MfmWrite(DateTimeString);
                  CurrentEntry^.FileDate := GetPackedTime(Copy(DateTimeString,1,8),Copy(DateTimeString,10,8));
                End;
        End;
        Assign(FileToDate,FileAreaPath+CurrentEntry^.FileName);
        Reset(FileToDate);
        SetFTime(FileToDate,CurrentEntry^.FileDate);
        Close(FileToDate);
        NextPrintEntry := CurrentEntry;
        DisplayRecord(Row); DisplayCurrentLocation;
      End;
      AnsiGotoXY(80,24);
    End;
  End;
{========================================================================}
Procedure AddAreaToList(AreaToAdd : String);
  Var
    AlreadyHave : Boolean;
  Begin
    If Length(AreaToAdd) > 0 Then
    Begin
      If FirstFbPtr = NIL Then
      Begin
        New(CurrentFbPtr);
        CurrentFbPtr^.Prev := NIL;
        CurrentFbPtr^.Next := NIL;
        CurrentFbPtr^.Area := AreaToAdd;
        FirstFbPtr := CurrentFbPtr;
      End
      Else
      Begin
        AlreadyHave := False;
        CurrentFbPtr := FirstFbPtr;
        While CurrentFbPtr^.Next <> NIL Do
        Begin
          If CurrentFbPtr^.Area = AreaToAdd Then AlreadyHave := True;
          CurrentFbPtr := CurrentFbPtr^.Next;
        End;
        If CurrentFbPtr^.Area = AreaToAdd Then AlreadyHave := True;
        If Not AlreadyHave Then
        Begin
          New(TempFbPtr);
          TempFbPtr^.Prev := CurrentFbPtr;
          TempFbPtr^.Next := NIL;
          TempFbPtr^.Area := AreaToAdd;
          CurrentFbPtr^.Next := TempFbPtr;
        End;
      End;
    End;
  End;
{========================================================================}
Procedure BuildFbList;
  Var
    BatFile : Text;
  Begin
    If FirstFbPtr <> NIL Then
    Begin
      Assign(BatFile,D+'MFMRUNFB.BAT');
      ReWrite(BatFile);
      Write(BatFile,'FB AREA.DAT');
      CurrentFbPtr := FirstFbPtr;
      While CurrentFbPtr^.Next <> NIL Do
      Begin
        Write(BatFile,' '+CurrentFbPtr^.Area);
        TempFbPtr := CurrentFbPtr;
        CurrentFbPtr := CurrentFbPtr^.Next;
        Dispose(TempFbPtr);
      End;
      Write(BatFile,' '+CurrentFbPtr^.Area);
      Dispose(CurrentFbPtr);
      Close(BatFile);
    End;
  End;
{========================================================================}
Begin
  FirstFbPtr := NIL;
End.
{========================================================================}
