Unit MfmStr;
{========================================================================}
Interface
  Type
    ArrayInPtr = ^ArrayInType;
    ArrayInType = Array[1..255] Of Char;
  Function MyStr(InVal : LongInt; MyStrLen : Byte) : String;
  Function MyVal(InString : String) : LongInt;
  Function AllTrim(InString : String) : String;
  Function UpperString(InString : String) : String;
  Function LowerString(InString : String) : String;
  Function CapFirst(InString : String) : String;
  Function InvertString(InString : String) : String;
  Function RPos(StringToFind,StringToSearch : String) : Byte;
  Function RCopy(InString : String; StartPosition,EndPosition : Byte) : String;
  Function HereToSpace(InString : String; Start : Byte) : String;
{========================================================================}
Implementation
{========================================================================}
Function MyStr(InVal : LongInt; MyStrLen : Byte) : String;
  Var
    OutString : String;
  Begin
    Str(InVal:MyStrLen,OutString);
    MyStr := OutString;
  End;
{========================================================================}
Function MyVal(InString : String) : LongInt;
  Var
    Return : LongInt;
    Code : Integer;
  Begin
    Val(InString,Return,Code);
    MyVal := Return;
  End;
{========================================================================}
Function AllTrim(InString : String) : String;
  Begin
    While (Copy(InString,1,1) = ^I) Or (Copy(InString,1,1) = ' ') Do Delete(InString,1,1);
    While (Copy(InString,Length(InString),1) = ^I) Or
          (Copy(InString,Length(InString),1) = ' ')
          Do Delete(InString,Length(InString),1);
    AllTrim := InString;
  End;
{========================================================================}
Function LoCase(InChar : Char) : Char;
  Begin
    If InChar In ['A'..'Z'] Then LoCase := Chr(Ord(InChar)+32) Else LoCase := InChar;
  End;
{========================================================================}
Function UpperString(InString : String) : String;
  Var
    Usb : Byte;
  Begin
    For Usb := 1 To Length(InString) Do InString[Usb] := UpCase(InString[Usb]);
    UpperString := InString;
  End;
{========================================================================}
Function LowerString(InString : String) : String;
  Var
    Lsb : Byte;
  Begin
    For Lsb := 1 To Length(InString) Do InString[Lsb] := LoCase(InString[Lsb]);
    LowerString := InString;
  End;
{========================================================================}
Function CapFirst(InString : String) : String;
  Begin
    InString := LowerString(InString);
    InString[1] := UpCase(InString[1]);
    CapFirst := InString;
  End;
{========================================================================}
Function InvertString(InString : String) : String;
  Var
    Isb : Byte;
    Iss : String;
  Begin
    Iss := '';
    For Isb := Length(InString) DownTo 1 Do Iss := Iss+InString[Isb];
    InvertString := Iss;
  End;
{========================================================================}
Function RPos(StringToFind,StringToSearch : String) : Byte;
  Begin
    RPos := Pos(InvertString(StringToFind),InvertString(StringToSearch));
  End;
{========================================================================}
Function RCopy(InString : String; StartPosition,EndPosition : Byte) : String;
  Begin
    InString := Copy(InvertString(InString),StartPosition,EndPosition);
    Rcopy := InvertString(InString);
  End;
{========================================================================}
Function HereToSpace(InString : String; Start : Byte) : String;
  Var
    Lbx : Byte;
    Lsx : String;
  Begin
    Lsx := '';
    For Lbx := Start To Length(InString) Do
    Begin
      If InString[Lbx] = ' ' Then Break;
      Lsx := Lsx+InString[Lbx];
    End;
    HereToSpace := Lsx;
  End;
{========================================================================}
Begin
End.
{========================================================================}
