Unit Max3Area;
{========================================================================}
Interface
  Uses
    Dos;
  Function Select3Area(AreaPath : PathStr; Var DnLdPath, FilesBbsPath : PathStr; Var OldArea : Word) : Byte;
{========================================================================}
Implementation
  Uses
    Crt, General, Help, MfmDefs, MfmStr, Screen, Setup, SlctDir;
  Const
    TopLine = 1;
    BottomLine = 23;
    BufferSize = $3FF;
  Type
    FareaRecType = Record
      cbArea, NumOver, cbHeap, Division : Word;
      Acs, Name, DownPath, UpPath, FilesBbs, Desc, MenuName, MenuReplace, Barricade, BarricadeMenu : Word;
      cbPrior : LongInt;
      Attribs : Word;
    End;
    FareaIdxType = Record
      Name : Array[0..15] Of Char;
      Hash, Offset : LongInt;
    End;
    BufPtrType = ^BufArrayType;
    BufArrayType = Array[0..BufferSize] Of Char;
    SubAreaRecType = Record
      Acs : String[40];
      Name : String[16];
      DownPath, UpPath, FilesBbs, Desc : PathStr;
    End;
  Var
    AreaFile : File;
    AreaIdx : File Of FareaIdxType;
    Buffer : BufPtrType;
    NumRead : Word;
    AreaIdxRec : FareaIdxType;
    AreaRec : ^FareaRecType;
    SubAreaRec : SubAreaRecType;
    TotalAreas, FirstArea, LastArea, AreaNum, TopArea, BottomArea : Word;
    Row, BottomRow : Byte;
{========================================================================}
Function GetField(FieldOffset : Word) : String;
  Var
    Gfw : Word;
    Gfs : String;
  Begin
    Gfw := AreaRec^.cbArea+FieldOffset;
    Gfs := '';
    While Buffer^[Gfw] <> #0 Do
    Begin
      Gfs := Gfs+Buffer^[Gfw];
      Inc(Gfw);
    End;
    GetField := Gfs;
  End;
{========================================================================}
Procedure GetArea(AreaNum : Word);
  Begin
    Seek(AreaIdx,AreaNum);
    Read(AreaIdx,AreaIdxRec);
    Seek(AreaFile,AreaIdxRec.Offset);
    BlockRead(AreaFile,Buffer^,BufferSize,NumRead);
    AreaRec := Addr(Buffer^);
    SubAreaRec.Acs := GetField(AreaRec^.Acs);
    SubAreaRec.Name := GetField(AreaRec^.Name);
    SubAreaRec.DownPath := GetField(AreaRec^.DownPath);
    SubAreaRec.UpPath := GetField(AreaRec^.UpPath);
    SubAreaRec.FilesBbs := GetField(AreaRec^.FilesBbs);
    SubAreaRec.Desc := GetField(AreaRec^.Desc);
  End;
{========================================================================}
Function GetTotalAreas : Word;
  Begin
    Assign(AreaIdx,Copy(AreaPath,1,Pos('.',AreaPath))+'IDX');
    FileMode := 64; {ReadOnly & DenyNone}
    Reset(AreaIdx);
    GetTotalAreas := FileSize(AreaIdx);
    Close(AreaIdx);
    FileMode := 2;
  End;
{========================================================================}
Procedure BlankCurrentLocation(Row : Byte);
  Begin
    AnsiGoWrite(1,Row,White,Black,No,' ');
    AnsiGoWrite(47,Row,White,Black,No,' ');
    AnsiGotoXY(80,24);
  End;
{========================================================================}
Procedure DisplayCurrentLocation(Row : Byte);
  Begin
    AnsiGoWrite(1,Row,White+Blink,Black,No,'>');
    AnsiGoWrite(47,Row,White+Blink,Black,No,'>');
    AnsiGoWrite(1,25,White,Black,Yes,SubAreaRec.Acs);
    AnsiGoWrite(45,25,White,Black,Yes,'');
    If AreaRec^.Attribs = 0 Then
    Begin
      If Length(SubAreaRec.FilesBbs) = 0 Then
      Begin
        MfmWrite(SubAreaRec.DownPath+'Files.Bbs');
      End
      Else
      Begin
        MfmWrite(SubAreaRec.FilesBbs);
      End;
    End;
    AnsiGoWrite(41,25,Yellow,Black,No,MatchType);
    If Numbers Then AnsiGoWrite(42,25,Yellow,Black,No,'#');
    AnsiGoWrite(43,25,Yellow,Black,No,MatchWhat);
    AnsiGotoXY(80,24);
  End;
{========================================================================}
Procedure DisplayRecord(Row : Byte);
  Begin
    AnsiGoWrite(1,Row,White,Black,No,' '+Copy(SubAreaRec.Name,1,4));
    AnsiGoWrite(7,Row,Yellow,Black,No,Copy(SubAreaRec.Desc,1,40));
    Case AreaRec^.Attribs Of
      $0000 : AnsiGoWrite(48,Row,LightGreen,Black,No,Copy(SubAreaRec.DownPath,1,30));
      $4000 : AnsiGoWrite(48,Row,LightRed,Black,No,'Begin File Division');
      $8000 : AnsiGoWrite(48,Row,LightRed,Black,No,'End File Division');
    End;
  End;
{========================================================================}
Procedure DisplayScreen;
  Var
    Row : Byte;
    AreaNum : Integer;
  Begin
    SetupScreen;
    Row := TopLine-1;
    AreaNum := TopArea;
    While (AreaNum <= LastArea) And (Row < BottomLine) Do
    Begin
      GetArea(AreaNum);
      Inc(Row); Inc(AreaNum);
      DisplayRecord(Row);
    End;
    BottomArea := AreaNum-1;
    BottomRow := Row;
    If Length(AreaMask) > 0 Then AnsiGoWrite(1,24,White,Black,Yes,AreaMask);
  End;
{========================================================================}
Procedure LineUp;
  Begin
    If AreaNum > FirstArea Then
    Begin
      If Row > TopLine Then
      Begin
        BlankCurrentLocation(Row); Dec(Row); Dec(AreaNum);
      End
      Else
      Begin
        Dec(TopArea); DisplayScreen; Dec(AreaNum);
      End;
      GetArea(AreaNum);
      DisplayCurrentLocation(Row);
    End;
  End;
{========================================================================}
Procedure LineDown;
  Begin
    If AreaNum < LastArea Then
    Begin
      If Row < BottomLine Then
      Begin
        BlankCurrentLocation(Row); Inc(Row); Inc(AreaNum);
      End
      Else
      Begin
        Inc(TopArea); DisplayScreen; Inc(AreaNum);
      End;
      GetArea(AreaNum);
      DisplayCurrentLocation(Row);
    End;
  End;
{========================================================================}
Procedure PageUp;
  Var
    Counter : Byte;
  Begin
    If AreaNum <> FirstArea Then
    Begin
      If TotalAreas <= BottomLine Then
      Begin
        AreaNum := FirstArea;
        BlankCurrentLocation(Row);
        Row := TopLine;
        GetArea(AreaNum);
        DisplayCurrentLocation(Row);
      End
      Else
      Begin
        If Row = TopLine Then
        Begin
          Counter := BottomLine;
          While (Counter > 1) And (AreaNum > FirstArea) Do
          Begin
            Dec(AreaNum); Dec(Counter);
            GetArea(AreaNum);
          End;
          TopArea := AreaNum;
          DisplayScreen;
          GetArea(AreaNum);
          DisplayCurrentLocation(Row);
        End
        Else
        Begin
          AreaNum := TopArea;
          BlankCurrentLocation(Row);
          Row := TopLine;
          GetArea(AreaNum);
          DisplayCurrentLocation(Row);
        End;
      End;
    End;
  End;
{========================================================================}
Procedure PageDown;
  Var
    Counter : Byte;
  Begin
    If Not ((Row = BottomLine) And (AreaNum = LastArea)) Then
    Begin
      If TotalAreas <= BottomLine Then
      Begin
        AreaNum := LastArea;
        BlankCurrentLocation(Row);
        Row := TotalAreas;
        GetArea(AreaNum);
        DisplayCurrentLocation(Row);
      End
      Else
      Begin
        If AreaNum = LastArea Then
        Begin
          For Counter := 1 To BottomLine-1 Do
          Begin
            Dec(AreaNum);
            GetArea(AreaNum);
          End;
          TopArea := AreaNum;
          DisplayScreen;
          Row := BottomLine;
          AreaNum := LastArea;
          GetArea(AreaNum);
          DisplayCurrentLocation(Row);
        End
        Else
        Begin
          If Row = BottomLine Then
          Begin
            TopArea := BottomArea;
            DisplayScreen;
            AreaNum := BottomArea;
            GetArea(AreaNum);
            Row := BottomRow;
            DisplayCurrentLocation(Row);
          End
          Else
          Begin
            AreaNum := BottomArea;
            BlankCurrentLocation(Row);
            Row := BottomLine;
            GetArea(AreaNum);
            DisplayCurrentLocation(Row);
          End;
        End;
      End;
    End;
  End;
{========================================================================}
Procedure TopOfList;
  Begin
    If TopArea <> FirstArea Then
    Begin
      TopArea := FirstArea;
      DisplayScreen;
    End
    Else
    Begin
      BlankCurrentLocation(Row);
    End;
    AreaNum := FirstArea;
    GetArea(AreaNum);
    Row := TopLine;
    DisplayCurrentLocation(Row);
  End;
{========================================================================}
Procedure BottomOfList;
  Var
    Counter : Byte;
  Begin
    If Not ((Row = BottomLine) And (AreaNum = LastArea)) Then
    Begin
      AreaNum := LastArea;
      If TotalAreas <= BottomLine Then
      Begin
        BlankCurrentLocation(Row);
        Row := TotalAreas;
        GetArea(AreaNum);
        DisplayCurrentLocation(Row);
      End
      Else
      Begin
        For Counter := 1 To BottomLine-1 Do
        Begin
          Dec(AreaNum);
          GetArea(AreaNum);
        End;
        TopArea := AreaNum;
        DisplayScreen;
        Row := BottomLine;
        AreaNum := LastArea;
        GetArea(AreaNum);
        DisplayCurrentLocation(Row);
      End;
    End;
  End;
{========================================================================}
Procedure MatchMask;
  Var
    Matched : Boolean;
    MatchMaskPos : Word;
    MatchPos : Byte;
  Begin
    Matched := False;
    For MatchMaskPos := 0 To LastArea Do
    Begin
      GetArea(MatchMaskPos);
      Case MatchWhat Of
        'D' : MatchPos := Pos(AreaMask,UpperString(SubAreaRec.Desc));
        'N' : MatchPos := Pos(AreaMask,UpperString(SubAreaRec.Name));
        'P' : MatchPos := Pos(AreaMask,UpperString(SubAreaRec.DownPath));
      End;
      Case MatchType Of
        'A' : Begin
                If MatchPos > 0 Then
                Begin
                  Matched := True;
                  Break;
                End;
              End;
        'F' : Begin
                If MatchPos = 1 Then
                Begin
                  Matched := True;
                  Break;
                End;
              End;
      End;
    End;
    If Matched Then
    Begin
      AreaNum := MatchMaskPos;
      If (AreaNum < TopArea) Or (AreaNum > TopArea+20) Then
      Begin
        TopArea := AreaNum;
        Row := 1;
        DisplayScreen;
        GetArea(AreaNum);
        DisplayCurrentLocation(Row);
      End
      Else
      Begin
        BlankCurrentLocation(Row);
        GetArea(AreaNum);
        Row := (AreaNum-TopArea)+1;
        DisplayCurrentLocation(Row);
      End;
    End
    Else
    Begin
      Delete(AreaMask,Length(AreaMask),1);
    End;
    If Length(AreaMask) = 0 Then
    Begin
      If (Row > 1) Or (AreaNum > 1) Or (TopArea > 1) Then
      Begin
        If TopArea <> 1 Then
        Begin
          TopArea := 0;
          DisplayScreen;
        End
        Else BlankCurrentLocation(Row);
        Row := 1;
        AreaNum := 1;
        GetArea(AreaNum);
        DisplayCurrentLocation(Row);
      End;
    End;
    AnsiGoWrite(1,24,White,Black,Yes,AreaMask);
  End;
{========================================================================}
Function Select3Area(AreaPath : PathStr; Var DnLdPath, FilesBbsPath : PathStr; Var OldArea : Word) : Byte;
  Var
    Sab, Counter : Byte;
    Sac : Char;
    TempAreaPath : PathStr;
  Begin
    If UseSlctDir Or (Not FileExist(AreaPath)) Then
    Begin
      Select3Area := SelectDir(DnLdPath);
      FilesBbsPath := DnLdPath+'Files.Bbs';
    End
    Else
    Begin
      If FileExist(AreaPath) Then
      Begin
        TotalAreas := GetTotalAreas;
        Assign(AreaFile,AreaPath);
        FileMode := 64; {ReadOnly & DenyNone}
        Reset(AreaFile,1);
        Assign(AreaIdx,Copy(AreaPath,1,Pos('.',AreaPath))+'IDX');
        Reset(AreaIdx);
        New(Buffer);
        Select3Area := 0;
        AreaMask := '';
        Numbers := False;
        MatchWhat := 'D';
        MatchType := 'A';
        FirstArea := 0; AreaNum := 0; Row := 1;
        LastArea := TotalAreas-1;
        If TotalAreas > 0 Then
        Begin
          If OldArea = $FFFF Then
          Begin
            OldArea := FirstArea;
            TopArea := FirstArea;
            DisplayScreen;
          End
          Else
          Begin
            AreaNum := OldArea;
            Counter := BottomLine;
            While (Counter > 1) And (AreaNum > FirstArea) Do
            Begin
              Dec(AreaNum); Dec(Counter);
              GetArea(AreaNum);
            End;
            TopArea := AreaNum;
            DisplayScreen;
            Row := (BottomLine-Counter)+1;
          End;
          AreaNum := OldArea;
          GetArea(AreaNum);
          DisplayCurrentLocation(Row);
          Repeat
            GetArea(AreaNum);
            Sab := GetInput;
            Sac := Upcase(Chr(Sab));
            If Sab = 0 Then
            Begin
              Sab := GetInput;
              Case Sab Of
                71 : Sac := '7';
                72 : Sac := '8';
                73 : Sac := '9';
                75 : Sac := '4';
                77 : Sac := '6';
                79 : Sac := '1';
                80 : Sac := '2';
                81 : Sac := '3';
              End;
            End;
            Case Sac Of
              ^D  : Begin
                      MatchWhat := 'D';
                      Numbers := False;
                      MatchType := 'A';
                      DisplayCurrentLocation(Row);
                    End;
              ^N  : Begin
                      MatchWhat := 'N';
                      Numbers := True;
                      MatchType := 'F';
                      DisplayCurrentLocation(Row);
                    End;
              ^P  : Begin
                      MatchWhat := 'P';
                      Numbers := False;
                      MatchType := 'A';
                      DisplayCurrentLocation(Row);
                    End;
              ^T  : Begin
                      If MatchType = 'F' Then MatchType := 'A' Else MatchType := 'F';
                      DisplayCurrentLocation(Row);
                    End;
              ^I  : Begin
                      If TabOk Then
                      Begin
                        AnsiClearScreen;
                        TempAreaPath := SubAreaRec.DownPath;
                        If SelectDir(TempAreaPath) > 0 Then
                        Begin
                          Sac := ' ';
                          DisplayScreen;
                          GetArea(AreaNum);
                          DisplayCurrentLocation(Row);
                        End
                        Else
                        Begin
                          DnLdPath := TempAreaPath;
                          FilesBbsPath := DnLdPath+'Files.Bbs';
                        End;
                      End
                      Else
                      Begin
                        Sac := ' ';
                      End;
                    End;
              '?' : Begin
                      AreaHelp;
                      DisplayScreen;
                      GetArea(AreaNum);
                      DisplayCurrentLocation(Row);
                    End;
              ^M  : Begin
                      If AreaRec^.Attribs > 0 Then
                      Begin
                        Sac := ' ';
                        AnsiGoWrite(1,25,White,Black,Yes,'No files exist in a file division!');
                      End;
                    End;
              '#' : Begin
                      Numbers := Not Numbers;
                      DisplayCurrentLocation(Row);
                    End;
               ^H : Begin
                      Delete(AreaMask,Length(AreaMask),1);
                      MatchMask;
                    End;
               ^Y : Begin
                      AreaMask := '';
                      MatchMask;
                    End;
            Else
              If Numbers Then
              Begin
                If Sac In [' ',':','\','0'..'9','A'..'Z','a'..'z'] Then
                Begin
                  AreaMask := AreaMask + Sac;
                  MatchMask;
                End;
              End
              Else
              Begin
                Case Sac Of
                  '8' : LineUp;
                  '2' : LineDown;
                  '9' : PageUp;
                  '3' : PageDown;
                  '7' : TopOfList;
                  '1' : BottomOfList;
                Else
                  If Sac In [' ',':','\','A'..'Z','a'..'z'] Then
                  Begin
                    AreaMask := AreaMask + Sac;
                    MatchMask;
                  End;
                End;
              End;
            End;
          Until Sac In [^I,^M,^Q,^[];
          If Sac = ^M Then
          Begin
            DnLdPath := SubAreaRec.DownPath;
            FilesBbsPath := SubAreaRec.FilesBbs;
            AreaName := SubAreaRec.Name;
            If Length(FilesBbsPath) = 0 Then FilesBbsPath := DnLdPath+'Files.Bbs';
          End;
          If Sac = ^Q Then Select3Area := 253;
          If Sac = ^[ Then Select3Area := 252;
        End;
        Dispose(Buffer);
        Close(AreaIdx); Close(AreaFile);
        FileMode := 2;
      End
      Else
      Begin
        Select3Area := 255; {AreaPath does not exist}
      End;
      If Sac = ^M Then OldArea := AreaNum;
    End;
  End;
{========================================================================}
Begin
End.
{========================================================================}
