Unit Max2Area;
{========================================================================}
Interface
  Uses
    Dos;
  Function Select2Area(AreaPath : PathStr; Var DnLdPath, FilesBbsPath : PathStr; Var OldArea : Word) : Byte;
{========================================================================}
Implementation
  Uses
    Crt, General, Help, MfmDefs, MfmStr, Screen, Setup, SlctDir, Strings;
  Const
    MaxClass = 12;
    MaxOvr = 16;
    TopLine = 1;
    BottomLine = 23;
  Type
    Override = Record
      Priv : Integer;
      Lock1, lock2 : Word;
      Ch : Char;
      Fill : Byte;
    End;
    AreaRecordType = Record
      Id : Array[0..3] Of Char;
      StructLen : Word;
      AreaNo : Array[0..1] Of Char;
      Name : Array[0..39] Of Char;
      AreaType : Word;
      MsgPath : Array[0..79] Of Char;
      MsgName : Array[0..39] Of Char;
      MsgInfo, MsgBar : Array[0..79] Of Char;
      Origin : Array[0..61] Of Char;
      MsgPriv : Integer;
      MsgLock, Fill1 : Byte;
      OriginAka : Word;
      FilePath, UpPath, FileBar, FilesBbs, FileInfo : Array[0..79] Of Char;
      FilePriv : Integer;
      FileLock, Fill2 : Byte;
      MsgMenuName, FileMenuName : Array[0..12] Of Char;
      Attrib : Array[1..MaxClass] Of Word;
      Movr : Array[1..MaxOvr] Of Override;
      Fovr : Array[1..MaxOvr] Of Override;
      MsgLock1, MsgLock2, FileLock1, FileLock2 : Word;
      KillByAge, KillByNum : Word;
    End;
  Var
    StructLen : Word;
    TotalAreas, FirstArea, LastArea, AreaNum, TopArea, BottomArea : Word;
    RecordBuffer : Pointer;
    AreaDat : File;
    MaxAreaRecord : ^AreaRecordType;
    Row, BottomRow : Byte;
{========================================================================}
Function OpenMaxArea(AreaPath : PathStr) : Boolean;
  Begin
    Assign(AreaDat,AreaPath);
    FileMode := 64; {ReadOnly & DenyNone}
    {$I-} Reset(AreaDat,1); {$I+}
    If DosError = 0 Then
    Begin
      OpenMaxArea := True;
      Seek(AreaDat,4);
      BlockRead(AreaDat,StructLen,SizeOf(StructLen));
      TotalAreas := FileSize(AreaDat) Div StructLen;
      GetMem(RecordBuffer,StructLen);
    End
    Else
    Begin
      OpenMaxArea := False;
    End;
  End;
{========================================================================}
Function GetMaxArea(AreaNo : LongInt) : Byte;
  Begin
    If (StructLen*AreaNo) > FileSize(AreaDat) Then
    Begin
      GetMaxArea := 254;
    End
    Else
    Begin
      Seek(AreaDat,StructLen*(AreaNo-1));
      BlockRead(AreaDat,RecordBuffer^,StructLen);
      GetMaxArea := 0;
    End;
  End;
{========================================================================}
Procedure CloseMaxArea;
  Begin
    Close(AreaDat);
    FreeMem(RecordBuffer,StructLen);
  End;
{========================================================================}
Function Priv(PrivIn : Integer) : String;
  Begin
    Case PrivIn Of
     -2 : Priv := 'Twit';
      0 : Priv := 'Disgrace';
      1 : Priv := 'Limited';
      2 : Priv := 'Normal';
      3 : Priv := 'Worthy';
      4 : Priv := 'Privil';
      5 : Priv := 'Favored';
      6 : Priv := 'Extra';
      7 : Priv := 'Clerk';
      8 : Priv := 'AsstSysop';
     10 : Priv := 'Sysop';
     11 : Priv := 'Hidden';
    Else
      Priv := 'Hidden';
    End;
  End;
{========================================================================}
Function Keys(Keys1, Keys2 : Word) : String;
  Var
    Ks : String;
  Begin
    Ks := '';
    If Keys1+Keys2 > 0 Then
    Begin
      Ks := '/';
      If (Keys1 And 1) = 1 Then Ks := Ks+'1';
      If (Keys1 And 2) = 2 Then Ks := Ks+'2';
      If (Keys1 And 4) = 4 Then Ks := Ks+'3';
      If (Keys1 And 8) = 8 Then Ks := Ks+'4';
      If (Keys1 And 16) = 16 Then Ks := Ks+'5';
      If (Keys1 And 32) = 32 Then Ks := Ks+'6';
      If (Keys1 And 64) = 64 Then Ks := Ks+'7';
      If (Keys1 And 128) = 128 Then Ks := Ks+'8';
      If (Keys1 And 256) = 256 Then Ks := Ks+'A';
      If (Keys1 And 512) = 512 Then Ks := Ks+'B';
      If (Keys1 And 1024) = 1024 Then Ks := Ks+'C';
      If (Keys1 And 2048) = 2048 Then Ks := Ks+'D';
      If (Keys1 And 4096) = 4096 Then Ks := Ks+'E';
      If (Keys1 And 8192) = 8192 Then Ks := Ks+'F';
      If (Keys1 And 16384) = 16384 Then Ks := Ks+'G';
      If (Keys1 And 32768) = 32768 Then Ks := Ks+'H';
      If (Keys2 And 1) = 1 Then Ks := Ks+'I';
      If (Keys2 And 2) = 2 Then Ks := Ks+'J';
      If (Keys2 And 4) = 4 Then Ks := Ks+'K';
      If (Keys2 And 8) = 8 Then Ks := Ks+'L';
      If (Keys2 And 16) = 16 Then Ks := Ks+'M';
      If (Keys2 And 32) = 32 Then Ks := Ks+'N';
      If (Keys2 And 64) = 64 Then Ks := Ks+'O';
      If (Keys2 And 128) = 128 Then Ks := Ks+'P';
      If (Keys2 And 256) = 256 Then Ks := Ks+'Q';
      If (Keys2 And 512) = 512 Then Ks := Ks+'R';
      If (Keys2 And 1024) = 1024 Then Ks := Ks+'S';
      If (Keys2 And 2048) = 2048 Then Ks := Ks+'T';
      If (Keys2 And 4096) = 4096 Then Ks := Ks+'U';
      If (Keys2 And 8192) = 8192 Then Ks := Ks+'V';
      If (Keys2 And 16384) = 16384 Then Ks := Ks+'W';
      If (Keys2 And 32768) = 32768 Then Ks := Ks+'X';
    End;
    Keys := Ks;
  End;
{========================================================================}
Procedure BlankCurrentLocation(Row : Byte);
  Begin
    AnsiGoWrite(1,Row,White,Black,No,' ');
    AnsiGoWrite(47,Row,White,Black,No,' ');
    AnsiGotoXY(80,24);
  End;
{========================================================================}
Procedure DisplayCurrentLocation(Row : Byte);
  Begin
    AnsiGoWrite(1,Row,White+Blink,Black,No,'>');
    AnsiGoWrite(47,Row,White+Blink,Black,No,'>');
    AnsiGoWrite(1,25,White,Black,Yes,Priv(MaxAreaRecord^.FilePriv)+Keys(MaxAreaRecord^.FileLock1,MaxAreaRecord^.FileLock2));
    AnsiGotoXY(45,25);
    If StrLen(MaxAreaRecord^.FilesBbs) = 0 Then
    Begin
      MfmWrite(StrPas(MaxAreaRecord^.FilePath)+'Files.Bbs');
    End
    Else
    Begin
      MfmWrite(StrPas(MaxAreaRecord^.FilesBbs));
    End;
    AnsiGoWrite(41,25,Yellow,Black,No,MatchType);
    If Numbers Then AnsiGoWrite(42,25,Yellow,Black,No,'#');
    AnsiGoWrite(43,25,Yellow,Black,No,MatchWhat);
    AnsiGotoXY(80,24);
  End;
{========================================================================}
Procedure DisplayRecord(Row : Byte);
  Var
    AreaLine : Array[0..79] Of Char;
  Begin
    StrLCopy(AreaLine,MaxAreaRecord^.Name,4);
    AnsiGoWrite(1,Row,White,Black,No,' '+StrPas(AreaLine));
    StrLCopy(AreaLine,MaxAreaRecord^.FileInfo,40);
    AnsiGoWrite(7,Row,Yellow,Black,No,StrPas(AreaLine));
    StrLCopy(AreaLine,MaxAreaRecord^.FilePath,30);
    AnsiGoWrite(48,Row,LightGreen,Black,No,StrPas(AreaLine));
  End;
{========================================================================}
Procedure DisplayScreen;
  Var
    Row : Byte;
    AreaNum : Integer;
  Begin
    SetupScreen;
    Row := TopLine-1;
    AreaNum := TopArea;
    While (AreaNum <= LastArea) And (Row < BottomLine) Do
    Begin
      GetMaxArea(AreaNum);
      While (StrLen(MaxAreaRecord^.FilePath) = 0) And (AreaNum < LastArea) Do
      Begin
        Inc(AreaNum);
        GetMaxArea(AreaNum);
      End;
      BottomArea := AreaNum;
      If StrLen(MaxAreaRecord^.FilePath) > 0 Then
      Begin
        Inc(Row); Inc(AreaNum);
        DisplayRecord(Row);
      End;
      BottomRow := Row;
    End;
  End;
{========================================================================}
Procedure LineUp;
  Begin
    If AreaNum > FirstArea Then
    Begin
      If Row > TopLine Then
      Begin
        BlankCurrentLocation(Row); Dec(Row); Dec(AreaNum);
      End
      Else
      Begin
        Dec(TopArea); DisplayScreen; Dec(AreaNum);
      End;
      GetMaxArea(AreaNum);
      While (StrLen(MaxAreaRecord^.FilePath) = 0) And (AreaNum > FirstArea) Do
      Begin
        Dec(AreaNum); GetMaxArea(AreaNum);
      End;
      DisplayCurrentLocation(Row);
    End;
  End;
{========================================================================}
Procedure LineDown;
  Begin
    If AreaNum < LastArea Then
    Begin
      If Row < BottomLine Then
      Begin
        BlankCurrentLocation(Row); Inc(Row); Inc(AreaNum);
      End
      Else
      Begin
        Inc(TopArea); DisplayScreen; Inc(AreaNum);
      End;
      GetMaxArea(AreaNum);
      While (StrLen(MaxAreaRecord^.FilePath) = 0) And (AreaNum < LastArea) Do
      Begin
        Inc(AreaNum); GetMaxArea(AreaNum);
      End;
      DisplayCurrentLocation(Row);
    End;
  End;
{========================================================================}
Procedure PageUp;
  Var
    Counter : Byte;
  Begin
    If AreaNum <> FirstArea Then
    Begin
      If TotalAreas <= BottomLine Then
      Begin
        AreaNum := FirstArea;
        BlankCurrentLocation(Row);
        Row := TopLine;
        GetMaxArea(AreaNum);
        DisplayCurrentLocation(Row);
      End
      Else
      Begin
        If Row = TopLine Then
        Begin
          Counter := BottomLine;
          While (Counter > 1) And (AreaNum > FirstArea) Do
          Begin
            Dec(AreaNum); Dec(Counter);
            GetMaxArea(AreaNum);
            While (StrLen(MaxAreaRecord^.FilePath) = 0) And (AreaNum > FirstArea) Do
            Begin
              Dec(AreaNum); GetMaxArea(AreaNum);
            End;
          End;
          TopArea := AreaNum;
          DisplayScreen;
          GetMaxArea(AreaNum);
          DisplayCurrentLocation(Row);
        End
        Else
        Begin
          AreaNum := TopArea;
          BlankCurrentLocation(Row);
          Row := TopLine;
          GetMaxArea(AreaNum);
          DisplayCurrentLocation(Row);
        End;
      End;
    End;
  End;
{========================================================================}
Procedure PageDown;
  Var
    Counter : Byte;
  Begin
    If Not ((Row = BottomLine) And (AreaNum = LastArea)) Then
    Begin
      If TotalAreas <= BottomLine Then
      Begin
        AreaNum := LastArea;
        BlankCurrentLocation(Row);
        Row := TotalAreas;
        GetMaxArea(AreaNum);
        DisplayCurrentLocation(Row);
      End
      Else
      Begin
        If AreaNum = LastArea Then
        Begin
          For Counter := 1 To BottomLine-1 Do
          Begin
            Dec(AreaNum);
            GetMaxArea(AreaNum);
            While (StrLen(MaxAreaRecord^.FilePath) = 0) And (AreaNum > FirstArea) Do
            Begin
              Dec(AreaNum); GetMaxArea(AreaNum);
            End;
          End;
          TopArea := AreaNum;
          DisplayScreen;
          Row := BottomLine;
          AreaNum := LastArea;
          GetMaxArea(AreaNum);
          DisplayCurrentLocation(Row);
        End
        Else
        Begin
          If Row = BottomLine Then
          Begin
            TopArea := BottomArea;
            DisplayScreen;
            AreaNum := BottomArea;
            GetMaxArea(AreaNum);
            Row := BottomRow;
            DisplayCurrentLocation(Row);
          End
          Else
          Begin
            AreaNum := BottomArea;
            BlankCurrentLocation(Row);
            Row := BottomLine;
            GetMaxArea(AreaNum);
            DisplayCurrentLocation(Row);
          End;
        End;
      End;
    End;
  End;
{========================================================================}
Procedure TopOfList;
  Begin
    If TopArea <> FirstArea Then
    Begin
      TopArea := FirstArea;
      DisplayScreen;
    End
    Else
    Begin
      BlankCurrentLocation(Row);
    End;
    AreaNum := FirstArea;
    GetMaxArea(AreaNum);
    Row := TopLine;
    DisplayCurrentLocation(Row);
  End;
{========================================================================}
Procedure BottomOfList;
  Var
    Counter : Byte;
  Begin
    If Not ((Row = BottomLine) And (AreaNum = LastArea)) Then
    Begin
      AreaNum := LastArea;
      If TotalAreas <= BottomLine Then
      Begin
        BlankCurrentLocation(Row);
        Row := TotalAreas;
        GetMaxArea(AreaNum);
        DisplayCurrentLocation(Row);
      End
      Else
      Begin
        For Counter := 1 To BottomLine-1 Do
        Begin
          Dec(AreaNum);
          GetMaxArea(AreaNum);
          While (StrLen(MaxAreaRecord^.FilePath) = 0) And (AreaNum > FirstArea) Do
          Begin
            Dec(AreaNum); GetMaxArea(AreaNum);
          End;
        End;
        TopArea := AreaNum;
        DisplayScreen;
        Row := BottomLine;
        AreaNum := LastArea;
        GetMaxArea(AreaNum);
        DisplayCurrentLocation(Row);
      End;
    End;
  End;
{========================================================================}
Procedure MatchMask;
  Var
    AreaPointer : AreaPtr;
    AreaPointerPosition, MatchPos : Byte;
    Matched : Boolean;
    MatchMaskPos : Word;
  Begin
    Matched := False;
    For MatchMaskPos := 1 To LastArea Do
    Begin
      GetMaxArea(MatchMaskPos);
      Case MatchWhat Of
        'D' : MatchPos := Pos(AreaMask,UpperString(StrPas(MaxAreaRecord^.FileInfo)));
        'N' : MatchPos := Pos(AreaMask,UpperString(StrPas(MaxAreaRecord^.Name)));
        'P' : MatchPos := Pos(AreaMask,UpperString(StrPas(MaxAreaRecord^.FilePath)));
      End;
      Case MatchType Of
        'A' : Begin
                If MatchPos > 0 Then
                Begin
                  Matched := True;
                  Break;
                End;
              End;
        'F' : Begin
                If MatchPos = 1 Then
                Begin
                  Matched := True;
                  Break;
                End;
              End;
      End;
    End;
    If Matched Then
    Begin
      AreaNum := MatchMaskPos;
      If (AreaNum < TopArea) Or (AreaNum > TopArea+20) Then
      Begin
        TopArea := AreaNum;
        Row := 1;
        DisplayScreen;
        GetMaxArea(AreaNum);
        DisplayCurrentLocation(Row);
      End
      Else
      Begin
        BlankCurrentLocation(Row);
      { DisplayScreen; }
        GetMaxArea(AreaNum);
        Row := (AreaNum-TopArea)+1;
        DisplayCurrentLocation(Row);
      End;
    End
    Else
    Begin
      Delete(AreaMask,Length(AreaMask),1);
    End;
    If Length(AreaMask) = 0 Then
    Begin
      If (Row > 1) Or (AreaNum > 1) Or (TopArea > 1) Then
      Begin
        If TopArea <> 1 Then
        Begin
          TopArea := 1;
          DisplayScreen;
        End
        Else BlankCurrentLocation(Row);
        Row := 1;
        AreaNum := 1;
        GetMaxArea(AreaNum);
        DisplayCurrentLocation(Row);
      End;
    End;
    AnsiGoWrite(1,24,White,Black,Yes,AreaMask);
  End;
{========================================================================}
Function Select2Area(AreaPath : PathStr; Var DnLdPath, FilesBbsPath : PathStr; Var OldArea : Word) : Byte;
  Var
    Sab, Counter : Byte;
    Sac : Char;
    TempAreaPath : PathStr;
  Begin
    If UseSlctDir Or (Not FileExist(AreaPath)) Then
    Begin
      Select2Area := SelectDir(DnLdPath);
      FilesBbsPath := DnLdPath+'Files.Bbs';
    End
    Else
    Begin
      Select2Area := 0;
      AreaMask := '';
      Numbers := False;
      MatchWhat := 'D'; MatchType := 'A';
      If FileExist(AreaPath) Then
      Begin
        If OpenMaxArea(AreaPath) Then
        Begin
          TotalAreas := 0; FirstArea := 0; LastArea := 0; AreaNum := 1;
          While GetMaxArea(AreaNum) = 0 Do
          Begin
            MaxAreaRecord := RecordBuffer;
            If StrLen(MaxAreaRecord^.FilePath) > 0 Then
            Begin
              Inc(TotalAreas);
              LastArea := AreaNum;
            End;
            Inc(AreaNum);
          End;
          If TotalAreas > 0 Then
          Begin
            Repeat
              GetMaxArea(AreaNum);
              MaxAreaRecord := RecordBuffer;
              If StrLen(MaxAreaRecord^.FilePath) > 0 Then FirstArea := AreaNum;
              Dec(AreaNum);
            Until AreaNum = 0;
            If OldArea = $FFFF Then
            Begin
              OldArea := FirstArea;
              TopArea := FirstArea;
            End;
            If TopArea = OldArea Then
            Begin
              DisplayScreen;
              Row := TopLine;
            End
            Else
            Begin
              AreaNum := OldArea;
              Counter := BottomLine;
              While (Counter > 1) And (AreaNum > FirstArea) Do
              Begin
                Dec(AreaNum); Dec(Counter);
                GetMaxArea(AreaNum);
                While (StrLen(MaxAreaRecord^.FilePath) = 0) And (AreaNum > FirstArea) Do
                Begin
                  Dec(AreaNum); GetMaxArea(AreaNum);
                End;
              End;
              TopArea := AreaNum;
              DisplayScreen;
              Row := (BottomLine-Counter)+1;
            End;
            AreaNum := OldArea;
            GetMaxArea(AreaNum);
            DisplayCurrentLocation(Row);
            Repeat
              GetMaxArea(AreaNum);
              Sab := GetInput;
              Sac := Upcase(Chr(Sab));
              If Sab = 0 Then
              Begin
                Sab := GetInput;
                Case Sab Of
                  71 : Sac := '7';
                  72 : Sac := '8';
                  73 : Sac := '9';
                  75 : Sac := '4';
                  77 : Sac := '6';
                  79 : Sac := '1';
                  80 : Sac := '2';
                  81 : Sac := '3';
                End;
              End;
              Case Sac Of
                ^D  : Begin
                        MatchWhat := 'D';
                        Numbers := False;
                        MatchType := 'A';
                        DisplayCurrentLocation(Row);
                      End;
                ^N  : Begin
                        MatchWhat := 'N';
                        Numbers := True;
                        MatchType := 'F';
                        DisplayCurrentLocation(Row);
                      End;
                ^P  : Begin
                        MatchWhat := 'P';
                        Numbers := False;
                        MatchType := 'A';
                        DisplayCurrentLocation(Row);
                      End;
                ^T  : Begin
                        If MatchType = 'F' Then MatchType := 'A' Else MatchType := 'F';
                        DisplayCurrentLocation(Row);
                      End;
                ^I  : Begin
                        If TabOk Then
                        Begin
                          AnsiClearScreen;
                          TempAreaPath := StrPas(MaxAreaRecord^.FilePath);
                          If SelectDir(TempAreaPath) > 0 Then
                          Begin
                            Sac := ' ';
                            DisplayScreen;
                            GetMaxArea(AreaNum);
                            DisplayCurrentLocation(Row);
                          End
                          Else
                          Begin
                            DnLdPath := TempAreaPath;
                            FilesBbsPath := DnLdPath+'Files.Bbs';
                          End;
                        End
                        Else
                        Begin
                          Sac := ' ';
                        End;
                      End;
                '?' : Begin
                        AreaHelp;
                        DisplayScreen;
                        GetMaxArea(AreaNum);
                        DisplayCurrentLocation(Row);
                      End;
                '#' : Begin
                        Numbers := Not Numbers;
                        DisplayCurrentLocation(Row);
                      End;
                 ^H : Begin
                        Delete(AreaMask,Length(AreaMask),1);
                        MatchMask;
                      End;
                 ^Y : Begin
                        AreaMask := '';
                        MatchMask;
                      End;
              Else
                If Numbers Then
                Begin
                  If Sac In [' ',':','\','0'..'9','A'..'Z','a'..'z'] Then
                  Begin
                    AreaMask := AreaMask + Sac;
                    MatchMask;
                  End;
                End
                Else
                Begin
                  Case Sac Of
                    '8' : LineUp;
                    '2' : LineDown;
                    '9' : PageUp;
                    '3' : PageDown;
                    '7' : TopOfList;
                    '1' : BottomOfList;
                  Else
                    If Sac In [' ',':','\','A'..'Z','a'..'z'] Then
                    Begin
                      AreaMask := AreaMask + Sac;
                      MatchMask;
                    End;
                  End;
                End;
              End;
            Until Sac In [^I,^M,^Q,^[];
            If Sac = ^M Then
            Begin
              DnLdPath := StrPas(MaxAreaRecord^.FilePath);
              FilesBbsPath := StrPas(MaxAreaRecord^.FilesBbs);
              AreaName := StrPas(MaxAreaRecord^.Name);
              If Length(FilesBbsPath) = 0 Then FilesBbsPath := DnLdPath+'Files.Bbs';
            End;
            If Sac = ^Q Then Select2Area := 253;
            If Sac = ^[ Then Select2Area := 252;
          End;
          CloseMaxArea;
        End
        Else
        Begin
          Select2Area := 254; {Not able to open AreaPath}
        End;
      End
      Else
      Begin
        Select2Area := 255; {AreaPath does not exist}
      End;
      If Sac = ^M Then OldArea := AreaNum;
    End;
  End;
{========================================================================}
Begin
End.
{========================================================================}
