Unit General;
{========================================================================}
Interface
  Uses
    Dos, MfmDefs;
  Function FileExt(InFileName : PathStr) : ExtStr;
  Function FileExist(FileToCheck : PathStr) : Boolean;
  Function DirExist(Var DirToCheck : PathStr) : Boolean;
  Procedure MyErase(FileToErase : PathStr);
  Procedure MyRename(InName, OutName : PathStr);
  Function AnyKey : Byte;
  Function HexByte(Hbb : Byte) : S2;
  Function HexWord(Hww : Word) : S4;
  Function HexDw(Hdw : LongInt) : S8;
  Procedure ItoA2(I : Integer; Var Sp);
  Function FormatDate(Date : Word) : String;
  Function FormatTime(Time : Word) : String;
  Procedure RemotePage;
  Function Space(NumberOfSpaces : Byte) : String;
{========================================================================}
Implementation
  Uses
    Crt, Screen;
{========================================================================}
Function FileExt(InFileName : PathStr) : ExtStr;
  Begin
    FSplit(InFileName,D,N,E);
    FileExt := E;
  End;
{========================================================================}
Function FileExist(FileToCheck : PathStr) : Boolean;
  Begin
    FindFirst(FileToCheck,Archive+ReadOnly+Hidden+SysFile,DirInfo);
    If DosError = 0 Then FileExist := True Else FileExist := False;
  End;
{========================================================================}
Function DirExist(Var DirToCheck : PathStr) : Boolean;
  Var
    DirSave : DirStr;
  Begin
    GetDir(0,DirSave);
    If Copy(DirToCheck,Length(DirToCheck),1) = '\' Then Delete(DirToCheck,Length(DirToCheck),1);
    {$I-} ChDir(DirToCheck); {$I+}
    If IOresult = 0 Then DirExist := True Else DirExist := False;
    DirToCheck := DirToCheck+'\';
    ChDir(DirSave);
  End;
{========================================================================}
Procedure MyErase(FileToErase : PathStr);
  Var
    Mef : File;
  Begin
    If FileExist(FileToErase) Then
    Begin
      Assign(Mef,FileToErase);
      Erase(Mef);
    End;
  End;
{========================================================================}
Procedure MyRename(InName, OutName : PathStr);
  Var
    Mrf : File;
  Begin
    If FileExist(InName) Then
    Begin
      MyErase(OutName);
      Assign(Mrf,InName);
      Rename(Mrf,OutName);
    End;
  End;
{========================================================================}
Function AnyKey : Byte;
  Begin
    AnsiWrite(LightGray,Black,'Press any key to continue ');
    AnyKey := GetInput;
  End;
{========================================================================}
Function HexByte(Hbb : Byte) : S2;
  Const
    Hbc : Array[0..15] Of Char = '0123456789ABCDEF';
  Var
    Hbs : String[2];
  Begin
    Hbs := Hbc[Hbb Div 16] + Hbc[Hbb Mod 16];
    If Length(Hbs) = 1 Then Hbs := '0' + Hbs;
    HexByte := Hbs;
  End;
{========================================================================}
Function HexWord(Hww : Word) : S4;
  Begin
    HexWord := HexByte(Hww Div 256) + HexByte(Hww Mod 256);
  End;
{========================================================================}
Function HexDw(Hdw : LongInt) : S8;
  Begin
    HexDw := (HexWord(Hdw Shr 16)) + (HexWord(Hdw));
  End;
{========================================================================}
Procedure ItoA2(I : Integer; Var Sp);
  Var
    S : Array[1..2] Of Char Absolute Sp;
  Begin
    S[1] := Chr((I Div 10)+Ord('0'));
    S[2] := Chr((I Mod 10)+Ord('0'));
  End;
{========================================================================}
Function FormatDate(Date : Word) : String;
  Const
    S : String[8] = 'mm-dd-yy';
  Begin
    ItoA2(((Date Shr 9) And 127)+80, S[7]);
    ItoA2((Date Shr 5) And 15, S[1]);
    ItoA2(Date And 31, S[4]);
    FormatDate := S;
  End;
{========================================================================}
Function FormatTime(Time : Word) : String;
  Const
    S : String[8] = 'hh:mm';
  Begin
    ItoA2((Time Shr 11) And 31, S[1]);
    ItoA2((Time Shr 5) And 63, S[4]);
    FormatTime := S;
  End;
{========================================================================}
Procedure RemotePage;
  Begin
    Sound(444);
    Delay(200);

    Sound(590);
    Delay(40);

    Sound(790);
    Delay(400);

    Sound(750);
    Delay(150);

    Sound(590);
    Delay(150);

    Sound(500);
    Delay(200);

    Sound(670);
    Delay(200);

    Sound(900);
    Delay(400);

    NoSound;
  End;
{========================================================================}
Function Space(NumberOfSpaces : Byte) : String;
  Var
    SpaceString : String;
  Begin
    FillChar(SpaceString, SizeOf(SpaceString), ' ');
    SpaceString[0] := Char(NumberOfSpaces);
    Space := SpaceString;
  End;
{========================================================================}
Begin
End.
{========================================================================}
