Unit Fossil;
{========================================================================}
Interface
  Uses
    Dos;
  Var
    Msr : Registers;
    ComPort : Byte;
  Function F_Intr_14(Ax_Input : Word) : Word;
  Procedure P_Intr_14(Ah, Al : Byte);
  Function SignOn : Boolean;
  Procedure SignOff;
  Procedure RaiseDtr;
  Procedure LowerDtr;
  Procedure SetParameters(BaudRate : String);
  Function Status : Integer;
  Function CD : Boolean;
  Procedure ClearReceiveBuffer;
{========================================================================}
Implementation
{========================================================================}
Function F_Intr_14(Ax_Input : Word) : Word;
  Begin
    With Msr Do
    Begin
      Ax := Ax_Input; Dx := ComPort; Intr($14,Msr); F_Intr_14 := Ax;
    End;
  End;
{========================================================================}
Procedure P_Intr_14(Ah, Al : Byte);
  Begin
    Msr.Ah := Ah; Msr.Al := Al; Msr.Dx := ComPort; Intr($14,Msr);
  End;
{========================================================================}
Function SignOn : Boolean;
  Begin
    If F_Intr_14($0400) = $1954 Then SignOn := True Else SignOn := False;
  End;
{========================================================================}
Procedure SignOff;
  Begin
    P_Intr_14($05,$00);
  End;
{========================================================================}
Procedure RaiseDtr;
  Begin
    P_Intr_14($06,$01);
  End;
{========================================================================}
Procedure LowerDtr;
  Begin
    P_Intr_14($06,$00);
  End;
{========================================================================}
Procedure SetParameters(BaudRate : String);
  Var
    BaudRateByte : Byte;
  Begin
    BaudRateByte := 0;
    If Pos('3',BaudRate) > 0 Then BaudRateByte := BaudRateByte Or $40;
    If Pos('12',BaudRate) > 0 Then BaudRateByte := BaudRateByte Or $80;
    If Pos('24',BaudRate) > 0 Then BaudRateByte := BaudRateByte Or $A0;
    If Pos('96',BaudRate) > 0 Then BaudRateByte := BaudRateByte Or $E0;
    If Pos('O',BaudRate) > 0 Then BaudRateByte := BaudRateByte Or $8;
    If Pos('E',BaudRate) > 0 Then BaudRateByte := BaudRateByte Or $18;
    If Pos('7',BaudRate) > 0 Then BaudRateByte := BaudRateByte Or $2;
    If Pos('8',BaudRate) > 0 Then BaudRateByte := BaudRateByte Or $3;
    P_Intr_14($00,BaudRateByte);
  End;
{========================================================================}
Function Status : Integer;
  Begin
    Status := F_Intr_14($0300);
  End;
{========================================================================}
Function CD : Boolean;
  Begin
    If (F_Intr_14($0300) And $0080) = $0080 Then CD := True Else CD := False;
  End;
{========================================================================}
Procedure ClearReceiveBuffer;
  Begin
    P_Intr_14($0A,$00);
  End;
{========================================================================}
Begin
  ComPort := 0;  {0=COM1 1=COM2}
End.
{========================================================================}
