Unit CopyMove;
{========================================================================}
Interface
  Procedure CenterWrite(Row,TextColor,BackColor : Byte; CenteredString : String);
  Function FileCopy(FromFileName, ToFileName, ToBbs : String; CopyOrMove : Char) : Boolean;
  Procedure ShowSizeSpace(Drive : Char; Row : Byte);
  Procedure CopyFile;
  Procedure MoveFile;
  Procedure MassMove;
  Procedure MassCopy;
{========================================================================}
Implementation
  Uses
    AdoptIns, Area, Crt, Display, Dos, General, MfmCopy, MfmDefs, MfmStr,
    PushPop, Quit, SaveKill, Screen, Setup;
{========================================================================}
Procedure CenterWrite(Row,TextColor,BackColor : Byte; CenteredString : String);
  Begin
    AnsiGotoXY(1,Row); AnsiClearToEOL;
    AnsiGoWrite(40-(Length(CenteredString) Div 2),Row,TextColor,BackColor,No,CenteredString);
  End;
{========================================================================}
Function FileCopy(FromFileName, ToFileName, ToBbs : String; CopyOrMove : Char) : Boolean;
  Var
    FromFile, ToFile : File;
    OverWrite : Boolean;
    Fcc : Char;
    TempEntry : ListPtr;
    ToFilesBbs : Text;
  Begin
    FileCopy := False; OverWrite := True;
    If FileExist(FromFileName) Then
    Begin
      FindFirst(ToFileName,AnyFile,DirInfo);
      If DosError = 0 Then
      Begin
        OverWrite := False;
        AnsiClearScreen;
        AnsiGoWrite(1,21,Black,Cyan,No,Pgmid+'      ^Q=quit ?=help');
        NewTextColor(White); NewTextBackground(Black);
        NextPrintEntry := CurrentEntry; DisplayRecord(22);
        CenterWrite(23,White,Black,'already exists as');
        New(TempEntry);
        TempEntry^.TypeOfRecord := FileRecord;
        TempEntry^.FileName := DirInfo.Name;
        TempEntry^.FileDate := DirInfo.Time;
        TempEntry^.FileSize := DirInfo.Size;
        Assign(ToFilesBbs,ToBbs);
        {$I-} Reset(ToFilesBbs); {$I+}
        If IOresult = 0 Then
        Begin
          FSplit(ToFileName,D,N,E);
          While (Not Eof(ToFilesBbs)) Do
          Begin
            ReadLn(ToFilesBbs,WorkString);
            If Pos(N+E,WorkString) > 0 Then
            Begin
              TempEntry^.Description := AllTrim(Copy(WorkString,Pos(' ',WorkString)+1,255));
            End;
          End;
          Close(ToFilesBbs);
        End
        Else
        Begin
          TempEntry^.Description := '';
        End;
        TempEntry^.Tagged := False;
        NextPrintEntry := TempEntry; DisplayRecord(24);
        Dispose(TempEntry);
        CenterWrite(25,White,Black,'Overwrite? (Y/N) ');
        Repeat
          Gbx := GetInput;
          Fcc := Upcase(Chr(Gbx));
        Until Fcc In ['N','Y'];
        MfmWrite(Fcc);
        If Fcc = 'Y' Then OverWrite := True;
      End;
      If OverWrite Then
      Begin
        If (CopyOrMove = 'M') And (Copy(FromFileName,1,1) = Copy(ToFileName,1,1)) Then
        Begin
          CenterWrite(22,White,Black,'Moving');
          CenterWrite(23,White,Black,FromFileName);
          CenterWrite(24,White,Black,'to');
          CenterWrite(25,White,Black,ToFileName);
          MyRename(FromFileName,ToFileName);
        End
        Else
        Begin
          If CopyOrMove = 'C' Then CenterWrite(22,White,Black,'Copying ') Else CenterWrite(22,White,Black,'Moving ');
          CenterWrite(23,White,Black,FromFileName);
          CenterWrite(24,White,Black,'to');
          CenterWrite(25,White,Black,ToFileName);
          DoFileCopy(FromFileName,ToFileName);
          If CopyOrMove = 'M' Then MyErase(FromFileName);
        End;
        FileCopy := True;
      End;
    End;
  End;
{========================================================================}
Procedure ShowSizeSpace(Drive : Char; Row : Byte);
  Begin
    Drive := UpCase(Drive);
    AnsiGoWrite(1,Row,Black,Cyan,Yes,'');
    MfmWrite(CurrentEntry^.FileName+' is '+MyStr(CurrentEntry^.FileSize Div 1024,0)+'K bytes in size!   There are ');
    MfmWrite(MyStr(DiskFree(Ord(Drive)-64) Div 1024,0));
    MfmWrite('K bytes free on drive '+Drive+'.');
    NewTextColor(White); NewTextBackground(Black);
  End;
{========================================================================}
Procedure AddDescToBbs(ToFilesBbs : PathStr);
  Var
    ToFilesMfm : PathStr;
  Begin
    If Pos('.',ToFilesBbs) > 0 Then
    Begin
      ToFilesMfm := Copy(ToFilesBbs,1,Pos('.',ToFilesBbs)-1)+'.MFM';
    End
    Else
    Begin
      ToFilesMfm := ToFilesBbs+'.MFM';
    End;
    If FileExist(ToFilesBbs) Then
    Begin
      Changed := False;
      Assign(FileList,ToFilesBbs);
      Reset(FileList);
      Assign(NewFileList,ToFilesMfm);
      Rewrite(NewFileList);
      While (Not Eof(FileList)) Do
      Begin
        ReadLn(FileList,WorkString);
        If Pos(CurrentEntry^.FileName,WorkString) = 1 Then
        Begin
          WriteLn(NewFileList,CurrentEntry^.FileName+' '+CurrentEntry^.Description);
          Changed := True;
        End
        Else
        Begin
          WriteLn(NewFileList,WorkString);
        End;
      End;
      If (Not Changed) Then WriteLn(NewFileList,CurrentEntry^.FileName+' '+CurrentEntry^.Description);
      Close(FileList); Close(NewFileList);
      MyRename(ToFilesBbs,Copy(ToFilesMfm,1,Pos('.',ToFilesMfm)-1)+'.BAK');
      MyRename(ToFilesMfm,ToFilesBbs);
    End
    Else
    Begin
      Assign(FileList,ToFilesMfm);
      ReWrite(FileList);
      WriteLn(FileList,CurrentEntry^.FileName+' '+CurrentEntry^.Description);
      Close(FileList);
      MyRename(ToFilesBbs,Copy(ToFilesMfm,1,Pos('.',ToFilesMfm)-1)+'.BAK');
      MyRename(ToFilesMfm,ToFilesBbs);
    End;
  End;
{========================================================================}
Procedure CopyFile;
  Var
    ToAreaPath, ToFilesBbs, ToFilesMfm : PathStr;
    Cfc : Char;
  Begin
    If CurrentEntry^.TypeOfRecord = FileRecord Then
    Begin
      SetupScreen;
      AnsiGoWrite(1,25,White,Black,Yes,FileAreaPath+CurrentEntry^.FileName);
      ToAreaPath := FileAreaPath;
      Result := SelectArea(AreaPath,ToAreaPath,ToFilesBbs,OldArea);
      If Result = 0 Then
      Begin
        ShowSizeSpace(ToAreaPath[1],24);
        If CurrentEntry^.FileSize < (DiskFree(Ord(UpCase(ToAreaPath[1]))-64)-(SizeOfFilesBbs(ToAreaPath)+2048)) Then
        Begin
          ShowSizeSpace(ToAreaPath[1],21);
          CenterWrite(22,White,Black,FileAreaPath+CurrentEntry^.FileName);
          CenterWrite(23,White,Black,'to');
          CenterWrite(24,White,Black,ToAreaPath+CurrentEntry^.FileName);
          CenterWrite(25,White,Black,'Proceed with COPY? (Y/N) ');
          Repeat
            Gbx := GetInput;
            Cfc := Upcase(Chr(Gbx));
          Until Cfc In ['N','Y'];
          MfmWrite(Cfc);
          If Cfc = 'Y' Then
          Begin
            If FileCopy(FileAreaPath+CurrentEntry^.FileName,ToAreaPath+CurrentEntry^.FileName,ToFilesBbs,'C') Then
            Begin
              AddDescToBbs(ToFilesBbs);
              AddAreaToList(AreaName);
            End;
          End;
          ReDrawScreen;
        End
        Else
        Begin
          ReDrawScreen;
          AnsiGoWrite(1,25,White,Black,Yes,'There is not enough space on drive '+ToAreaPath[1]+' to complete the copy!');
        End;
      End
      Else ReDrawScreen;
    End;
  End;
{========================================================================}
Procedure MoveFile;
  Var
    ToAreaPath, ToFilesBbs : PathStr;
    Mfc : Char;
    FileToErase : File;
  Begin
    If CurrentEntry^.TypeOfRecord = FileRecord Then
    Begin
      SetupScreen;
      AnsiGoWrite(1,25,White,Black,Yes,FileAreaPath+CurrentEntry^.FileName);
      ToAreaPath := FileAreaPath;
      Result := SelectArea(AreaPath,ToAreaPath,ToFilesBbs,OldArea);
      If Result = 0 Then
      Begin
        ShowSizeSpace(ToAreaPath[1],24);
        If (CurrentEntry^.FileSize < (DiskFree(Ord(UpCase(ToAreaPath[1]))-64))-(SizeOfFilesBbs(ToAreaPath)+2048))
          Or (FileAreaPath[1] = ToAreaPath[1]) Then
        Begin
          ShowSizeSpace(ToAreaPath[1],21);
          CenterWrite(22,White,Black,FileAreaPath+CurrentEntry^.FileName);
          CenterWrite(23,White,Black,'to');
          CenterWrite(24,White,Black,ToAreaPath+CurrentEntry^.FileName);
          CenterWrite(25,White,Black,'Proceed with MOVE? (Y/N) ');
          Repeat
            Gbx := GetInput;
            Mfc := Upcase(Chr(Gbx));
          Until Mfc In ['N','Y'];
          MfmWrite(Mfc);
          If Mfc = 'Y' Then
          Begin
            If FileCopy(FileAreaPath+CurrentEntry^.FileName,ToAreaPath+CurrentEntry^.FileName,ToFilesBbs,'M') Then
            Begin
              AddDescToBbs(ToFilesBbs);
              AddAreaToList(AreaName);
              PushRecord(KillEntry);
              OldEntry := KillEntry;
              If KillEntry^.PrevEntry = KillEntry Then
              Begin
                Dispose(KillEntry);
                KillEntry := NIL;
              End
              Else
              Begin
                KillEntry^.PrevEntry^.NextEntry := KillEntry^.NextEntry;
                KillEntry^.NextEntry^.PrevEntry := KillEntry^.PrevEntry;
                KillEntry := KillEntry^.NextEntry;
              End;
              If KillEntry <> NIL Then Dispose(OldEntry);
            End;
          End;
          ReDrawScreen;
        End
        Else
        Begin
          ReDrawScreen;
          AnsiGoWrite(1,25,White,Black,Yes,'There is not enough space on drive '+ToAreaPath[1]+' to complete the move!');
        End;
      End
      Else ReDrawScreen;
    End;
  End;
{========================================================================}
Procedure MassMove;
  Var
    ToAreaPath, ToFilesBbs : PathStr;
    TempEntry : ListPtr;
    Mmc : Char;
    MoveOk : Boolean;
  Begin
    SetupScreen;
    CenterWrite(25,White,Black,'Select destination for MASS MOVE...');
    ToAreaPath := FileAreaPath;
    Result := SelectArea(AreaPath,ToAreaPath,ToFilesBbs,OldArea);
    If Result = 0 Then
    Begin
      CenterWrite(25,White,Black,'Proceed with MASS MOVE? (Y/N) ');
      Repeat
        Gbx := GetInput;
        Mmc := Upcase(Chr(Gbx));
      Until Mmc In ['N','Y'];
      MfmWrite(Mmc);
      If Mmc = 'Y' Then
      Begin
        TempEntry := CurrentEntry;
        CurrentEntry := FirstEntry;
        While CurrentEntry^.NextEntry <> NIL Do
        Begin
          CurrentEntry := CurrentEntry^.NextEntry;
        End;
        If CurrentEntry^.Tagged Then InsertBlank('A');
        CurrentEntry := FirstEntry;
        While CurrentEntry^.NextEntry <> NIL Do
        Begin
          MoveOk := False;
          If CurrentEntry^.Tagged Then
          Begin
            ShowSizeSpace(ToAreaPath[1],24);
            If (CurrentEntry^.FileSize < (DiskFree(Ord(UpCase(ToAreaPath[1]))-64))-(SizeOfFilesBbs(ToAreaPath)+2048))
              Or (FileAreaPath[1] = ToAreaPath[1]) Then
            Begin
              ShowSizeSpace(ToAreaPath[1],21);
              If FileCopy(FileAreaPath+CurrentEntry^.FileName,ToAreaPath+CurrentEntry^.FileName,ToFilesBbs,'M') Then
              Begin
                AddDescToBbs(ToFilesBbs);
                MoveOk := True;
                PushRecord(KillEntry);
                OldEntry := KillEntry;
                If KillEntry^.PrevEntry = KillEntry Then
                Begin
                  Dispose(KillEntry);
                  KillEntry := NIL;
                End
                Else
                Begin
                  KillEntry^.PrevEntry^.NextEntry := KillEntry^.NextEntry;
                  KillEntry^.NextEntry^.PrevEntry := KillEntry^.PrevEntry;
                  KillEntry := KillEntry^.NextEntry;
                End;
                If KillEntry <> NIL Then Dispose(OldEntry);
              End;
            End
            Else
            Begin
              ReDrawScreen;
              AnsiGoWrite(1,25,White,Black,Yes,'There is not enough space on drive '+ToAreaPath[1]+' to complete the move!');
            End;
          End;
          If (Not MoveOk) Then CurrentEntry := CurrentEntry^.NextEntry;
        End;
      End;
    End;
    CurrentEntry := TopEntry; Row := 1;
    SetupScreen; DisplayScreen;
  End;
{========================================================================}
Procedure MassCopy;
  Var
    ToAreaPath, ToFilesBbs : PathStr;
    TempEntry : ListPtr;
    Mcc : Char;
    CopyOk : Boolean;
  Begin
    SetupScreen;
    CenterWrite(25,White,Black,'Select area to MASS COPY to...');
    ToAreaPath := FileAreaPath;
    Result := SelectArea(AreaPath,ToAreaPath,ToFilesBbs,OldArea);
    If Result = 0 Then
    Begin
      CenterWrite(25,White,Black,'Proceed with MASS COPY? (Y/N) ');
      Repeat
        Gbx := GetInput;
        Mcc := Upcase(Chr(Gbx));
      Until Mcc In ['N','Y'];
      MfmWrite(Mcc);
      If Mcc = 'Y' Then
      Begin
        TempEntry := CurrentEntry;
        CurrentEntry := FirstEntry;
        While CurrentEntry^.NextEntry <> NIL Do
        Begin
          CopyOk := False;
          If CurrentEntry^.Tagged Then
          Begin
            ShowSizeSpace(ToAreaPath[1],24);
            If (CurrentEntry^.FileSize < (DiskFree(Ord(UpCase(ToAreaPath[1]))-64))-(SizeOfFilesBbs(ToAreaPath)+2048))
              Or (FileAreaPath[1] = ToAreaPath[1]) Then
            Begin
              ShowSizeSpace(ToAreaPath[1],21);
              If FileCopy(FileAreaPath+CurrentEntry^.FileName,ToAreaPath+CurrentEntry^.FileName,ToFilesBbs,'C') Then
              Begin
                AddDescToBbs(ToFilesBbs);
                CopyOk := True;
              End;
            End
            Else
            Begin
              ReDrawScreen;
              AnsiGoWrite(1,25,White,Black,Yes,'There is not enough space on drive '+ToAreaPath[1]+' to complete the copy!');
            End;
          End;
          CurrentEntry^.Tagged := False;
          If (Not CopyOk) Then CurrentEntry := CurrentEntry^.NextEntry;
        End;
      End;
    End;
    CurrentEntry := TopEntry; Row := 1;
    SetupScreen; DisplayScreen;
  End;
{========================================================================}
Begin
End.
{========================================================================}
