Unit Compress;
{========================================================================}
Interface
  Uses
    Dos;
  Procedure DirOfArchive(InFileName : PathStr);
{========================================================================}
Implementation
  Uses
    Crt, Display, General, MfmDefs, MfmStr, Screen;
{========================================================================}
Procedure DisplayPageHeader;
  Begin
    AnsiClearScreen;
    AnsiWriteLn(White,Black,'Directory for file '+CurrentEntry^.FileName);
  End;
{========================================================================}
Procedure DirOfArj(InFileName : PathStr);
  Const
    HeaderSignature = $EA60;
  Type
    ArjHeaderType = Record
      FirstHdrSize : Byte;
      ArchiverVersionNumber : Byte;
      MinArchiverVersion2Extract : Byte;
      HostOS : Byte;
      ArjFlags : Byte;
      Method : Byte;
      FileType : Byte;
      Reserved : Byte;
      DateTime : LongInt;
      CompressedSize : LongInt;
      OriginalSize : LongInt;
      OriginalCrc : LongInt;
      FilespecPos : Word;
      FileAccessMode : Word;
      HostData : Word;
    End;
    FileNameType = Array[1..255] Of Char;
  Var
    ArjFile : File;
    SigOk, ArjOk : Boolean;
    NewPos : LongInt;
    Signature, HeaderSize, ExtHeaderSize : Word;
    HeaderBuffer : Pointer;
    HeaderBufferPtr : ^ArjHeaderType;
    FileNameStr : String;
    FileNamePtr : ^FileNameType;
    LineCounter : Byte;
  {==============================}
  Procedure DisplayArjHeader;
    Var
      Dahb : Byte;
    Begin
      {$I-} BlockRead(ArjFile,Signature,SizeOf(Signature)); {$I+}
      If IOresult <> 0 Then
      Begin
        ArjOk := False;
        Exit;
      End;
      If Signature = HeaderSignature Then
      Begin
        {$I-} BlockRead(ArjFile,HeaderSize,SizeOf(HeaderSize)); {$I+}
        If IOresult <> 0 Then
        Begin
          ArjOk := False;
          Exit;
        End;
        If HeaderSize > 0 Then
        Begin
          SigOk := True;
          GetMem(HeaderBuffer,HeaderSize);
          {$I-} BlockRead(ArjFile,HeaderBuffer^,HeaderSize); {$I+}
          If IOresult <> 0 Then
          Begin
            ArjOk := False;
            FreeMem(HeaderBuffer,HeaderSize);
            Exit;
          End;
          HeaderBufferPtr := HeaderBuffer;
          FileNamePtr := HeaderBuffer;
          Dahb := 1;
          While FileNamePtr^[Dahb+SizeOf(ArjHeaderType)] <> #0 Do
          Begin
            FileNameStr[Dahb] := FileNamePtr^[Dahb+SizeOf(ArjHeaderType)];
            Inc(Dahb);
          End;
          FileNameStr[0] := Char(Dahb-1);
          If Length(FileNameStr) > 12 Then
          Begin
            AnsiWriteLn(Yellow,Black,FileNameStr);
            MfmWrite('            ');
            Inc(LineCounter);
          End
          Else
          Begin
            AnsiWrite(Yellow,Black,Copy(FileNameStr+'          ',1,12));
          End;
          AnsiWrite(Magenta,Black,MyStr(HeaderBufferPtr^.OriginalSize,8)+' ');
          AnsiWrite(Green,Black,GetDateString(HeaderBufferPtr^.DateTime)+' ');
          AnsiWrite(Cyan,Black,GetTimeString(HeaderBufferPtr^.DateTime)+' ');
          AnsiWriteLn(Red,Black,HexDw(HeaderBufferPtr^.OriginalCrc));
          {$I-}
          Seek(ArjFile,FilePos(ArjFile)+4);
          BlockRead(ArjFile,ExtHeaderSize,SizeOf(ExtHeaderSize));
          If ExtHeaderSize > 0 Then Seek(ArjFile,FilePos(ArjFile)+ExtHeaderSize);
          Seek(ArjFile,FilePos(ArjFile)+HeaderBufferPtr^.CompressedSize);
          {$I+}
          If IOresult <> 0 Then
          Begin
            ArjOk := False;
            FreeMem(HeaderBuffer,HeaderSize);
            Exit;
          End;
          FreeMem(HeaderBuffer,HeaderSize);
        End
        Else
        Begin
          SigOk := False;
        End;
      End
      Else
      Begin
        SigOk := False;
      End;
    End;
  {==============================}
  Begin
    DisplayPageHeader;
    LineCounter := 0;
    ArjOk := True; SigOk := True;
    Assign(ArjFile,InFileName);
    Reset(ArjFile,1);
    {$I-}
    BlockRead(ArjFile,Signature,SizeOf(Signature));
    BlockRead(ArjFile,HeaderSize,SizeOf(HeaderSize));
    Seek(ArjFile,FilePos(ArjFile)+HeaderSize+4);
    BlockRead(ArjFile,ExtHeaderSize,SizeOf(ExtHeaderSize));
    If ExtHeaderSize > 0 Then Seek(ArjFile,FilePos(ArjFile)+ExtHeaderSize);
    {$I+}
    If IOresult <> 0 Then ArjOk := False;
    While SigOk Do
    Begin
      DisplayArjHeader;
      If Not ArjOk Then Break;
      Inc(LineCounter);
      If LineCounter >= 23 Then
      Begin
        If UpCase(Char(AnyKey)) = 'Q' Then SigOk := False;
        DisplayPageHeader;
        LineCounter := 0;
      End;
    End;
    Close(ArjFile);
    If Not ArjOk Then
    Begin
      AnsiClearScreen;
      NewTextColor(Blink+LightRed);
      MfmWriteLn('Error in ARJ!');
      NewTextColor(LightGray);
      AnyKey;
    End
    Else
    Begin
      If LineCounter > 0 Then AnyKey;
    End;
    DisplayScreen;
  End;
{========================================================================}
Procedure DirOfZip(InFileName : PathStr);
  Var
    ZipFile : File;
    SigOk, ZipOk : Boolean;
    NewPos : LongInt;
    LineCounter : Byte;
  {==============================}
  Procedure DisplayZipHeader;
    Const
      HeaderSignature = $04034b50;
    Type
      ZipHeaderType = Record
        Version, Flag, Method, Time, Date : Word;
        Crc32, CompressedSize, UncompressedSize : LongInt;
        FileNameLength, ExtraFieldLength : Word;
      End;
      FileNameType = Array[1..255] Of Char;
    Var
      Dzhb : Byte;
      Signature, PosInFile : LongInt;
      ZipHeader : ZipHeaderType;
      HeaderBuffer, FileNameBuffer : Pointer;
      HeaderBufferPtr : ^ZipHeaderType;
      FileNameStr : String;
      FileNamePtr : ^FileNameType;
    Begin
      {$I-} BlockRead(ZipFile,Signature,SizeOf(Signature)); {$I+}
      If IOresult <> 0 Then
      Begin
        ZipOk := False;
        Exit;
      End;
      If Signature = HeaderSignature Then
      Begin
        SigOk := True;
        GetMem(HeaderBuffer,SizeOf(ZipHeader));
        {$I-} BlockRead(ZipFile,HeaderBuffer^,SizeOf(ZipHeader)); {$I+}
        If IOresult <> 0 Then
        Begin
          ZipOk := False;
          FreeMem(HeaderBuffer,SizeOf(ZipHeader));
          Exit;
        End;
        HeaderBufferPtr := HeaderBuffer;
        GetMem(FileNameBuffer,HeaderBufferPtr^.FileNameLength);
        {$I-} BlockRead(ZipFile,FileNameBuffer^,HeaderBufferPtr^.FileNameLength); {$I+}
        If IOresult <> 0 Then
        Begin
          ZipOk := False;
          FreeMem(FileNameBuffer,HeaderBufferPtr^.FileNameLength);
          FreeMem(HeaderBuffer,SizeOf(ZipHeader));
          Exit;
        End;
        FileNamePtr := FileNameBuffer;
        For Dzhb := 1 To HeaderBufferPtr^.FileNameLength Do FileNameStr[Dzhb] := FileNamePtr^[Dzhb];
        FileNameStr[0] := Chr(Lo(HeaderBufferPtr^.FileNameLength));
        AnsiClearToEol;
        AnsiWrite(Yellow,Black,Copy(FileNameStr+'          ',1,12)+' ');
        AnsiWrite(Magenta,Black,MyStr(HeaderBufferPtr^.UncompressedSize,8)+' ');
        AnsiWrite(Green,Black,FormatDate(HeaderBufferPtr^.Date)+' ');
        AnsiWrite(Cyan,Black,FormatTime(HeaderBufferPtr^.Time)+' ');
        AnsiWriteLn(Red,Black,HexDw(HeaderBufferPtr^.Crc32));
        PosInFile := FilePos(ZipFile);
        NewPos := PosInFile+HeaderBufferPtr^.CompressedSize+HeaderBufferPtr^.ExtraFieldLength;
        FreeMem(FileNameBuffer,HeaderBufferPtr^.FileNameLength);
        FreeMem(HeaderBuffer,SizeOf(ZipHeader));
      End
      Else
      Begin
        SigOk := False;
      End;
    End;
  {==============================}
  Begin
    DisplayPageHeader;
    LineCounter := 0;
    ZipOk := True; SigOk := True;
    Assign(ZipFile,InFileName);
    Reset(ZipFile,1);
    While SigOk Do
    Begin
      DisplayZipHeader;
      {$I-} Seek(ZipFile,NewPos); {$I+}
      If IOresult <> 0 Then ZipOk := False;
      If Not ZipOk Then Break;
      Inc(LineCounter);
      If LineCounter >= 23 Then
      Begin
        If UpCase(Char(AnyKey)) = 'Q' Then SigOk := False;
        DisplayPageHeader;
        LineCounter := 0;
      End;
    End;
    Close(ZipFile);
    If Not ZipOk Then
    Begin
      AnsiClearScreen;
      NewTextColor(Blink+LightRed);
      MfmWriteLn('Error in ZIP!');
      NewTextColor(LightGray);
      AnyKey;
    End
    Else
    Begin
      If LineCounter > 0 Then AnyKey;
    End;
    DisplayScreen;
  End;
{========================================================================}
Procedure DirOfArchive(InFileName : PathStr);
  Begin
    If FileExt(InFileName) = '.ARJ' Then DirOfArj(InFileName);
    If FileExt(InFileName) = '.ZIP' Then DirOfZip(InFileName);
  End;
{========================================================================}
Begin
End.
{========================================================================}
