;
; This file is a charset conversion module in text form.
;
; This module Converts IBM extended characters to Composed characters.
;
; Format: ID, version, level,
;         from charset, to charset,
;         128 entries: first & second byte
;         "END"
; Lines beginning with a ";" or a ";" after the entries are comments
;
; Unkown characters are mapped to the "?" character.
;
; cedilla = ,   ; dieresis = ..       ; acute = '
; grave = `     ; circumflex = ^      ; ring = o
; tilde = ~     ; caron = v 
; All of these are above the character, apart from the cedilla which is below.
;
; \ is the escape character: \0 means decimal zero,
; \dnnn where nnn is a decimal number is the ordinal value of the character
; \xnn where nn is a hexadecimal number
; e.g.: \d32 is the ASCII space character
; Two \\ is the character "\" itself.
;
0               ; ID number
0               ; version number
;
0               ; level number
;
IBMPC           ; from set
COMPOSED        ; to set
;
, \x8D C        ; C with cedilla
u \x8D "        ; u dieresis
e \x8D '        ; e acute
a \x8D ^        ; a circumflex
a \x8D "        ; a dieresis
a \x8D `        ; a grave
a \x8D *        ; a ring
, \x8D c        ; c cedilla
e \x8D ^        ; e circumflex
e \x8D "        ; e dieresis
e \x8D `        ; e grave
i \x8D "        ; i dieresis
i \x8D ^        ; i circumflex
i \x8D `        ; i grave
A \x8D "        ; A dieresis
A \x8D *        ; A ring
E \x8D '        ; E acute
a \x8D e        ; ae
A \x8D E        ; AE
o \x8D ^        ; o circumflex
o \x8D "        ; o dieresis
o \x8D `        ; o acute
u \x8D ^        ; u circumflex
u \x8D `        ; u grave
y \x8D "        ; y dieresis
O \x8D "        ; O dieresis
U \x8D "        ; U dieresis
C \x8D t        ; cent
P \x8D d        ; pound sterling
Y \x8D n        ; yen
P \x8D t        ; Pt
F \x8D l        ; florin
a \x8D '        ; a acute
i \x8D '        ; i grave
o \x8D '        ; o grave
u \x8D '        ; u grave
n \x8D ~        ; n tilde
N \x8D ~        ; N tilde
a \x8D _        ; ord feminine
o \x8D _        ; ord masculine
? \x8D ?        ; question downwards
?               ;
?               ; logical not
' \x8D 2        ; half fraction
' \x8D 4        ; quarter fraction
! \x8D !        ; exclam downwards
< \x8D <        ; guillemot left
> \x8D >        ; guillemot right
#               ;
#               ;
#               ;
|               ;
|               ;
|               ;
|               ;
+               ;
+               ;
|               ;
|               ;
+               ;
+               ;
+               ;
+               ;
+               ;
+               ;
-               ;
-               ;
|               ;
-               ;
+               ;
|               ;
|               ;
+               ;
+               ;
=               ;
=               ;
|               ;
=               ;
+               ;
=               ;
-               ;
=               ;
-               ;
+               ;
+               ;
+               ;
+               ;
|               ;
+               ;
+               ;
+               ;
#               ;
-               ;
|               ;
|               ;
-               ;
?               ; alpha
s \x8D s        ; german double s (misused as Beta)
?               ; Gamma
p \x8D i        ; pi
?               ; Sigma (summation)
?               ; sigma
?               ; mu
?               ; gamma
?               ; Phi
?               ; Theta
?               ; Omega
?               ; delta
?               ; infinity
?               ; o slash
?               ; element
?               ; intersection
= \x8D =        ; equivalence
+ \x8D -        ; plusminus
> \x8D =        ; greater equals
< \x8D =        ; smaller equals
?               ; integral top
?               ; integral bottom
/               ; divide
~ \x8D =        ; approx.
?               ; ring / degree
.               ; centered dot
-               ; en dash
?               ; radical
^ \x8D n        ; to the n'th power
^ \x8D 2        ; to the second power
*               ;
\d32            ; space
END
