#define PRG_TITLE   "FILESBBS"                /*  Program Name    */
#define PRG_DATES   "1994-1995"               /*  Copyright Date  */
#define PRG_VERSION "1.40"                    /*  Version Number  */
#ifdef __OS2__
  #undef  PRG_TITLE
  #define PRG_TITLE   "FILESBB2"              /*  Program Name    */
#endif
/*

                                  FILESBBS
                                Version 1.40
          Copyright (c) Bob Swift, 1994-1995.  All Rights Reserved.
            DOS Version Compiled with the Borland C/C++ compiler.

   This program is designed to read a file area description file such as the
   FILES.BBS file used by the Fido BBS software, and re-format all file
   identification lines.  The program creates a backup file prior to
   beginning the re-formatting operation.

   The format for using this program is as follows:

        FILESBBS [configuration_file|?]      for DOS
        FILESBB2 [configuration_file|?]      for OS/2

   If no configuration file is specified when the program is called, the
   system will attempt to use FILESBBS.CFG in the current directory.  An
   example configuration file is included in the distribution archive.

   Here is a list of the error codes returned by the program:

                  0 - No errors.  Normal termination.
                  1 - Extra command line arguments. (Help)
                  2 - Unable to open the input file.
                  3 - Unable to open the output file.
                  4 - Problem writing to output file.
                  5 - Problem closing input file.
                  6 - Problem closing output file.
                  7 - Unable to open backup file.
                  8 - Unable to open configuration file.
                  9 - Unable to read configuration file.
                 10 - Problem closing configuration file.
                 11 - Memory allocation error.

   When an error is encountered, the program will exit immediately and will
   attempt to properly close all files.

   Although I have chosen to retain all rights to this program, you are free
   to use it under the following conditions:

            - You realize that there is NO Warrantee of any sort.
              It was tested pretty thoroughly here before release
              but who knows what bugs may be lurking within.

            - You will not modify the code and release a new version
              of the program.  I welcome suggestions for improvement
              (especially when accompanied by code) but I make no
              guarantee of future releases.

            - You drop me a note to let me know that you use the
              program.  That way, I know who to inform if there are
              any future releases.  Please either send netmail to:

                        Bob Swift
                        1:342/5 @ fidonet

              or a postcard to:

                        Bob Swift
                        5708 - 47th Street
                        Stony Plain, Alberta
                        T7Z 1C6, Canada

            - If you find the program useful, I ask that you do
              something to brighten somebody else's day.  Just
              exactly what, I will leave up to you.

   You may freely distribute this program provided that you distribute only
   the complete archive which includes the files:

        FILESBBS.EXE    -   Program File for DOS
        FILESBB2.EXE    -   Program File for OS/2
        FILESBBS.CFG    -   Sample Configuration File
        FILESBBS.C      -   'C' Source Code
        FILESBBS.DOC    -   Program Documentation
        FILE_ID.DIZ     -   Program Description File

   If you run across any bugs with this program, please report them to the
   address listed above.  Thanks for giving FILESBBS a try.


                                                   Bob Swift (1:342/5)


   Revision History
   ----------------

   1.00 - 94/01/08 - Original release version.

   1.10 - 94/01/16 - Added option to combine description lines.

   1.11 - 94/01/22 - Fixed bug with incorrect line length when not padding.

   1.12 - 94/06/08 - Modified to allow 4,000 character maximum output line
                     length.

   1.20 - 94/11/02 - Added MAXIMUS/NOMAXIMUS options.

   1.30 - 95/04/15 - Added SKIPWORDS option.  Begin work on OS/2 version.
                     (OS/2 version not included with this release).

   1.40 - 95/08/20 - Renamed MAXIMUS option to MAXIMUS2 and added MAXIMUS3
                     option.  (OS/2 version not included with this release).

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

void helpscrn(int ernum2, char *name);
void showline(int in, int out);
void showprog(int out);
void make_path(char *path, char *drive, char *dir, char *name, char *ext);
char *strup(char *string);


void main(int argc, char *argv[])
{
FILE *in_file,*out_file,*cfg_file,*add_file;
fpos_t filepos;
short int i, j, flag, left, right, pad, right1, kill, addleft, add, addoutput, maximus, skipwords;
unsigned short in_line,out_line;
char *ignore;
char *addf;
char *bbs;
char *bak;
char *cfg;
char *flname;
char *flext;
char *defdrive;
char *defdir;
char *defname;
char *defext;
char *drive;
char *dir;
char *name;
char *ext;
char *inline;
char *doline;
char *outline;
char *p;
char *q;
char title[] = {PRG_TITLE};      /* Program Title  */
char dates[] = {PRG_DATES};      /* Copyright Date */
char version[] = {PRG_VERSION};  /* Version Number */
ignore = (char *) malloc(128);
addf = (char *) malloc(80);
bbs = (char *) malloc(80);
bak = (char *) malloc(80);
cfg = (char *) malloc(80);
flname = (char *) malloc(9);
flext = (char *) malloc(5);
defdrive = (char *) malloc(3);
defdir = (char *) malloc(66);
defname = (char *) malloc(9);
defext = (char *) malloc(5);
drive = (char *) malloc(3);
dir = (char *) malloc(66);
name = (char *) malloc(9);
ext = (char *) malloc(5);
inline = (char *) malloc(4096);
doline = (char *) malloc(4096);
outline = (char *) malloc(5000);
if ((outline == NULL)    ||
    (doline == NULL)     ||
    (inline == NULL)     ||
    (ext == NULL)        ||
    (name == NULL)       ||
    (dir == NULL)        ||
    (drive == NULL)      ||
    (defext == NULL)     ||
    (defname == NULL)    ||
    (defdir == NULL)     ||
    (defdrive == NULL)   ||
    (flext == NULL)      ||
    (flname == NULL)     ||
    (cfg == NULL)        ||
    (bak == NULL)        ||
    (ignore == NULL)     ||
    (addf == NULL)       ||
    (bbs == NULL))       helpscrn(11,"");

printf("\n\n%s v%s - Copyright (c) Bob Swift, %s.  All Rights Reserved.\n\n",title,version,dates);

if (argc > 2)
   helpscrn(1,"");

getcwd(outline,80);
if (outline[strlen(outline)-1] != '\\') strcat(outline,"\\");
_splitpath(outline,defdrive,defdir,defname,defext);
strcpy(defname,"FILES");
strcpy(defext,".BBS");

if (argc > 1)
  if (argv[1][0] == '?')
    helpscrn(1,"");
  else
    strcpy(outline,argv[1]);

/* if (outline[strlen(outline)-1] != '\\') strcat(outline,"\\"); */
_splitpath(outline,drive,dir,name,ext);

if (drive[0] == '\0') strcpy(drive,defdrive);
if (dir[0] == '\0') strcpy(dir,defdir);
if (name[0] == '\0') strcpy(name,"FILESBBS");
if (ext[0] == '\0') strcpy(ext,".CFG");

make_path(cfg,drive,dir,name,ext);

/*  Open configuration file  */
cfg_file=fopen(cfg,"r");
if (cfg_file == NULL) helpscrn(8,cfg);

/*  Initialize variables  */
strcpy(flname,defname);
strcpy(flext,defext);
addleft = 32;
left = 33;
right = 79;
pad = 1;
add = 1;
addoutput = 0;
kill = 0;
maximus = 0;
skipwords = 0;
strcpy(ignore," \n");

while (fgets(inline,4096,cfg_file) != NULL)
  {
  strcpy(doline,inline);
  p = strtok(doline," \n");
  if (p != NULL) q = strtok(NULL," \n");
  if (strcmpi(p,"LEFT") == 0)
    {
    left = atoi(q);
    if (left < 1) left = 1;
    if (left > right) left = right;
    }
  if (strcmpi(p,"RIGHT") == 0)
    {
    right = atoi(q);
    if (right < left) right = left;
    if (right > 4000) right = 4000;
/*    if (right > 255) right = 255; */
    }
  if (strcmpi(p,"ADDLEFT") == 0)
    {
    addleft = atoi(q);
    if (addleft < 1) addleft = 1;
    if (addleft > 79) addleft = 79;
    }
  if (strcmpi(p,"SKIPWORDS") == 0)
    {
    skipwords = atoi(q);
    if (skipwords < 0) skipwords = 0;
    if (skipwords > 9) skipwords = 9;
    }
  if (strcmpi(p,"ADD") == 0)
    {
    add = 1;
    }
  if (strcmpi(p,"NOADD") == 0)
    {
    add = 0;
    }
  if (strcmpi(p,"ADDOUTPUT") == 0)
    {
    addoutput = 1;
    }
  if (strcmpi(p,"NOADDOUTPUT") == 0)
    {
    addoutput = 0;
    }
  if (strcmpi(p,"PAD") == 0)
    {
    pad = 1;
    }
  if (strcmpi(p,"NOPAD") == 0)
    {
    pad = 0;
    }
  if (strcmpi(p,"KILL") == 0)
    {
    kill = 1;
    }
  if (strcmpi(p,"NOKILL") == 0)
    {
    kill = 0;
    }
  if (strcmpi(p,"MAXIMUS2") == 0)
    {
    maximus = 2;
    }
  if (strcmpi(p,"MAXIMUS3") == 0)
    {
    maximus = 3;
    }
  if (strcmpi(p,"NOMAXIMUS") == 0)
    {
    maximus = 0;
    }
  if (strcmpi(p,"IGNORE") == 0)
    {
    ignore[0] = '\0';
    if (q) strcpy(ignore,q);
    strcat(ignore," \n");
    }
  if (strcmpi(p,"FILENAME") == 0)
    {
    flname[0] = '\0';
    flext[0] = '\0';
    if (q) _splitpath(q,bak,bbs,flname,flext);
    if (flname[0] == '\0') strcpy(name,defname);
    if (flext[0] == '\0') strcpy(ext,defext);
    if (strcmpi(flext,".BAK") == 0) strcpy(ext,defext);
    }
  if (strcmpi(p,"PATH") == 0)
    {
    strcpy(outline,defdrive);
    strcat(outline,defdir);
    if (q) strcpy(outline,q);
    if (outline[strlen(outline)-1] != '\\') strcat(outline,"\\");
    _splitpath(outline,drive,dir,name,ext);

    strcpy(name,flname);
    strcpy(ext,flext);

    make_path(bbs,drive,dir,name,ext);

    strcpy(ext,".BAK");
    make_path(bak,drive,dir,name,ext);

    strcpy(ext,".ADD");
    make_path(addf,drive,dir,name,ext);

    in_line = 0;
    out_line = 0;

    /*  Check if input file exists  */
    in_file=fopen(bbs,"r");
    if (in_file == NULL) helpscrn(2,bbs);
    flag=fclose(in_file);
    if (flag != 0) helpscrn(5,bbs);

    /*  Check for existing backup file and delete  */
    in_file=fopen(bak,"r");
    fclose(in_file);
    if (in_file != NULL)
       {
       flag=unlink(bak);
       if (flag != 0) helpscrn(7,bak);
       }

    /*  Rename input file with extension of BAK  */
    if (rename(bbs,bak) != 0) helpscrn(7,bak);

    /*  Open source file  */
    in_file=fopen(bak,"r");
    if (in_file == NULL) helpscrn(2,bak);

    /*  Open destination file  */
    out_file=fopen(bbs,"w");
    if (out_file == NULL) helpscrn(3,bbs);

    /*  Open combined description destination file  */
    if (addoutput == 1 && add == 1)
      {
      add_file=fopen(addf,"w");
      if (out_file == NULL) helpscrn(3,addf);
      }

    printf("%-68s",bbs);
    showprog(out_line);

    /*  Get line from source file and increment counter  */
    while (fgets(inline,4096,in_file) != NULL)
      {
      in_line++;

      /*  Cycle through the search patterns  */
      i = strlen(ignore);
      flag = 0;
      while (i > 0 && flag == 0)
        {
        i--;
        if (inline[0] == ignore[i])
          {
          flag = 1;
          if (fputs(inline,out_file) == EOF) helpscrn(4,bbs);
          if (addoutput == 1 && add == 1)
            {
            if (fputs(inline,add_file) == EOF) helpscrn(4,addf);
            }
          }
        }
      if (flag == 0)
        {
        right1 = right;
        strcpy(doline,inline);
        if (add == 1)
          {
          memset(outline,' ',addleft);
          outline[addleft] = '\0';
          i = 0;
          while (i == 0)
            {
            fgetpos(in_file,&filepos);
            i = 1;
            if (fgets(inline,4096,in_file) != NULL)
              {
              if (strspn(inline,outline) >= addleft)
                {
                i = 0;
                in_line++;
                inline[strlen(inline)-1] = ' ';
                p = inline;
                p = p + addleft - 1;
                strcat(doline,p);
                }
              }
            }
          fsetpos(in_file,&filepos);
          }
        if (addoutput == 1 && add == 1)
          {
          strcpy(inline,doline);
          p = strtok(doline," \n");
          i = 0;
          while (p[i] != '\0')
            {
            outline[i] = toupper(p[i]);
            i++;
            outline[i] = '\0';
            }
          memset(outline+strlen(outline),' ',12);
          outline[14] = '\0';
          if (fputs(outline,add_file) == EOF) helpscrn(4,addf);
          j = 0;
          while (p = strtok(NULL," \n"))
            {
            j++;
            if (j > skipwords)
              {
              if (fputs(" ",add_file) == EOF) helpscrn(4,addf);
              if (fputs(p,add_file) == EOF) helpscrn(4,addf);
              }
            }
          if (fputs("\n",add_file) == EOF) helpscrn(4,addf);
          strcpy(doline,inline);
          }
        p = strtok(doline," \n");
        i = 0;
        while (p[i] != '\0')
          {
          outline[i] = toupper(p[i]);
          i++;
          outline[i] = '\0';
          }
        memset(outline+strlen(outline),' ',left);
        outline[left-2] = '\0';
        if (pad == 0)
          {
          outline[i] = '\0';
          right1 = right - left + i + 2;
          }
        if (maximus == 2)
          {
          right1 = 224 + left;
          if (pad == 0) right1 = 224 + i;
          }
        if (maximus == 3)
          {
          right1 = 992 + left;
          if (pad == 0) right1 = 992 + i;
          }
        j = 0;
        while (p = strtok(NULL," \n"))
          {
          j++;
          if (j > skipwords)
            {
            if (strlen(outline)+1+strlen(p) <= right1)
              {
              strcat(outline," ");
              strcat(outline,p);
              }
            else
              {
              if (strlen(p) > right-left+1)
                {
                strcat(outline," ");
                strcat(outline,p);
                outline[right1] = '\0';
                }
              strcat(outline,"\n");
              if (fputs(outline,out_file) == EOF) helpscrn(4,bbs);
              out_line++;
              right1 = right;
              showprog(out_line);
              memset(outline,' ',left);
              outline[left-2] = '\0';
              strcat(outline," ");
              strcat(outline,p);
              outline[right] = '\0';
              }
            }
          }
        strcat(outline,"\n");
        if (fputs(outline,out_file) == EOF) helpscrn(4,bbs);
        }
      out_line++;
      showprog(out_line);
      }

    /*  Close the source file  */
    flag=fclose(in_file);
    if (flag != 0) helpscrn(5,bak);

    /*  Close the destination file  */
    flag=fclose(out_file);
    if (flag != 0) helpscrn(6,bbs);

    /*  Close the combined description destination file  */
    if (addoutput == 1 && add == 1)
      {
      flag=fclose(add_file);
      if (flag != 0) helpscrn(6,addf);
      }

    /*  Delete the backup file  */
    if (kill == 1)
       {
       flag=unlink(bak);
       if (flag != 0) helpscrn(7,bak);
       }

    showline(in_line,out_line);
    }
  }

/*  Close the configuration file  */
flag=fclose(cfg_file);
if (flag != 0)
   helpscrn(10,bbs);

/*  Thank the user and exit gracefully  */
printf("\n\nConversion complete.  Thank-you for using %s.\n\n",title);
exit(0);
}


/*  Display current line count so user doesn't get worried  */
void showline(int in, int out)
{
printf("\b(%u/%u)\n",in,out);
}


/*  Display changing symbol so user doesn't get worried  */
void showprog(int out)
{
char dispchar[4][2] = {"/","|","\\","-"};

printf("\b%s",dispchar[out%4]);
}


/* Convert string to upper case. */
char *strup(char *string)
{
short int i;
i = 0;
while (string[i] != '\0')
  {
  string[i] = toupper(string[i]);
  i++;
  }
return(string);
}


/* Build full filenames including drive & path.  Replaces _makepath function */
void make_path(char *path, char *drive, char *dir, char *name, char *ext)
{
strcpy(path,drive);
strcat(path,dir);
strcat(path,name);
strcat(path,ext);
strup(path);
}


/*  Here are the error messages and VERY brief instructions  */
void helpscrn(int ernum2, char *name)
{
printf("\n");
switch (ernum2) {

case  2 : printf("Unable to open input file - %s\n\n",name);
          break;

case  3 : printf("Unable to open output file - %s\n\n",name);
          break;

case  4 : printf("Problem writing to output file - %s\n\n",name);
          break;

case  5 : printf("Problem closing input file - %s\n\n",name);
          break;

case  6 : printf("Problem closing output file - %s\n\n",name);
          break;

case  7 : printf("Unable to open backup file - %s\n\n",name);
          break;

case  8 : printf("Unable to open configuration file - %s\n\n",name);
          break;

case  9 : printf("Unable to read configuration file - %s\n\n",name);
          break;

case 10 : printf("Problem closing configuration file - %s\n\n",name);
          break;

case 11 : printf("Memory allocation problem.\n\n");
          break;
}

printf("This program is designed to read a file area description file such");
printf(" as the\nFILES.BBS file used by the Fido BBS software, and re-form");
printf("at all file\nidentification lines.  The program creates a backup f");
printf("ile prior to\nbeginning the re-formatting operation.\n\nThe format");
printf(" for using this program is as follows:\n\n     %s [configuration_f",PRG_TITLE);
printf("ile|?]\n\nIf no configuration file is specified when the program is call");
printf("ed, the\nsystem will attempt to use FILESBBS.CFG in the current di");
printf("rectory.\n\n");

exit(ernum2);
}

