Option Explicit

'Subroutine: ValidateDate   Author: A.Pasho
'                           Date 8/8/94
'Description: Determines if the string is a
'valid date
Function ValidateDate (sCtrl As MaskEdbox) As Integer
    Dim nYear%, nMonth%, nDay%, bError%, nYear2%
    Dim sDate$

    sDate = sCtrl.text
    'break the string into month, day, year values
    ValidateDate = False
    nYear = Val(Right$(sDate, 4))
    nMonth = Val(Left$(sDate, 2))
    nDay = Val(Mid$(sDate, 4, 2))

    'check to see if each value has the correct number of
    'digits
    If Len(Str$(nYear)) < 4 Then
        InformUser "Incomplete Year!"
        Exit Function
    End If

    If Len(Str$(nMonth)) < 2 Then
        InformUser "Incomplete Month!"
        Exit Function
    End If

    If Len(Str$(nDay)) < 2 Then
        InformUser "Incomplete Day"
        Exit Function
    End If

    'check the month range
    If nMonth < 1 Or nMonth > 12 Then
        InformUser "Invalid Month!"
        Exit Function
    End If

    bError = False
    Select Case nMonth

    'check the number of days
    '31 days
    Case 1, 3, 5, 7, 8, 10, 12:
        If nDay < 1 Or nDay > 31 Then
            bError = True
        End If

    '28 - 29 days
    Case 2:
        'check for leap year
        If (nYear Mod 4) = 0 Then
            If (nYear Mod 100) = 0 Then
                If (nYear Mod 400) = 0 Then
                    If nDay < 1 Or nDay > 29 Then
                        bError = True
                    End If
                Else
                    If nDay < 1 Or nDay > 28 Then
                        bError = True
                    End If
                End If
            Else
                If nDay < 1 Or nDay > 29 Then
                    bError = True
                End If
            End If
        Else
            If nDay < 1 Or nDay > 28 Then
                bError = True
            End If
        End If


    '30 days
    Case 4, 6, 9, 11:
        If nDay < 1 Or nDay > 30 Then
            bError = True
        End If

    End Select

    If bError Then
        InformUser "Invalid Day!"
        ValidateDate = False
        Exit Function
    End If

    ValidateDate = True

End Function

'Subroutine: ValidateTime   Author: A.Pasho
'                           Date 8/8/94
'Description: Determines if the string is a
'valid time
Function ValidateTime (sTime As String) As Integer
    Dim nHour%, nMin%, sM$
    Dim bError%

    'break the string into hour & minute values
    ValidateTime = False
    nHour = Val(Left$(sTime, 2))
    nMin = Val(Mid$(sTime, 4, 2))
    sM = Right$(sTime, 2)

    'check the hour range
    If nHour < 0 Or nHour > 12 Then
        InformUser "Invalid Hour"
        Exit Function
    End If

    'check the minute range
    If nMin < 0 Or nMin > 59 Then
        InformUser "Invalid Hour"
        Exit Function
    End If

    'check form AM or PM
    sM = UCase$(sM)
    If StrComp(sM, "AM", 0) = 0 Then
        ValidateTime = True
        Exit Function
    Else
        If StrComp(sM, "PM", 0) = 0 Then
            ValidateTime = True
            Exit Function
        End If
    End If
    InformUser "Time must include AM or PM."

End Function

