Option Explicit
Global Const TheAppTitle$ = "Reusable Functions Demo"
'Global sDBPath$
Global Const sDBName$ = "rufdemo.mdb"

'RufAbout form variables
Global bReg% 'Registered version flag
Global Const sVer$ = "1.00" 'version number

Function LoadText$ (sFileName$)
    On Error GoTo TextErr
    Dim sLine$, sInfo$

    HourglassCursor
    If StrComp(sFileName, "") <> 0 Then
        Open sFileName For Input As 1
        If LOF(1) > 32000 Then
            ArrowCursor
            StopUser "File is larger than 32K!"
            Close 1
            Exit Function
        End If
        Line Input #1, sLine
        While Not EOF(1)
            sInfo = sInfo & sLine + Chr(13) + Chr(10)
            Line Input #1, sLine
        Wend
        sInfo = sInfo & sLine + Chr(13) + Chr(10)
        Close 1
    End If
    ArrowCursor
    LoadText = sInfo
    Exit Function

TextErr:
    If Err <> 53 Then
        ArrowCursor
        GetErrorMsg Err
    Else
        LoadText = ""
    End If
    Exit Function
End Function

Sub OpenDB ()
    On Error GoTo dbErr
    Dim x%, bDBOK%

    'get path from .ini file
    If Len(RTrim$(sDBPath)) < 2 Then
        bDBOK = True
        GoTo showform
    End If

    If Len(RTrim$(sDBPath)) < Len(sDBName) Then
        StopUser "Invalid path or database name!"
        ModalForm RUFDBForm
    End If

    If InStr(1, sDBPath, sDBName, 1) = 0 Then
        StopUser "Incorrect database name!"
        bDBOK = True
        GoTo showform
        'Exit Sub
    End If

    HourglassCursor
    Set TheDatabase = OpenDatabase(sDBPath)
    ArrowCursor

    'keep loading dbForm till the database is open
showform:
    While bDBOK
    bDBOK = False
    bRufDbEnd = True
    ModalForm RUFDBForm

    If InStr(1, sDBPath, sDBName, 1) = 0 Then
        StopUser "Incorrect database name!"
        bDBOK = True
        GoTo showform
    End If
    HourglassCursor
    Set TheDatabase = OpenDatabase(sDBPath)
    ArrowCursor
    Wend

    'write the new path
    WriteToIni "Database", sDBPath
    Exit Sub

dbErr:
    bDBOK = True
    DatabaseError
    Resume Next

End Sub

