Option Explicit
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer


'---------------------------------------
' MAPI SESSION CONTROL CONSTANTS
'---------------------------------------
'Action
Global Const SESSION_SIGNON = 1
Global Const SESSION_SIGNOFF = 2

'---------------------------------------
' MAPI MESSAGE CONTROL CONSTANTS
'---------------------------------------
'Action
Global Const MESSAGE_FETCH = 1
Global Const MESSAGE_SENDDLG = 2
Global Const MESSAGE_SEND = 3
Global Const MESSAGE_SAVEMSG = 4
Global Const MESSAGE_COPY = 5
Global Const MESSAGE_COMPOSE = 6

Global Const MESSAGE_REPLY = 7
Global Const MESSAGE_REPLYALL = 8
Global Const MESSAGE_FORWARD = 9
Global Const MESSAGE_DELETE = 10
Global Const MESSAGE_SHOWADBOOK = 11
Global Const MESSAGE_SHOWDETAILS = 12
Global Const MESSAGE_RESOLVENAME = 13
Global Const RECIPIENT_DELETE = 14
Global Const ATTACHMENT_DELETE = 15

'---------------------------------------
'  MISCELLANEOUS GLOBAL CONSTANT DECLARATIONS (MAPI CONTROLS)
'---------------------------------------
Global Const RECIPTYPE_ORIG = 0
Global Const RECIPTYPE_TO = 1
Global Const RECIPTYPE_CC = 2
Global Const RECIPTYPE_BCC = 3


Function ConstructMultiMailMsg (frmMapi As Form, sSubject As String, sMsg As String, sName As String)
    On Error GoTo constErr

    ConstructMultiMailMsg = True
    frmMapi!MapiMessages.Action = MESSAGE_COMPOSE
    frmMapi!MapiMessages.MsgSubject = sSubject
    frmMapi!MapiMessages.MsgNoteText = sMsg
    frmMapi!MapiMessages.RecipType = RECIPTYPE_TO

    frmMapi!MapiMessages.RecipDisplayName = sName
    frmMapi!MapiMessages.Action = MESSAGE_RESOLVENAME
    frmMapi!MapiMessages.Action = MESSAGE_SEND

    Exit Function

constErr:
    ConstructMultiMailMsg = False
    Exit Function

End Function

Function InitMultiMapi (frmMapi As Form) As Integer
    On Error GoTo initMail
    Dim x%, sMailUserID$

    InitMultiMapi = True
    sMailUserID = Space$(60)
    x = GetPrivateProfileString("Microsoft Mail", "Login", "", sMailUserID, 60, "MSMAIL.INI")

    frmMapi!MapiSession.UserName = RTrim$(sMailUserID)
    frmMapi!MapiSession.Password = ""
    frmMapi!MapiSession.NewSession = True

    'this will handle things if mail logon is canceled
    frmMapi!MapiSession.LogonUI = True
    frmMapi!MapiSession.Action = SESSION_SIGNON

    frmMapi!MapiMessages.SessionID = frmMapi!MapiSession.SessionID
    Exit Function

initMail:
    InitMultiMapi = False
    Exit Function

End Function

Sub MapiSignOff (frmMapi As Form)
    frmMapi!MapiSession.Action = SESSION_SIGNOFF
End Sub

Sub SendSingleMailMsg (frmMapi As Form, sSubject As String, sMsg As String, sAddress As String)
    On Error GoTo skipmail
    Dim x%, sMailUserID$

    sMailUserID = Space$(60)
    x = GetPrivateProfileString("Microsoft Mail", "Login", "", sMailUserID, 60, "MSMAIL.INI")

    frmMapi!MapiSession.UserName = RTrim$(sMailUserID)
    frmMapi!MapiSession.Password = ""
    frmMapi!MapiSession.NewSession = True

    'this will handle things if mail logon is canceled
    frmMapi!MapiSession.LogonUI = True
    frmMapi!MapiSession.Action = SESSION_SIGNON

    frmMapi!MapiMessages.SessionID = frmMapi!MapiSession.SessionID
    frmMapi!MapiMessages.Action = MESSAGE_COMPOSE
    frmMapi!MapiMessages.MsgSubject = sSubject
    frmMapi!MapiMessages.MsgNoteText = sMsg
    frmMapi!MapiMessages.RecipType = RECIPTYPE_TO

    frmMapi!MapiMessages.RecipDisplayName = sAddress
    frmMapi!MapiMessages.Action = MESSAGE_RESOLVENAME
    frmMapi!MapiMessages.Action = MESSAGE_SEND
    frmMapi!MapiSession.Action = SESSION_SIGNOFF

    Exit Sub

skipmail:
    Exit Sub

End Sub

