VERSION 2.00
Begin Form RUFAuxEdForm 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   ClientHeight    =   3390
   ClientLeft      =   1125
   ClientTop       =   3255
   ClientWidth     =   7230
   Height          =   3795
   KeyPreview      =   -1  'True
   Left            =   1065
   LinkTopic       =   "Form3"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3390
   ScaleWidth      =   7230
   Top             =   2910
   Width           =   7350
   Begin CheckBox chkActive 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Active"
      Height          =   255
      Left            =   5520
      TabIndex        =   10
      Top             =   2640
      Value           =   2  'Grayed
      Width           =   975
   End
   Begin ListBox lstList 
      BackColor       =   &H00FFFFFF&
      Height          =   1785
      Left            =   240
      Sorted          =   -1  'True
      TabIndex        =   9
      Top             =   120
      Width           =   4575
   End
   Begin CommandButton cmdDelete 
      Caption         =   "&Delete"
      Height          =   375
      Left            =   5400
      TabIndex        =   3
      Top             =   1560
      Width           =   1335
   End
   Begin TextBox txtDesc 
      Height          =   285
      Left            =   2640
      MaxLength       =   40
      TabIndex        =   5
      Top             =   3000
      Width           =   4455
   End
   Begin CommandButton cmdNew 
      Caption         =   "&New"
      Height          =   375
      Left            =   5400
      TabIndex        =   1
      Top             =   600
      Width           =   1335
   End
   Begin CommandButton cmdEdit 
      Caption         =   "&Edit"
      Default         =   -1  'True
      Height          =   375
      Left            =   5400
      TabIndex        =   0
      Top             =   120
      Width           =   1335
   End
   Begin CommandButton cmdUpdate 
      Caption         =   "&Update"
      Height          =   375
      Left            =   5400
      TabIndex        =   2
      Top             =   1080
      Width           =   1335
   End
   Begin CommandButton cmdClose 
      Cancel          =   -1  'True
      Caption         =   "&Close"
      Height          =   375
      Left            =   5400
      TabIndex        =   4
      Top             =   2040
      Width           =   1335
   End
   Begin Label lblField 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   3000
      Width           =   2415
   End
   Begin Label lblStatus 
      BackColor       =   &H00C0C0C0&
      Height          =   255
      Left            =   2640
      TabIndex        =   7
      Top             =   2640
      Width           =   855
   End
   Begin Label lblID 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00C0C0C0&
      Height          =   255
      Left            =   840
      TabIndex        =   6
      Top             =   2640
      Width           =   1695
   End
End

Option Explicit
Dim bNew%, bChange%

'the global varibles must be declared in a basic module
'Global sDBPath$ 'database path
'Global sRUFAuxTable$ 'table for RufAuxEdForm
'Global lRUFAuxEdHelpID& 'help ID for RufAuxEdForm
'Global sRUFAuxIDCaption$ 'ID caption for RufAuxEdForm
'Global sRUFAuxLable$ 'label caption for RufAuxEdForm
'Global sRUFAuxCaption$ 'form caption for RufAuxEdForm
'Global sRUFAuxQuery$ 'querydef for RufAuxEdForm
'Global sRUFAuxDelCheckQuery$ 'query to check for clearence to delete a record
'Global sRUFAuxDelQuery$ ' query to delete a record
'Global bRUFAuxDelete% 'boolen value to set the enable property of cmdDelete button

'call this form in this fashion
'sRUFAuxTable = "Companies"
'lRUFAuxEdHelpID = 1
'sRUFAuxIDCaption = "Company ID:"
'sRUFAuxLable = "Company Name"
'sRUFAuxCaption = "Companies"
'sRUFAuxQuery = "GetCompanyRec"
'sRUFAuxDelCheckQuery = "CheckCompany"
'sRUFAuxDelQuery = "DeleteCompany"
'bRUFAuxDelete = True
'ModalForm RUFAuxEdForm

Function CheckChange () As Integer
    Dim nResponse%
    If bChange = True Then
        Beep
        nResponse = MsgBox("Discard current changes ?", MB_YESNO + MB_ICONQUESTION, TheAppTitle)
        If nResponse = IDYES Then
            CheckChange = True
        Else
            CheckChange = False
        End If
    Else
        CheckChange = True
    End If

End Function

Sub chkActive_Click ()
    bChange = True
End Sub

Sub cmdClose_Click ()
    If CheckChange() Then
        Unload RUFAuxEdForm
    End If
End Sub

Sub cmdDelete_Click ()
    On Error GoTo delErr
    Dim qd As querydef
    Dim ssData As snapshot
    Dim lID&

    lID = GetLBID(lstList, sRUFAuxLable)
    If lID = -1 Then
        Exit Sub
    End If

    HourglassCursor

    Set qd = TheDatabase.OpenQueryDef(sRUFAuxDelCheckQuery)
    qd!id = lID
    Set ssData = qd.CreateSnapshot()
    qd.Close

    If Not ssData.EOF Then
        StopUser "This record is required to maintain database integrity. Delete operation cancelled!"
        ArrowCursor
        Exit Sub
    Else
        If Not AskUser("Are you sure you want to delete the selected record?") Then
            ArrowCursor
            Exit Sub
        End If
    End If

    Set qd = TheDatabase.OpenQueryDef(sRUFAuxDelQuery)
    qd!id = lID
    qd.Execute


    lblStatus.Caption = ""
    txtDesc.Text = ""
    chkActive.Value = False
    txtDesc.Enabled = False
    chkActive.Enabled = False
    bNew = False
    bChange = False

    LoadListBox sRUFAuxLoad, 1, lstList, False, ""
    ArrowCursor
    Exit Sub

delErr:
    ArrowCursor
    GetErrorMsg Err
    Exit Sub

End Sub

'Subroutines: cdmEdit_Click             Author: A.Pasho
'                                       Date: 8/30/94
'Description: reads and displays a devstatus record
Sub cmdEdit_Click ()
    On Error GoTo editErr
    Dim nStatusID%, sBuff$, sTmp$
    Dim ssStatus As snapshot
    Dim qdQuery As querydef
    Dim lID&

    'check for list box selection
    lID = GetLBID(lstList, sRUFAuxLable)
    If lID = -1 Then
        Exit Sub
    End If


    HourglassCursor

    'check for currently loaded record
    If CheckChange() Then

        txtDesc.Enabled = True
        chkActive.Enabled = True

        Set qdQuery = TheDatabase.OpenQueryDef(sRUFAuxQuery)
        qdQuery!id = lID        ' Set parameter.
        Set ssStatus = qdQuery.CreateSnapshot()
        qdQuery.Close

        If ssStatus.EOF Then
            InformUser "ID No Longer Available: "
        Else
            ' set bChange to 1 for later processing in cmdClose & cmdUpdat

            lblStatus.Caption = lID

            If Not IsNull(ssStatus(1)) Then
                txtDesc.Text = AddQuoteV(ssStatus(1))
            Else
                txtDesc.Text = ""
            End If

            If Not IsNull(ssStatus(2)) Then
                chkActive.Value = Val(ssStatus(2))
            Else
                chkActive.Value = False
            End If

            cmdUpdate.Caption = "&Update"
            cmdUpdate.Visible = True
            bChange = False
        End If
        ssStatus.Close
    End If
    ArrowCursor
    Exit Sub

editErr:
    ArrowCursor
    Beep
    MsgBox "Error opening IncStatus record!", MB_ICONSTOP + MB_OK, TheAppTitle
    Exit Sub


End Sub

'Subroutine: cmdNew_Click           Author: A.Pasho
'                                   Date: 8/30/94
'Description: gets a new id and initializes the form
Sub cmdNew_Click ()
    Dim lStatusID As Long
    If Not bNew Then
        If CheckChange() Then
    
            bNew = True
            bChange = True
    
            lStatusID = GetID(sRUFAuxTable)
            lblStatus.Caption = Str$(lStatusID)
            txtDesc.Text = ""
    
            cmdUpdate.Caption = "&Save"
            cmdUpdate.Visible = True
            txtDesc.Enabled = True
            chkActive.Value = Abs(True)
            chkActive.Enabled = True
            cmdNew.Caption = "Ca&ncel"
            txtDesc.SetFocus
        End If
    Else
        bNew = False
        lblStatus.Caption = ""
        txtDesc.Text = ""
        chkActive.Value = False
        cmdUpdate.Visible = False
        txtDesc.Enabled = False
        chkActive.Enabled = False
        cmdNew.Caption = "&New"
        DoEvents
        bChange = False
    End If

End Sub

'Subroutine: cmdUpdate_Click            Author: A.Pasho
'                                       Date: 8/30/94
'Description: generates & executes an update or insert
'statement
Sub cmdUpdate_Click ()
    On Error GoTo updateErr
    Dim nStatusID&
    Dim sTmp$, sBuff$

    'check for required fields
    If Len(RTrim$(txtDesc.Text)) = 0 Then
        Beep
        MsgBox "A " & sRUFAuxLable & " is required", MB_ICONEXCLAMATION + MB_OK, TheAppTitle
        txtDesc.SetFocus
        Exit Sub
    End If

    HourglassCursor


    nStatusID = lblStatus.Caption

    If bNew Then
        CreateInsert sRUFAuxTable

        sTmp = lblStatus.Caption
        AddToInsert sTmp, False

        sTmp = txtDesc.Text
        AddToInsert sTmp, True

        sTmp = LTrim$(Str$(Abs(chkActive.Value)))
        AddToInsert sTmp, True

        sBuff = GetInsertStatement()
    Else
        CreateUpdate sRUFAuxTable
        sTmp = txtDesc.Text
        AddToUpdate sRufAuxFields(1), sTmp, True

        sTmp = LTrim$(Str$(Abs(chkActive.Value)))
        AddToUpdate sRufAuxFields(2), sTmp, True

        sBuff = GetUpdateStatement(" where " & sRufAuxFields(0) & " = " & Str(lblStatus.Caption))
    End If

    TheDatabase.Execute (sBuff)
    bChange = False

    'ScanListBox lblStatus.Caption, lstList

    cmdUpdate.Visible = False
    txtDesc.Enabled = False
    chkActive.Enabled = False
    cmdNew.Caption = "&New"
    bNew = False
    bChange = False


    LoadListBox sRUFAuxLoad, nStatusID, lstList, False, ""
    ArrowCursor
    Exit Sub

updateErr:
    ArrowCursor
    GetErrorMsg Err
    Exit Sub



End Sub

Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)
    If KeyCode = KEY_F1 Then
        CallHelp lRUFAuxEdHelpID
    End If
End Sub

Sub Form_KeyPress (KeyAscii As Integer)
    If KeyAscii = 27 Then
        cmdClose = True
    End If
End Sub

Sub Form_Load ()
    Dim i%, nDataLen%, nLen%
    Dim sField$

    HourglassCursor
    bNew = False
    bChange = False

    cmdUpdate.Visible = False
    txtDesc.Enabled = False
    chkActive.Enabled = False
    lblID = sRUFAuxIDCaption & ":"
    lblField = sRUFAuxLable & ":"
    RUFAuxEdForm.Caption = sRUFAuxCaption


    LoadListBox sRUFAuxLoad, -1, lstList, False, ""

    cmdDelete.Enabled = bRUFAuxDelete

    ArrowCursor

End Sub

Sub lstList_DblClick ()
    cmdEdit = True
End Sub

Sub txtDesc_Change ()
    bChange = True
End Sub

