unit Dspy;

interface

uses
  SysUtils,
  WinTypes,
  WinProcs,
  Messages,
{  Classes,}
  Graphics,
  Controls,
  StdCtrls,
  ExtCtrls,
  Forms,
  Buttons,
  VBXCtrl,
  Cbk, Classes;


type
  TfrmDSpy = class(TForm)
    lboxDisplay: TListBox;
    btnAbout: TButton;
    btnExit: TButton;
    sbtnTop: TSpeedButton;
    sbtnChildren: TSpeedButton;
    sbtnOwned: TSpeedButton;
    sbtnClearList: TSpeedButton;
    Callback1: TCallback;
    procedure sbtnTopClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure sbtnClearListClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure sbtnChildrenClick(Sender: TObject);
    procedure sbtnOwnedClick(Sender: TObject);
    procedure Callback1EnumWindows(Sender: TObject; var hWnd: Integer;
      var lpData: Longint; var retval: Integer);
  end;

var
  frmDSpy: TfrmDSpy;

implementation

{$R *.DFM}

uses
  About;

function Hex2 (B : byte) : string;
  const
    HT : array [$0..$F] of char
       = '0123456789ABCDEF';
  begin
    Hex2:=HT[B shr 4]+HT[B and $0F];
  end;

function Hex4 (W : word) : string;
  begin
    Hex4:=Hex2(hi(W))+Hex2(lo(W));
  end;

function GetBaseName (Name : pchar) : string;
  var
    B : string;
  begin
    B:=StrPas(Name);
    while (pos('\',B)>0) do delete(B,1,1);
    while (length(B)<13) do B:=B+' ';
    GetBaseName:=B;
  end;

function GetWindowDescription (hWnd : word) : string;
var
  Desc : string;
  TBuf : string;
  PBuf : pchar;
  Inst : word;
  Size : word;
begin
  (* get instance handle for application *)
  Inst:=GetWindowWord(hWnd,GWW_HINSTANCE);
  Desc:=Hex4(hWnd)+' ';

  (* get module filename *)
  PBuf:=StrAlloc(256);
  fillchar(PBuf^,256,0);
  Size:=GetModuleFileName(Inst,PBuf,255);
  TBuf:=GetBaseName(PBuf);
  StrDispose(PBuf);

  Desc:=Desc+TBuf+' "';
{  if (TBuf<>'WAOL.EXE     ') then
    begin
      GetWindowDescription:='';
      exit;
    end;}

  (* get class filename *)
  PBuf:=StrAlloc(256);
  fillchar(PBuf^,256,0);
  Size:=GetClassName(hWnd,PBuf,255);
  Size:=byte(Desc[0]);
  Desc:=Desc+StrPas(PBuf)+'"                         ';
  Desc[0]:=char(Size+20);
  StrDispose(PBuf);

  (* get window text *)
  PBuf:=StrAlloc(256);
  fillchar(PBuf^,256,0);
  Size:=GetWindowText(hWnd,PBuf,256);
  if PBuf[0]=#0 then
    begin
      Size:=SendMessage(hWnd,WM_GETTEXT,250,longint(PBuf));
      Desc:=Desc+' * '
    end
  else Desc:=Desc+'   ';
  Desc:=Desc+StrPas(PBuf);
  StrDispose(PBuf);

  (* return result *)
  GetWindowDescription:=Desc;
end;

procedure TfrmDSpy.sbtnTopClick(Sender: TObject);
var
  hWnd : word;
begin
  (* erase listbox *)
  lboxDisplay.Clear;

  (* get topmost window handle *)
  hWnd:=GetDeskTopWindow;

  (* get first child *)
  hWnd:=GetWindow(hWnd,GW_CHILD);
  repeat
    if (GetWindowDescription(hWnd)<>'') then
      lboxDisplay.Items.Add(GetWindowDescription(hWnd));
    hWnd:=GetWindow(hWnd,GW_HWNDNEXT);
  until hWnd=0;
end;

procedure TfrmDSpy.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TfrmDSpy.sbtnClearListClick(Sender: TObject);
begin
  lboxDisplay.Clear;
end;

procedure TfrmDSpy.btnAboutClick(Sender: TObject);
begin
  frmDSpy.Enabled:=false;
  frmAbout.Visible:=true;
  frmAbout.Show;
end;

procedure TfrmDSpy.sbtnChildrenClick(Sender: TObject);
  const
    HT : string[16] = '0123456789ABCDEF';
  var
    Desc  : string;
    Index : word;
    hWnd  : word;
  begin
    (* handle if no window handle is selected *)
    if (lboxDisplay.ItemIndex<0) then
      begin
        Application.MessageBox('No items selected from list.','E r r o r !',MB_OK+MB_ICONEXCLAMATION);
        exit;
      end;

    (* decode text window handle to binary *)
    Index:=lboxDisplay.ItemIndex;
    Desc:=lboxDisplay.Items.Strings[Index]+#0;
    hWnd:=0;
    repeat
      hWnd:=hWnd*16+pos(Desc[1],HT)-1;
      delete(Desc,1,1);
    until Desc[1]=' ';

    (* get child windows or generate error *)
    hWnd:=GetWindow(hWnd,GW_CHILD);
    if (hWnd=0) then
      begin
        Application.MessageBox('No children found for this window.','E r r o r !',MB_OK+MB_ICONEXCLAMATION);
        exit;
      end;

    (* clear listbox for new child windows *)
    lboxDisplay.Clear;

    (* fill with child of selected window *)
    repeat
      if (GetWindowDescription(hWnd)<>'') then
        lboxDisplay.Items.Add(GetWindowDescription(hWnd));
      hWnd:=GetWindow(hWnd,GW_HWNDNEXT);
    until hWnd=0;
  end;

procedure TfrmDSpy.sbtnOwnedClick(Sender: TObject);
  const
    HT : string[16] = '0123456789ABCDEF';
  var
    Desc  : string;
    Index : word;
    hWnd  : word;
  begin
    (* handle if no window handle is selected *)
    if (lboxDisplay.ItemIndex<0) then
      begin
        Application.MessageBox('No items selected from list.','E r r o r !',MB_OK+MB_ICONEXCLAMATION);
        exit;
      end;

    (* decode text window handle to binary *)
    Index:=lboxDisplay.ItemIndex;
    Desc:=lboxDisplay.Items.Strings[Index]+#0;
    hWnd:=0;
    repeat
      hWnd:=hWnd*16+pos(Desc[1],HT)-1;
      delete(Desc,1,1);
    until Desc[1]=' ';

    (* clear listbox for new child windows *)
    lboxDisplay.Clear;

    (* setup callback function *)
    boolean(Index):=EnumWindows(pchar(Callback1.ProcAddress),hWnd);

end;


procedure TfrmDSpy.Callback1EnumWindows(Sender: TObject; var hWnd: Integer;
  var lpData: Longint; var retval: Integer);
begin
  if (GetParent(hWnd)=word(lpData)) then
    if (GetWindowDescription(hWnd)<>'') then
      lboxDisplay.Items.Add(GetWindowDescription(hWnd));
  RetVal:=1;
end;

end.
