/* Unsort!
  Does the opposite of SORT (ie. DOS sort) it mixes up a file.
  The file must be TEXTual and have a maximum line length of something I
      havn't decided yet.  Well, maybe not.
*/

#include <alloc.h>
#include <ctype.h>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

char *get_str(FILE *in);

void syntax(void)
{
  printf("\
UNSORT V0.0  Written by Brian Buchanan.  Released into the Public Domain.\
\n\
  Takes zero, one or two arguments as names of text files, reads in,\n\
and randomizes the output.  In the case of 0 filenames, it uses STDIN and\n\
STDOUT.\n");
}

class Lines
{
  public:
    Lines *n;
    char *string;
    Lines() {string=NULL; n=NULL;}
    Lines(char *ns) {string=ns; n=NULL;}
    ~Lines() {if (string) free(string); n=NULL;}
    char *operator = (char *it);
};

char *Lines::operator = (char *it)
{
  if (string)
    free(string);
  string=it;
  return(string);
}

class Line_List
{
  public:
    int num_in;
    Lines *h;

    Line_List() {h=NULL; num_in=0;}
    ~Line_List();
    void add(char *ns);
    void kill(int n);
    char *gimme(int n);
};

void Line_List::kill(int n)
{
  Lines *temp, *temp1;

  temp=h;

  if (h)
  {
    if (n)
    { // Find the one before the one we want to kill
      while(temp && --n)
        temp=temp->n;
      // temp is the one before.
      temp1=temp->n;
      if (temp1)
      {
        temp->n=temp1->n;
        num_in--;
        delete(temp1);
      }
    }
    else
    { // Kill the head.
      h=temp->n;
      delete(temp);
      num_in--;
    }
  }
}

char *Line_List::gimme(int n)
{
  Lines *temp;

  temp=h;

  while(temp && n--)
    temp=temp->n;

  if (temp)
    return(temp->string);
  return(NULL);
}

void Line_List::add(char *ns)
{
  Lines *n;

  n=new Lines(ns);
  if (h)
  {
    n->n=h;
    h=n;
  }
  else
    h=n;
  num_in++;
}

Line_List::~Line_List()
{
  Lines *n;
  n=h;
  while(h)
  {
    n=h->n;
    delete(h);
    h=n;
  }
}


int main(int argc, char *argv[])
{
  Line_List my_llist;
  FILE *in=NULL, *out=NULL;
  char *temp;
  int i;
  struct time t;

  if (argc==3)
  { // Input is file based, not parameter.
    // The two arguments are considered to be filenames.
    if ((in=fopen(argv[1], "rt"))==NULL)
    {
      printf("Cannot open the input file. (%s)",argv[1]);
      return(2);
    }

    if ((out=fopen(argv[2], "wt"))==NULL)
    {
      printf("Cannot open the output file. (%s)",argv[2]);
      return(3);
    }
  }
  else
    if (argc==2)
    { // Only 1(real) argument.  Check for /? or ? or /H or H else, it's the
      // filename, useing STDOUT for output.
      if ( (toupper(argv[1][0])=='H') || (argv[1][0]=='?') ||
         ( (argv[1][0]=='/') && ( (toupper(argv[1][1])=='H') ||
                                  (argv[1][1]=='?') ) ) )
      {
        syntax();
        return(1);
      }
      else
       if ((in=fopen(argv[1], "rt"))==NULL)
       {
        fprintf(stderr,"Cannot open the input file. (%s)",argv[1]);
        return(2);
       }
    }
    else
      if (argc>3)
      {
        syntax();
        return(1);
      }
  if (in==NULL)
    in=stdin;
  if (out==NULL)
    out=stdout;

  // All files are open.  Read in the Linked List.

  while (!feof(in))
  {
    temp=get_str(in);
    if (temp)
      if (strlen(temp)>1)
        my_llist.add(temp);
  }

  srand((unsigned)time(NULL));

  gettime(&t);

  for(i=0;i<t.ti_hund;i++)
    random(i);

  while (my_llist.num_in)
  {
    i=random(my_llist.num_in);
    fprintf(out,"%s",my_llist.gimme(i));
    my_llist.kill(i);
  }

  fclose(in);
  fclose(out);
  return(0);
}

char *get_str(FILE *in)
{
  char *s1;

  int s1_max_len;

  s1_max_len=coreleft()<32767?coreleft():32767;
  s1=(char *)malloc(s1_max_len);

  if (fgets(s1, s1_max_len, in))
  {
//    printf("s1:%s:",s1);
    if ( (s1[strlen(s1)-1]!='\n') && (feof(in)) )
      strcat(s1,"\n");
    if (s1[strlen(s1)-1]!='\n')
    {
      free(s1);
      fprintf(stderr,"Error (or Out of memory) reading input file.\n");
      exit(4);
    }


    // Trim down the memory used by s1.
    s1=(char *)realloc(s1, strlen(s1)+1);
  }
  else
  {
    free(s1);
    s1=NULL;
  }

  return(s1);
}
