
/**************************************************************************
  EXAMPLE.C

  Written by:  Eric Jorgensen (April, 1995)

  This code was written using Turbo C.  It is intended to demonstrate the
  use of Varmint's Audio Tools and to provide a example code for program
  who wish to use VAT.

                          This code is FREEWARE

  You are free to distribute without any restrictions as long as you
  charge no fee.


**************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <alloc.h>
#include "sound.h"
#include <math.h>
#include <time.h>


#define getbit(x,y)  ((x>>y) & 0x01)
#define setbit(x,y) x = x & (0x01<<y)
#define togbit(x,y) x = x ^ (0x01<<y)

                                  // function prototypes
void fmdemo(void);
void mididemo(void);
void sb_intro(void);
void dspdemo(void);
void moddemo(void);
void vsyncdemo(void);
void introtext(void);
void diagnostics(void);
void debugoptions(void);

//-------------------------- DATA and Globals --------------------

                                  // Instrument data
char    inst[9][11] =
  {
    { 0x03,0x01,0x00,0x00,0xF3,0xE4,0x64,0x35,0x00,0x01,0x00},  // Harpsichord
    { 0x00,0x00,0x00,0x00,0x80,0x80,0x00,0x00,0x06,0x03,0x00},  // intro voice
    { 0x02,0x06,0x94,0x0A,0x80,0x80,0x00,0x00,0x00,0x00,0x00},  // intro voice
    { 0x00,0x04,0x00,0x00,0x80,0x80,0x00,0x00,0x00,0x00,0x00},
    { 0x01,0x01,0x40,0x40,0x80,0x80,0x00,0x00,0x01,0x00,0x00},
    { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01},
    { 0xA5,0xB1,0xD2,0x80,0x81,0xF1,0x03,0x05,0x00,0x00,0x02},
    { 0x72,0x62,0x1C,0x05,0x51,0x52,0x03,0x13,0x00,0x00,0x0E},
    { 0x11,0x01,0x8A,0x40,0xF1,0xF1,0x11,0xB3,0x00,0x00,0x06}};

int vints[8] = {1,2,1,2,1,2,1,2}; // voice defs for introduction
                                  // Start/end frequencies for intro
WORD startfreq[8] = {0xa000,0x6000,0xa000,0x2000,0x1000,0x9000,0xa000,0x6000};
WORD endfreq[8] =   {0x0800,0x2800,0x4800,0x6800,0x8800,0xa800,0xc800,0xe800};

char *regname[11] = {             // FM register name list
  "Amp mod/ vib/ eg type/ keyscale/ multiple 1",
  "Amp mod/ vib/ eg type/ keyscale/ multiple 2",
  "Key scale level / oper out level 1",
  "Key scale level / oper out level 2",
  "attack/decay rate 1",
  "attack/decay rate 2",
  "sustain level / release rate 1",
  "sustain level / release rate 2",
  "Feedback / Algorythm (oper 1&2)",
  "Wave Form  Select (oper 1)",
  "Wave Form  Select (oper 1)"
  };

char *effect_primary[] = {        // MOD command names
  "Arpeggio",
  "PortaM up",
  "PortaM down",
  "Porta NOTE",
  "Vibrato",
  "porta+vol",
  "Vib+vol",
  "Tremolo",
  "UNUSED",
  "Set offset",
  "Vol slide",
  "Postn Jmp",
  "Set Volume",
  "Pat Break",
  "special14",
  "Set Speed"};
char *effect_secondary[] = {
  "Filter T/F",
  "Finesld up",
  "Finesld dn",
  "Gliss T/F",
  "Vibr WF",
  "Finetune WF",
  "Loop Pattrn",
  "Tremolo WF",
  "UNUSED",
  "Retrigger",
  "FineVolS up",
  "FineVolS Dn",
  "Cut Sample",
  "Delay Sampl",
  "Delay Pttrn",
  "Invert Loop"};
                                          // Patchmap to work on really
                                          // lame MIDI ouput devices.
BYTE mypatchmap[16] = {0,0,0,0,0,1,1,1,1,1,2,2,2,2,2,2};

char hexchar[16] = {"0123456789ABCDEF"};  //  hexidecimal character list

SAMPLE *sound1,*sound2,*aha;
unsigned long int l1=1,l2=1,laha=1;
FILE *diagoutput= NULL;
int mpu_checked = FALSE;
int debug_appending = FALSE;

/**************************************************************************
  void main()

  DESCRIPTION:   Handles the main menu and sets things up

**************************************************************************/
void main(int argc,char *argv[])
{
  int i= 0;
  char r = 0,twirl[6]  = "|/-\\";

  if(argc>1) debugoptions();

  introtext();
  diagnostics();
                                       // THis is a littel snippet of code
                                       // Thad adds useful info to the
                                       // Survey.txt file.
  if(diagoutput) {
    fprintf(diagoutput,"DMA_bufferlen: %u\n",dma_bufferlen);
    fprintf(diagoutput,"Sample Rate: %u\n",sample_rate);
    fflush(diagoutput);
  }

  if(!debug_appending) {
    fclose(diagoutput);
    diagoutput = NULL;
  }

  if(SB_Setup()) {

    TimeVSync();                        // Check the length of the vertical
                                        // Retrace so VarmintVSync will
                                        // Work Properly

    if(diagoutput) {
      fprintf(diagoutput,"Post SB_setup settings: I:%d D:%d A:%X P:%X T:%d\n",intnr,dma_ch,io_addr,midi_port,card_id);
      fprintf(diagoutput,"DSP Version: %u.%u\n",dsp_vers>>8,dsp_vers&0xff);
      fprintf(diagoutput,"FM address: %X\n",fm_addr);
      fprintf(diagoutput,"Vsync_toolong: %2\n",vsync_toolong);
      fflush(diagoutput);
    }

    Go_Varmint();                            // Install  Varmint's tools
    if(diagoutput) {
      fprintf(diagoutput,"Got past Go_Varmint.\n");
      fflush(diagoutput);
    }

    sound1 = loadwave("doink.wav",&l1);     // Load up our sound effects
    sound2 = loadwave("wooeep.wav",&l2);
    aha = loadwave("aha.wav",&laha);
    if(!sound1 || !sound2 || !aha) {
      printf("ERROR loading sounds:  (%d,%d)\n",sound1,sound2);
      exit(0);
    }

    if(diagoutput) {
      fprintf(diagoutput,"Got past loadwave.\n");
      fflush(diagoutput);
    }

    sb_intro();                              // Get their attention

    if(diagoutput) {
      fprintf(diagoutput,"Got past sb_intro.\n");
      fflush(diagoutput);
      fclose(diagoutput);
    }

    while(kbhit()) getch();
    while(r != 'Q') {                       // Main input loop

      clrscr();                             // CLear screen and draw menu
      textcolor(DARKGRAY);
      //cprintf("far core left %lu",farcoreleft());
      textcolor(WHITE);
      gotoxy(20,8);
      cprintf("Demonstration:  Varmint's Audio Tools\n\n");
      textcolor(YELLOW);
      gotoxy(30,10);
      cprintf("1) FM voice");
      gotoxy(30,11);
      cprintf("2) MIDI");
      gotoxy(30,12);
      cprintf("3) Sounds");
      gotoxy(30,13);
      cprintf("4) MOD");
      gotoxy(30,14);
      cprintf("5) VSYNC");
      gotoxy(30,20);
      cprintf("Q) quit");

      while(!kbhit()) {                     // Draw a twirling thing while
                                            // we wait for a keypress.
        gotoxy(35,16);
        cprintf("%c",twirl[++i%4]);
        gotoxy(30,14);
        msdelay(50);
      }
      r = toupper(getch());                 // grab some input

      if(r == '1') fmdemo();                // Do something with it
      else if(r == '2') {
        mididemo();
      }
      else if(r == '3') {
        dspdemo();
      }
      else if(r == '4') {
        moddemo();
      }
      else if(r == '5') {
        vsyncdemo();
      }
    }
    Dropdead_Varmint();                     // Release Varmint's interrupt
  }
  else {
    printf("SB_Setup returned this error: %s \n",errname[sberr]);
    if(diagoutput) {
      fprintf(diagoutput,"Failed SB_setup.\n");
      fprintf(diagoutput,"SB_Setup returned this error: %s \n",errname[sberr]);
    }
  }
}


/**************************************************************************
  void vsyncdemo(void)

  DESCRIPTION: The demonstrates the use of VarmintVSync() for animation

**************************************************************************/
void vsyncdemo(void)
{
  int x=5;
  char *drawme = {"HONIG"};
  char r=0;

  clrscr();


  vsync_toolong = 4;                // This is the number of varmint ticks
                                    // that can happen between vertical
                                    // retraces.  (Assuming that the
                                    // Monitor is refreshed at aroun 65 hz)

                                    // Display intro text.
  gotoxy(2,16);
  printf("VAT's mixing kernel can interfere with ordinary functions that\n");
  printf("monitor the vertical retrace bit, causing `jerky' animation.\n");
  printf("With sync checking off, the animation above will jerk badly\n");
  printf("when you play sounds.  (Make sure any background MOD music is\n");
  printf("off, or you will not be able to see the difference.)\n\n");
  printf("Press 1,2, or 3 to play sounds.\n");
  printf("Press <space> to toggle sync checking, 'Q' to quit");

  gotoxy(60,23);                    // Display status of sync_on
  textcolor(YELLOW);
  if(sync_on) cprintf("SYNC ON  ");
  else cprintf("SYNC OFF ");

  while(toupper(r) != 'Q') {        // Input/animation loop
    if(kbhit()) {                   // Key stroke waiting?
      r = getch();
      if(r == ' ') {                // toggle sync checking
        sync_on ^= TRUE;
        gotoxy(60,23);
        if(sync_on) cprintf("SYNC ON  ");
        else cprintf("SYNC OFF ");
      }                             // Play sounds
      else if(r == '1') playsound(sound1,l1);
      else if(r == '2') playsound(sound2,l2);
      else if(r == '3') playsound(aha,laha);
    }

                                    // Animate a little bit of text
    gotoxy(x,4);
    printf("     ");

    x++;
    if(x>74) x= 1;

    gotoxy(x,4);
    printf("%s",drawme);

    VarmintVSync();                 // Wait for a retrace to finish

  }
}


/**************************************************************************
  moddemo(void)

  DESCRIPTION: Demo for playing MOD files

**************************************************************************/
void moddemo(void)
{
  int i,playme = 0;
  DWORD k;
  char r=0;
  static MOD *mymod = NULL;
  DWORD count=0,total=0;
  double oh;

  clrscr();                             // Clear the screen

  if(!mymod) {                          // Load the mod on first entry
    mymod = loadmod("noname.mod");
    if(!mymod) {
      printf("Unable to load MOD file: noname.mod");
      msdelay(2000);
      return;
    }
    mod_data = mymod;                   // Set initial mod parameters
    mod_reset = TRUE;
  }

  DSP_overhead = 1;                     // Turn on overhead checking

  textcolor(MAGENTA);
  gotoxy(4,2);
  cprintf("MOD demo menu");                 // Draw the menu
  textcolor(CYAN);
  gotoxy(4,4);
  cprintf("V,v     - Change music volume");
  gotoxy(4,5);
  cprintf("T,t     - Change music tempo");
  gotoxy(4,6);
  cprintf("M       - Music On/off toggle");
  gotoxy(4,7);
  cprintf("R       - Reset MOD");
  gotoxy(4,8);
  cprintf("1-4     - Toggle Channels on/off");
  gotoxy(4,9);
  cprintf("S       - Select Current sample");
  gotoxy(4,10);
  cprintf("<Space> - Play Current sample");
  gotoxy(4,12);
  cprintf("Q       - Quit");

  gotoxy(2,16);
  printf("MOD Title: %s ",mymod->title);


  while(toupper(r) != 'Q') {            // Input Loop
    if(kbhit()) {                       // Keyboard have input?
      r = getch();                                 // Grab the key
      if(r == 'm') mod_on ^= TRUE;                 // Mod on/off
      else if(r == 'V') {                          // Volume louder
        mod_volume--;
        if(mod_volume < 1) mod_volume = 1;
      }
      else if(r == 'v') {                          // Volume softer
        mod_volume++;
        if(mod_volume > 16) mod_volume = 16;
      }
      else if(r == 'T') {                          // Tempo faster
        mod_bytespertick-=10;
        if(mod_bytespertick < dma_bufferlen) mod_bytespertick = dma_bufferlen;
      }
      else if(r == 't') {                          // Tempo slower
        mod_bytespertick+=10;
        if(mod_bytespertick > 10000) mod_bytespertick = 10000;
      }
      else if(r == 'r') mod_reset = TRUE;          // Mod reset
      else if(r == '1') channel_select[0] ^= 1;    // Turn channels on/off
      else if(r == '2') channel_select[1] ^= 1;
      else if(r == '3') channel_select[2] ^= 1;
      else if(r == '4') channel_select[3] ^= 1;
      else if(r == 's') {                          // Cycle through samples
        playme++;
        while(!mymod->sdata[playme]) {
          playme++;
          if(playme>31) playme = 0;
        }
      }                                            // Play current sample
      else if(r == ' ') playsound(mymod->sdata[playme],mymod->slength[playme]);
    }

    k = vclock;
    while(k == vclock);                   // Wait for a clock tick

    VarmintVSync();                       // Wait for a vertical retrace
                                          // so there is less flicker

    for(i = 0; i < 4; i++) {
                                          // Darken unselected channels
      if(channel_select[i]) textcolor(YELLOW);
      else textcolor(BROWN);

      gotoxy(2,18+i);                    // Print the label
      cprintf("CHANNEL%d:",i+1);

      gotoxy(16,18+i);                   // Print sample number
      if(chan[i].position <= chan[i].end) {
        cprintf("%d",chan[i].sample_number);
      }
      else cprintf("   ");

      gotoxy(22,18+i);
      if(chan[i].position <= chan[i].end) {
        if(chan[i].effect != 14) cprintf("%s       ",effect_primary[chan[i].effect]);
        else cprintf("%s (E)      ",effect_secondary[chan[i].x]);
      }
      else cprintf("                  ");

      gotoxy(42,18+i);
      cprintf("%d",chan[i].period);

      gotoxy(52,18+i);
      cprintf("%d",chan[i].volume);
    }

    gotoxy(40,4);                         // SHow current volume
    printf("VOLUME BYTE: %d  ",mod_volume);

    gotoxy(40,5);                         // Show the tempo
    printf("TEMPO: %d  ",mod_bytespertick);

    gotoxy(40,6);                         // Show playing status
    if(mod_on) printf("MOD on  ");
    else printf("MOD off   ");

    gotoxy(40,7);                         // Print channel name/command info
    printf("Tick: %d Table position: %d  ",mod_currenttick,mod_tablepos);

    gotoxy(40,10);
    printf("Current sample: %d (%s)          ",playme+1,mymod->sample_name[playme]);

    count++;
    total+=DSP_overhead;
    if(count == 20) {
      oh = (total * 0.9218)/(count * dma_bufferlen) * sample_rate/11000.0;
      gotoxy(4,23);
      printf("CPU Overhead: %.2lf%% ",oh);
      total = 0;
      count = 0;
    }
  }

}


/**************************************************************************
  void dspdemo(void)

  DESCRIPTION:  Plays sound effects with Varmint's Audio Tools

**************************************************************************/
void dspdemo(void)
{
  char r = 0;
  DWORD tot = 0,num = 0,vc;
  double oh;

  DSP_overhead = 1;                           // turn on overhead checking

  clrscr();                                   // Clear screen and draw a menu
  textcolor(GREEN);
  gotoxy(25,8);
  cprintf("Sound effects demo menu");
  textcolor(YELLOW);
  gotoxy(25,10);
  cprintf("1,2,3 - Play a sound effect");
  gotoxy(25,11);
  cprintf("Q     - Quit");

  gotoxy(1,1);
  printf("CPU OVERHEAD: \nSAMPLES IN QUEUE: ");
  while(toupper(r) != 'Q') {         // input loop
    while(!kbhit()) {                // Wait for keystroke
      vc = vclock;
      while(vc == vclock);           // wait for the interrupt

      tot+= DSP_overhead;            // take an average every 40 interrupts
      num++;
      if(num == 40) {
        gotoxy(15,1);
        oh = (tot * 0.9218)/(num * dma_bufferlen)*sample_rate/11000;
        printf("%2.2lf%%  ",oh); // Show overhead
        gotoxy(19,2);
        printf("%d  \n",sounds_in_queue);       // Show # sounds playing
        num = 0;
        tot = 0;
      }
    }
    r = getch();                      // Get keystroke and act accordingly
    if(r == '1') playsound(sound1,l1);
    else if(r == '2') playsound(sound2,l2);
    else if(r == '3') playsound(aha,laha);
  }
}

/**************************************************************************
  void sb_intro(void)

  DESCRIPTION:  Cool introduction sith sound blaster music and sounds

**************************************************************************/
void sb_intro(void)
{
  int i,j;
  double fr;
  WORD f;

  clrscr();
  gotoxy(1,1);
  printf("Varmint's Audio Tools  (Version: %s)",VAT_VERSION);
  msdelay(500);

                                      // Cool introduction
  FM_Reset();
  for(i = 0; i < 2; i++) {
    playsound(aha,laha);              // Digital intro speach
    msdelay(15);
  }
  for(i = 0; i < 8; i++) {             // initialize music voices
    FM_SetVoice(i,inst[vints[i]]);
    FM_SetFreq(i,startfreq[i]);
    FM_SetVol(i,0x00);
    FM_KeyOn(i);
  }
  for(i = 0; i < 1000; i+= 1) {       // morph a big chord
    fr = i/1000.0;
    for(j = 0; j < 8; j++) {
      gotoxy(j*10+1,10);
      f = startfreq[j]+((double)endfreq[j]-(double)startfreq[j]) * fr;
      cprintf("%X  ",f);
      FM_SetFreq(j,f);
      FM_SetVol(j,fr*0x3f );
      FM_KeyOn(j);
    }
    msdelay(5);
    if(kbhit()) i = 1000;
  }

  if(!kbhit()) {
    for(i = 0; i < 8; i++) {          // Make sure all the notes are right
      FM_SetFreq(i,endfreq[i]);
      FM_KeyOn(i);
    }

    for(i = 0x3f ; i >= 0; i-= 1) {   // quiet down slowly
      for(j = 0; j < 8; j++) {
        FM_SetVol(j,i);
      }
      msdelay(i*2+40);
      if(kbhit() & i) i = 1;
    }
  }

  for(i = 0; i < 9; i++) {            // Silence them all
    FM_SetVol(i,0);                   // volume off
    FM_SetVoice(i,inst[0]);           // this instrument has a decay, so it
                                      // gets all the way quiet
    FM_SetFreq(i,1);                  // Low freq = quiet
  }

}
/**************************************************************************
  void mididemo(void)

  DESCRIPTION: Example function that loads and "plays" a  midi file

**************************************************************************/
void mididemo(void)
{
  int i,err;
  char errstring[256],r=0;
  static MIDI *bach  = NULL;

  clrscr();                                    // clear screen

  FM_Reset();

  for(i = 0 ; i < 9; i++) {
    FM_SetVol(i,0);
    FM_SetVoice ( i,inst[0]) ;                 // initialize voice
  }
  if(!bach) {
                                              // load a midi file
    err = ReadMidi("cannon_d.mid",&bach,(char *)errstring);
    if(err) {
      printf("MIDI read ERROR: %s\n",errstring);
      printf("Exit?\n");
      r = getch();
      if(r != 'n') return;
    }
    midi_data = bach;
    midi_reset = TRUE;
  }

  //printf("FORMAT:  %d  TRACKS: %d   DIVISION: %d\n",
  //        bach->format,bach->num_tracks,bach->divisions);


  textcolor(MAGENTA);
  gotoxy(30,2);
  cprintf("MIDI demo menu");
  textcolor(CYAN);
  gotoxy(30,4);
  cprintf("V,v - Change music volume");
  gotoxy(30,5);
  cprintf("T,t - Change music tempo");
  gotoxy(30,6);
  cprintf("M   - Toggle music: ");
  if(midi_on) printf("ON  ");
  else printf("OFF ");
  gotoxy(30,7);
  cprintf("R   - Reset Music");
  gotoxy(30,8);
  cprintf("F   - Toggle FM output: ");
  if(midi_fmout) printf("ON  ");
  else printf("OFF ");
  gotoxy(30,9);
  cprintf("U   - Toggle MPU output: ");
  if(midi_mpuout) printf("ON  ");
  else printf("OFF ");
  gotoxy(30,10);
  cprintf("P   - Set MPU-401 MIDI port");
  gotoxy(30,11);
  cprintf("A   - Toggle MIDI patchmap ");
  if(midi_patchmap == defaultpatchmap) printf("(16 channel)");
  else printf("( 3 channel)");
  gotoxy(30,13);
  cprintf("Q   - Quit");

  if(!mpu_available && mpu_checked) {
    gotoxy(1,20);
    printf("Current MPU-401 midi port is invalid.");
  }


  while(toupper(r) != 'Q') {                  // MAIN LOOP
    gotoxy(30,14);                            // print temppo and volume stats
    textcolor(WHITE);
    cprintf("Music Volume: %d  ",music_volume);
    gotoxy(30,15);
    cprintf("Music Tempo:  %.2f ",midi_usertempo);

    while(!kbhit()) {                         // handle the keyboard
      if(mpu_checked) {
        gotoxy(1,4);                          // check midi status while we wait
        if(mpu_timeout < 1000) printf("MPU status: OK!     ");
        else printf("MPU status: Timing out  ");
        gotoxy(1,5);
        printf("Current port: %X  ",midi_port);
      }
    }
    r = getch();                              // get keystroke

    if(r == 'V') {                            // Handle keystrokes
      music_volume++;
      if(music_volume > 0x3f) music_volume = 0x3f;
    }
    else if(r == 'v') {
      if(music_volume > 0) music_volume--;
    }
    else if(toupper(r) == 'A') {
      if(midi_patchmap == mypatchmap) midi_patchmap = defaultpatchmap;
      else midi_patchmap = mypatchmap;
      gotoxy(57,11);
      if(midi_patchmap == defaultpatchmap) printf("(16 channel)");
      else printf("( 3 channel)");
    }
    else if(toupper(r) == 'R') {
      midi_reset = TRUE;
    }
    else if(r == 'T') {
      midi_usertempo *= 1.02;
      if(midi_usertempo > 10.0) midi_usertempo = 10.0;
    }
    else if(r == 't') {
      midi_usertempo *= 0.98;
      if(midi_usertempo < 0.1) midi_usertempo = 0.1;
    }
    else if(toupper(r) == 'M') {
      midi_on ^= TRUE;
      gotoxy(50,6);
      if(midi_on) printf("ON  ");
      else printf("OFF ");
    }
    else if(toupper(r) == 'P') {               // Get a new MPU port address
      gotoxy(1,19);
      printf("Enter new port address in hex values [%x]: ",midi_port);
      gets(errstring);
      if(strlen(errstring)) sscanf(errstring,"%x",&midi_port);

                                               // check for accidents
      if(midi_port < 0x200 || midi_port > 0x360) midi_port = 0x330;
      mpu_available  = MPU_Reset();
      gotoxy(1,20);
      if(!mpu_available) printf("Current MPU-401 midi port is invalid.");
      else printf("                                               ");
      gotoxy(1,19);
      printf("                                                    ");
      mpu_checked = TRUE;
    }
    else if(toupper(r) == 'F') {               // Toggle output
      midi_fmout ^= TRUE;
      textcolor(CYAN);
      gotoxy(54,8);
      if(midi_fmout) printf("ON  ");
      else printf("OFF ");
    }
    else if(toupper(r) == 'U' && mpu_available) { // Toggle output
      midi_mpuout ^= TRUE;
      textcolor(CYAN);
      gotoxy(55,9);
      if(midi_mpuout) printf("ON  ");
      else printf("OFF ");
    }
  }
}


/**************************************************************************
  void bitprint(char byte)

  DESCRIPTION:  Prints individual bits and then a HEX value

**************************************************************************/
void bitprint(unsigned char byte)
{
  int i;

  cprintf("  ");
                                    // go through bits
  for(i = 7; i >= 0; i--) {
    if(getbit(byte,i)) {            // 1's are yellow
      textcolor(YELLOW);
      cprintf("1");
    }
    else {                          // 0's are dark grey
      textcolor(DARKGRAY);
      cprintf("0");
    }
  }

  textcolor(LIGHTBLUE);             // print the hex value
  cprintf("  %c%c",hexchar[byte/16],hexchar[byte%16]);
  textcolor(WHITE);
}



/**************************************************************************
  void fmdemo()

  DESCRIPTION:  Allows th user to mess around with instruments and
                play a few notes.


**************************************************************************/
void fmdemo(void)
{
  unsigned int i,cx,cy,voice=0,instrument = 0;
  int drawvoice = 1,rythm = 0;
  char r = 0;

  clrscr();                          // clear screen
  printf("FM demonstration screen");
  FM_Reset();
  for(i = 0; i < 9; i++) FM_KeyOff(i);

  gotoxy(1,16);
  cprintf("IJKL = cursor movement\r\n");
  cprintf("<space> = toggle bit\r\n");
  cprintf("numbers = play notes\r\n");
  cprintf("v = change voice\r\n");
  cprintf("n = Change instrument\r\n");
  cprintf("r = toggle rythm mode\r\n");
  cprintf("q = quit");

  _setcursortype(_SOLIDCURSOR);
  for( i = 0; i < 8; i++) {          // initialize voices
    FM_SetVoice ( i,inst[instrument]) ;
    FM_SetVol(i,0);
  }

  cx = 54;cy = 5;                    // init cursor position

  for(i = 0; i < 11; i++) {          // print register names
    gotoxy(50-strlen(regname[i]),i+5);
    textcolor(MAGENTA);
    cprintf("%s",regname[i]);
  }


  while(r != 'Q') {                  // main input loop
    if(drawvoice) {
      for(i = 0; i < 11; i++) {      // display instrument data
        gotoxy(52,i+5);
        bitprint(inst[instrument][i]);
      }
      for(i = 0; i < 9; i++) {
        FM_SetVoice ( i,inst[instrument]) ; // initialize new voice
      }
      drawvoice = 0;
      textcolor(LIGHTGRAY);
      gotoxy(52,4);
      cprintf("Instrument #%d ",instrument);
    }

    gotoxy(cx,cy);                   // put cursor in right spot

    while(!kbhit()){
    }

    r = toupper(getch());
    if(r >= '0' && r <= '9') {
      FM_KeyOff(voice);
      FM_SetVoice(voice,inst[instrument]);
      FM_SetNote ( voice, (r-'0'+3) * 8) ;
      FM_SetVol(voice,music_volume);
      FM_KeyOn(voice);
    }
    else if(r == 'I') {              // i,j,k,l = cursor movement
      cy = cy -1;
      if(cy<5) cy = 5;
    }
    else if(r == 'K') {
      cy = cy +1;
      if(cy >15) cy = 15;
    }
    else if(r == 'J') {
      cx = cx -1;
      if(cx<54) cx = 54;
    }
    else if(r == 'L') {
      cx = cx +1;
      if(cx>61) cx = 61;
    }
    else if(r == ' ') {              // space = toggle bit
      togbit(inst[instrument][cy-5],(7-(cx-54)));
      drawvoice = 1;
    }
    else if(r == 'N') {               // I = change instrument
      instrument++;
      if(instrument > 8) instrument = 0;
      drawvoice = 1;
    }
    else if(r == 'R') {              // r = toggle rythm mode
      if(rythm) rythm = 0;
      else rythm = 1;
      FM_RythmMode(rythm);           // do it
      FM_RythmOn(FM_HIHAT);
      gotoxy(1,2);                   // tell the user
      if(rythm) cprintf("Rythm Mode ON  (voices 6,7,8 only) ");
      else       cprintf("Rythm Mode OFF                     ");
    }
    else if(r == 'V') {              //  v = change voice
      FM_KeyOff(voice);
      FM_SetVol(voice,0);
      voice ++;
      if(voice > 8) voice = 0;
      gotoxy(1,3);
      cprintf("Voice: %d ",voice);
    }
    else if(r == 'W') {              // Frequency ramp
      for(i = 0; i < 0xf000; i+= 0x10) {
        FM_SetFreq(voice,i);
        FM_KeyOn(voice);
        msdelay(5);
      }
    }


  }
  for(i = 0; i < 9; i++) {
    FM_SetVol(i,0);
  }

}



/**************************************************************************
  void introtext(void)

  DESCRIPTION: Display introduction text for the user.


**************************************************************************/
void introtext(void)
{
  clrscr();
  printf("Varmint's Audio Tools (Version: %s) Demonstration\n",VAT_VERSION);
  printf("\n");
  textcolor(YELLOW);
  cprintf("Please edit the file survey.txt and return it to:\r\n");
  printf("\n");
  printf("     smeagol@rt66.com\n");
  printf("\n");
  printf("I am especially interested to know if this demo crashes and what\n");
  printf("causes it to do so.  I would also like to know what features\n");
  printf("you like, don't like and what you would like to see added.\n");
  printf("\n");
  printf("If this demo does not work properly try typing:  vatdemo -debug\n");
  printf("This will allow you to change certain options.\n");
  printf("\n");
  printf("\n\n                      -Eric Jorgensen\n");

  printf("\n\nPlease press the space bar to continue...");

  while(!kbhit());
  getch();
}


/**************************************************************************
  void diagnostics(void)

  DESCRIPTION:  This prepares survey.txt to receive diagnostic information
                and writes a few introductory things in that file.

**************************************************************************/
void diagnostics(void)
{
  static char *e;
  int i,j,k;
  DWORD t;

  diagoutput = fopen("survey.txt","w");    // Open survey file
  if(!diagoutput) return;

  printf("\nTesting and recording system configuration.\n");
                                           // Write the survey
  fprintf(diagoutput,"Survey for Varmint's Audio tools.\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"Please email the completed survey to smeagol@rt66.com\n");
  fprintf(diagoutput,"-----------------------------------------------------------------------------\n");
  fprintf(diagoutput,"VERSION %s (beta)\n",VAT_VERSION);
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"1) What's your name and email address?\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"2) How did you hear about Varmint's Audio tools and where did you find\n");
  fprintf(diagoutput,"   this copy?\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"3) Did the demo work on your computer?  If not, please describe what happened.\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"4) Have you tried earlier versions of VAT?  What versions?  Did the demos work?\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"5) Have you been able to use VAT in your own programs?  What features made\n");
  fprintf(diagoutput,"   it easy or difficult to do so?\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"6) Please describe your computer system:\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"                CPU (eg: 386,486,Pentium):\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"          Internal clock speed (eg:66Mhz):\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"  Operating system(eg: DOS/Windows, OS/2):\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"        Sound card (eg: PAS16, GUS, SB16):\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"\n");
  fprintf(diagoutput,"7) Please add any additional praise or chastisement of Varmint's Audio Tools:\n");

                                            // Print some autodiag info
  fprintf(diagoutput,"\n---------- AUTO DIAGNOSTIC INFORMATION ---------\n");
  fprintf(diagoutput,"Everything below here was written automatically by\n");
  fprintf(diagoutput,"the VAT demo.  Please do not delete these lines.\n");
  fprintf(diagoutput,"-------------------------------------------------\n\n");

  e = getenv("BLASTER");                    // Record BLASTER variable
  if(e) fprintf(diagoutput,"BLASTER env variable: %s\n",e);

  t = clock();                              // measure system performance
  for(i = 0; i < 1000; i++) {
    for(j = 0; j <  1000; j++ ) {
      k = i * j;
    }
  }
  t = clock()-t;

  fprintf(diagoutput,"Interger speed rating: %lu\n",t);

                                            // Check available memory
  fprintf(diagoutput,"Core left: %lu\n",farcoreleft());
  fflush(diagoutput);
}


/**************************************************************************
  void debugoptions(void)

  DESCRIPTION: Allows the user to set certain debug options.  These debug
               options will eventually be removed from the code when it
               is debugged.

**************************************************************************/
void debugoptions(void)
{
  char r = 0;


  clrscr();
  printf("VAT debug options\n");

  textcolor(LIGHTBLUE);

  gotoxy(10,5);
  cprintf("1) Force DSP to not use auto-init DMA");
  gotoxy(5,5);
  if(debug_lowdsp) printf("ON");
  else printf("OFF");

  gotoxy(10,6);
  cprintf("2) Disable interrupts in mixing Kernel");
  gotoxy(5,6);
  if(debug_intdisable) printf("ON");
  else printf("OFF");

  gotoxy(10,8);
  cprintf("3) Record debug information to survey.txt");
  gotoxy(5,8
  );
  if(debug_appending) printf("ON");
  else printf("OFF");

  gotoxy(5,20);
  printf("Press a number to toggle an option, or <space> to continue.");

  while(r != ' ') {
    r = toupper(getch());
    if(r == '1') {
      debug_lowdsp ^= TRUE;
      gotoxy(5,5);
      if(debug_lowdsp) printf("ON  ");
      else printf("OFF ");
    }
    else if(r == '2') {
      debug_intdisable ^= TRUE;
      gotoxy(5,6);
      if(debug_intdisable) printf("ON  ");
      else printf("OFF ");
    }
    else if(r == '3') {
      debug_appending ^= TRUE;
      gotoxy(5,8);
      if(debug_appending) printf("ON  ");
      else printf("OFF ");
    }
  }
}



