/*      SMIXW is Copyright 1995 by Ethan Brodsky.  All rights reserved      */

/*  SMIX.H  */

#define TRUE  1
#define FALSE 0

#define ON  1
#define OFF 0

typedef struct
  {
    signed   char *soundptr;
    unsigned long soundsize;
  } SOUND;

int  init_sb(int baseio, int irq, int dma, int dma16);
void shutdown_sb(void);

void init_mixing(void);
void shutdown_mixing(void);

void load_sound(SOUND **sound, char *filename);
void free_sound(SOUND **sound);

void start_sound(SOUND *sound, int index, int loop);
void stop_sound(int index);

extern volatile long intcount;         /* Current count of sound interrupts */
extern volatile int  voicecount;       /* Number of voices currently in use */

extern float dspversion;
extern int   autoinit;
extern int   sixteenbit;

/*  */

