(***************************************************************************)
(*                     craig e. smith - captain crunch                     *)
(***************************************************************************)
procedure set_video_page (video_page : byte);

assembler;

asm
  mov  ah, 0005h
  mov  al, video_page
  int      0010h
end;

(***************************************************************************)

procedure set_cursor_size (startline, stopline : byte);

assembler;

asm
  mov  ax, 0100h
  mov  bx, 0000h
  mov  ch, startline
  mov  cl, stopline
  int      0010h
end;

(***************************************************************************)
procedure delay (milliseconds : word);
assembler;
asm
  mov  ax, 03e8h
  mul      milliseconds
  mov  cx, dx
  mov  dx, ax
  mov  ah, 0086h
  int      0015h
end;
(***************************************************************************)
function key_pressed : boolean;
assembler;
asm
  mov  ah, 000bh
  int      0021h
  and  al, 00feh
end;
(***************************************************************************)
procedure get_a_keystroke;
assembler;
asm
  mov  ah, 0007h
  int  21h
end;
(***************************************************************************)
var
        k  : byte absolute $0040:$0017;
        s,
        l : byte;
begin
  set_cursor_size (7,0);
  set_video_page (1);
  s := k;
  l := 1;
  repeat
    k := ($0010 shl l);
    l := (l + 1) mod 3;
    delay(200);
  until key_pressed;
  get_a_keystroke;
  k := s;
  set_cursor_size (6,7);
  set_video_page (0)
end.
(***************************************************************************)
(*                                 the end                                 *)
(***************************************************************************)