#include "xinternl.h"
#include <i86.h>
#include <conio.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#define FONT_8x8  0
#define FONT_8x15 1
#define FONT_USER 2

#include "xdefs.h"

/*==================================================================
XRECT.CPP contains the basic functions for text manipulation in
mode X.  Since I was unable to get the pointers to the VGA ROM
fonts, I simply saved them to disk and included them in the headers,
tacking a couple extra K onto the files.

Also note that text routines as given take ( 3 * height ) OUT
instructions per character-- that adds up fast!

These routines were written initially by Themie Gouthas and
company and modified March 1995 by Victor B. Putz.
===================================================================*/


/* VARIABLES =========================================================== */

BYTE CharHeight = 0;     /* Char height of currently active font        */
BYTE CharWidth = 0;      /* Char width of currently active font         */
BYTE FirstChar = 0;      /* First char in the curr. active font         */

BYTE UserCharHeight = 0; /* Char height of currentle regist'd user font */
BYTE UserCharWidth = 0;  /* Char height of currentle regist'd user font */
BYTE UserFirstChar = 0;  /* First char of the curr. regist'd usera font */

BYTE * _pbFont = NULL;
BYTE * _pcUserFont = NULL;

//BYTE * _pbVGA8x8Font = NULL;
//BYTE * _pbVGA8x14Font = NULL;

#include "vga8x8.h"
#include "vga8x14.h"

// This is a look up table for the mirror image of a byte eg
// a byte with the value 11001010 has a corresponding byte in the table
// 01010011. This is necessary as the VGA rom font bits are the reverse
// order of what we need for the Mode X. If you know a better-faster way
// TELL ME!

BYTE abMirrorTable[] = {
	0,128, 64,192, 32,160, 96,224, 16,144, 80,208, 48,176,112,240,
	8,136, 72,200, 40,168,104,232, 24,152, 88,216, 56,184,120,248,
	4,132, 68,196, 36,164,100,228, 20,148, 84,212, 52,180,116,244,
	12,140, 76,204, 44,172,108,236, 28,156, 92,220, 60,188,124,252,
	2,130, 66,194, 34,162, 98,226, 18,146, 82,210, 50,178,114,242,
	10,138, 74,202, 42,170,106,234, 26,154, 90,218, 58,186,122,250,
	6,134, 70,198, 38,166,102,230, 22,150, 86,214, 54,182,118,246,
	14,142, 78,206, 46,174,110,238, 30,158, 94,222, 62,190,126,254,
	1,129, 65,193, 33,161, 97,225, 17,145, 81,209, 49,177,113,241,
	9,137, 73,201, 41,169,105,233, 25,153, 89,217, 57,185,121,249,
	5,133, 69,197, 37,165,101,229, 21,149, 85,213, 53,181,117,245,
	13,141, 77,205, 45,173,109,237, 29,157, 93,221, 61,189,125,253,
	3,131, 67,195, 35,163, 99,227, 19,147, 83,211, 51,179,115,243,
	11,139, 75,203, 43,171,107,235, 27,155, 91,219, 59,187,123,251,
	7,135, 71,199, 39,167,103,231, 23,151, 87,215, 55,183,119,247,
	15,143, 79,207, 47,175,111,239, 31,159, 95,223, 63,191,127,255
};

extern int ScrnLogicalByteWidth;
extern BYTE * pbVGABuffer;

BYTE FontDriverActive = 0;


/* FUNCTIONS =========================================================== */

WORD x_text_init(
	void
)
{

	FontDriverActive = TRUE;
	_pbFont = _pbVGA8x8Font;
  CharHeight = CharWidth = 8;
  return 0;
}

/* Set the font style          */
void x_set_font(
	int FontId
)
{
  switch ( FontId ) {
    case 2 : //user font
    	_pbFont = _pcUserFont;
      CharHeight = UserCharHeight;
      CharWidth = UserCharWidth;
      FirstChar = UserFirstChar;
  	break;
    case 1 :
    	_pbFont = _pbVGA8x14Font;
			CharHeight = 14;
			CharWidth = 8;
			FirstChar = 0;
		break;
		case 0 :
			_pbFont = _pbVGA8x8Font;
			CharHeight = 8;
			CharWidth = 8;
			FirstChar = 0;
		break;
  }
}

void x_register_userfont(          /* register a user defined font */
 BYTE * UserFontPtr
)
{
  _pcUserFont = UserFontPtr + 4;
  UserFirstChar = *( UserFontPtr );
  UserCharHeight = *( UserFontPtr + 2 );
  UserCharWidth = *( UserFontPtr + 3 );
}


unsigned int  x_get_char_width(    /* Get the character width      */
  char ch
)
{
  if ( CharWidth != 0 ) {
    return CharWidth;
  }
  else {
    return *( _pbFont + ( ch - FirstChar + 1 )*( CharHeight + 1 ) - 1 );
  }
}


unsigned short awTextMask[16] = { 0x0002, 0x0102, 0x0202, 0x0302,
                                 0x0402, 0x0502, 0x0602, 0x0702,
                                 0x0802, 0x0902, 0x0A02, 0x0B02,
                                 0x0C02, 0x0D02, 0x0E02, 0x0F02 };

unsigned int  x_char_put(          /* Draw a text character using  */
  char ch,                  /* the currently active font    */
  xScreenCoord_t X,
  xScreenCoord_t Y,
  xPageHandle_t PgOffs,
  xColor_t Color
)
{
	int iScreenInc = ScrnLogicalByteWidth - 3;
	BYTE * pbStart = pbVGABuffer + Y * ScrnLogicalByteWidth + X / 4 + PgOffs;
  int iFirstPlane = X & 3;
  BYTE * pbChar = 0;
  if ( CharWidth == 0 ) {
    pbChar =( BYTE * )_pbFont + ( ch - FirstChar ) * ( CharHeight + 1 );
  }
  else {
    pbChar =( BYTE * )_pbFont + ( ch - FirstChar ) * ( CharHeight );
  }
  int iTemp = 0;
  for ( int i = CharHeight; i > 0; --i ) {
    iTemp = *pbChar++;
    if ( _pbFont != _pcUserFont ) {
      iTemp = abMirrorTable[ iTemp ];
    }
    iTemp <<= iFirstPlane;
//TEST STUFF!
    outpw( SC_INDEX, awTextMask[ iTemp & 0x0f ] );
    *pbStart++ = ( BYTE )Color;
    outpw( SC_INDEX, awTextMask[ ( iTemp & 0xf0 ) >> 4 ] );
    *pbStart++ = ( BYTE )Color;
		outpw( SC_INDEX, awTextMask[ iTemp >> 8 ] );
    *pbStart++ = ( BYTE )Color;

    pbStart += iScreenInc;
  }
  return x_get_char_width(ch);
}


/* the folowing function is from xprintf.c but is included due to its     */
/* close relationship with this module                                    */

void x_printf(
	xScreenCoord_t x,
	xScreenCoord_t y,
	xPageHandle_t ScrnOffs,
	xColor_t color,
	char *ln,
	...
)
{
  char dlin[100],*dl=dlin;
  va_list ap;

  va_start(ap,ln);
  vsprintf(dlin,ln,ap);
  va_end(ap);

  while(*dl){
      x+=x_char_put(*dl++,x,y,ScrnOffs,color);
  }

}

extern void x_rect_fill(
	xScreenCoord_t, xScreenCoord_t,
	xScreenCoord_t, xScreenCoord_t,
	xPageHandle_t, xColor_t
);

void x_bgprintf(
	xScreenCoord_t x,
	xScreenCoord_t y,
	xPageHandle_t ScrnOffs,
	xColor_t fgcolor,
  xColor_t bgcolor,
	char *ln,
	...
)
{
  char dlin[100],*dl=dlin;
  va_list ap;

  va_start(ap,ln);
  vsprintf(dlin,ln,ap);
  va_end(ap);

  while(*dl){
      x_rect_fill(x,y,x+x_get_char_width(*dl),y+CharHeight,ScrnOffs,bgcolor);
      x+=x_char_put(*dl++,x,y,ScrnOffs,fgcolor);
  }
}

