#include "xinternl.h"
#include <conio.h>
#include <mem.h>
/*==================================================================
XPBMCLIP.CPP contains the basic functions for clipped bitmap puts.

Note that the horizontal clipping coordinates are given in nibble
widths, ie they clip roughly to boundaries which are multiples of
four pixels.

These routines were written initially by Themie Gouthas and
company and modified March 1995 by Victor B. Putz.
===================================================================*/

extern xScreenCoord_t TopClip;                /* Clipping rectangle                  */
extern xScreenCoord_t BottomClip;
extern xScreenCoord_t LeftClip;
extern xScreenCoord_t RightClip;

extern BYTE * pbVGABuffer;
extern int ScrnLogicalByteWidth;


/*
_ClipX() clips the x coordinates of a bitmap
*/
inline void _ClipX(
	xScreenCoord_t X,
  int iWidth,
  int * piOffsetFromLeft,
  int * piWidthToDraw
)
{
  *piOffsetFromLeft = LeftClip - ( X / 4 );
  if ( *piOffsetFromLeft < 0 ) {
    *piOffsetFromLeft = 0;
  }
  int iOffsetFromRight  = ( X / 4 + iWidth ) - RightClip;
  if ( iOffsetFromRight < 0 ) {
    iOffsetFromRight = 0;
  }
  *piWidthToDraw = iWidth - ( *piOffsetFromLeft + iOffsetFromRight );
}


/*
_ClipY() clips the Y coordinates of a bitmap
*/
inline void _ClipY(
	xScreenCoord_t Y,
  int iHeight,
  int * piOffsetFromTop,
  int * piHeightToDraw
)
{
  *piOffsetFromTop = TopClip - Y;
  if ( *piOffsetFromTop < 0 ) {
    *piOffsetFromTop = 0;
  }
  int iOffsetFromBottom  = Y + iHeight - BottomClip;
  if ( iOffsetFromBottom < 0 ) {
    iOffsetFromBottom = 0;
  }
  *piHeightToDraw = iHeight - ( *piOffsetFromTop + iOffsetFromBottom );
}


int x_put_masked_pbm_clipxy( /* Copy a planar bitmap from SRAM masking */
  xScreenCoord_t X,          /* only non zero pixels to VRAM           */
  xScreenCoord_t Y,          /* Supports clipping in the Y direction   */
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap
)
{
  BYTE * pbSource = Bitmap;
  int iWidth = *pbSource++;
  int iHeight = *pbSource++;
	//first let's get our clipping dimensions.  We'll need an "offset from
  //left" value, a width to draw value, an "offset from top" value, and a
  //"height to draw" value.
	int iOffsetFromLeft;
  int iWidthToDraw;
  _ClipX( X, iWidth, &iOffsetFromLeft, &iWidthToDraw );
  if ( iWidthToDraw < 0 ) {
    return 1;
  }
  //now do Y
  int iOffsetFromTop;
  int iHeightToDraw;
  _ClipY( Y, iHeight, &iOffsetFromTop, &iHeightToDraw );
  if ( iHeightToDraw < 0 ) {
    return 1;
  }

  BYTE * pbDest = pbVGABuffer + ScrnOffs +
		ScrnLogicalByteWidth * ( Y + iOffsetFromTop ) +
		X / 4 + iOffsetFromLeft;
  BYTE * pbDestCounter = pbDest;

  int iSkip = ScrnLogicalByteWidth - iWidthToDraw;
  outp( SC_INDEX, MAP_MASK );
  int iPlane = X & 3;
  int iAdjust = 0;
  for( int iPlaneCounter = 4; iPlaneCounter != 0; --iPlaneCounter ) {
    pbDestCounter = pbDest + iAdjust;
    pbSource = Bitmap + 2 + ( 4 - iPlaneCounter ) * iWidth * iHeight + iOffsetFromTop * iWidth + iOffsetFromLeft;
  	outp( SC_INDEX + 1, 1 << iPlane );
    for ( int iRowCounter = iHeightToDraw; iRowCounter != 0; --iRowCounter ) {
    	for ( int iWidthCounter = iWidthToDraw; iWidthCounter != 0; --iWidthCounter ) {
	      BYTE bTemp = *pbSource++;
	      if ( bTemp ) {
	        *pbDestCounter++ = bTemp;
	      }
	      else {
	        pbDestCounter++;
	      }
      }
      pbSource += iWidth - iWidthToDraw;
      pbDestCounter += iSkip;
    }
    iPlane++;
    if ( iPlane == 4 ) {
      iAdjust = 1;
    }
    iPlane &= 3;
  }
  return 0;
}


int x_put_pbm_clipxy(   /* Copy a planar bitmap from SRAM masking */
  xScreenCoord_t X,     /* Supports clipping in the X&Y directions */
  xScreenCoord_t Y,
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap
)
{
  BYTE * pbSource = Bitmap;
  int iWidth = *pbSource++;
  int iHeight = *pbSource++;
	//first let's get our clipping dimensions.  We'll need an "offset from
  //left" value, a width to draw value, an "offset from top" value, and a
  //"height to draw" value.
	int iOffsetFromLeft;
  int iWidthToDraw;
  _ClipX( X, iWidth, &iOffsetFromLeft, &iWidthToDraw );
  if ( iWidthToDraw < 0 ) {
    return 1;
  }
  //now do Y
  int iOffsetFromTop;
  int iHeightToDraw;
  _ClipY( Y, iHeight, &iOffsetFromTop, &iHeightToDraw );
  if ( iHeightToDraw < 0 ) {
    return 1;
  }

  BYTE * pbDest = pbVGABuffer + ScrnOffs +
		ScrnLogicalByteWidth * ( Y + iOffsetFromTop ) +
		X / 4 + iOffsetFromLeft;
  BYTE * pbDestCounter = pbDest;

  outp( SC_INDEX, MAP_MASK );
  int iPlane = X & 3;
  int iAdjust = 0;
  for( int iPlaneCounter = 4; iPlaneCounter != 0; --iPlaneCounter ) {
    pbDestCounter = pbDest + iAdjust;
    pbSource = Bitmap + 2 + ( 4 - iPlaneCounter ) * iWidth * iHeight + iOffsetFromTop * iWidth;
  	outp( SC_INDEX + 1, 1 << iPlane );
    for ( int iRowCounter = iHeightToDraw; iRowCounter != 0; --iRowCounter ) {
      memcpy( pbDestCounter, pbSource + iOffsetFromLeft, iWidthToDraw );
      pbSource += iWidth;
      pbDestCounter += ScrnLogicalByteWidth;
    }
    iPlane++;
    if ( iPlane == 4 ) {
      iAdjust = 1;
    }
    iPlane &= 3;
  }
  return 0;
}
