#include "xinternl.h"
#include <conio.h>
#include <mem.h>

/*==================================================================
XPBITMAP.CPP contains the basic functions for bitmap manipulation.

These routines were written initially by Themie Gouthas and
company and modified March 1995 by Victor B. Putz.
===================================================================*/


extern int ScrnLogicalByteWidth;
extern BYTE * pbVGABuffer;


void x_put_masked_pbm(  /* Copy a planar bitmap from SRAM masking */
  xScreenCoord_t X,    /* only non zero pixels to VRAM           */
  xScreenCoord_t Y,
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap)
{
  BYTE * pbSource = Bitmap;
  int iWidth = *pbSource++;
  int iHeight = *pbSource++;
  BYTE * pbDest = pbVGABuffer + ScrnOffs + ( ScrnLogicalByteWidth * Y ) + X / 4;
  BYTE * pbDestCounter = pbDest;
  int iSkip = ScrnLogicalByteWidth - iWidth;
  outp( SC_INDEX, MAP_MASK );
  int iPlane = X & 3;
  int iAdjust = 0;
  for( int iPlaneCounter = 4; iPlaneCounter != 0; --iPlaneCounter ) {
    pbDestCounter = pbDest + iAdjust;
    pbSource = Bitmap + 2 + ( 4 - iPlaneCounter ) * iWidth * iHeight;
  	outp( SC_INDEX + 1, 1 << iPlane );
    for ( int iRowCounter = iHeight; iRowCounter != 0; --iRowCounter ) {
    	for ( int iWidthCounter = iWidth; iWidthCounter != 0; --iWidthCounter ) {
	      BYTE bTemp = *pbSource++;
	      if ( bTemp ) {
	        *pbDestCounter++ = bTemp;
	      }
	      else {
	        pbDestCounter++;
	      }
      }
      pbDestCounter += iSkip;
    }
    iPlane++;
    if ( iPlane == 4 ) {
      iAdjust = 1;
    }
    iPlane &= 3;
  }
}

void x_flip_masked_pbm(  /* Copy a planar bitmap from SRAM masking */
  xScreenCoord_t X,     /* only non zero pixels to VRAM. Bitmap   */
  xScreenCoord_t Y,     /* is mirrored.                           */
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap,
  int orientation);

void x_put_pbm(         /* Copy a planar bitmap from SRAM to VRAM */
  xScreenCoord_t X,
  xScreenCoord_t Y,
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap
)
{
  BYTE * pbSource = Bitmap;
  int iWidth = *pbSource++;
  int iHeight = *pbSource++;
  BYTE * pbDest = pbVGABuffer + ScrnOffs + ( ScrnLogicalByteWidth * Y ) + X / 4;
  BYTE * pbDestCounter = pbDest;

  outp( SC_INDEX, MAP_MASK );
  int iPlane = X & 3;
  int iAdjust = 0;
  for( int iPlaneCounter = 4; iPlaneCounter != 0; --iPlaneCounter ) {
    pbDestCounter = pbDest + iAdjust;
    pbSource = Bitmap + 2 + ( 4 - iPlaneCounter ) * iWidth * iHeight;
  	outp( SC_INDEX + 1, 1 << iPlane );
    for ( int iRowCounter = iHeight; iRowCounter != 0; --iRowCounter ) {
      memcpy( pbDestCounter, pbSource, iWidth );
      pbSource += iWidth;
      pbDestCounter += ScrnLogicalByteWidth;
    }
    iPlane++;
    if ( iPlane == 4 ) {
      iAdjust = 1;
    }
    iPlane &= 3;
  }
}


void x_flip_pbm(         /* Copy a planar bitmap from SRAM to VRAM */
  xScreenCoord_t X,
  xScreenCoord_t Y,
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap,
  int orientation);

void x_get_pbm(         /* Copy a planar bitmap from VRAM to SRAM */
  xScreenCoord_t X,
  xScreenCoord_t Y,
  int iNibbleWidth,
  int iHeight,
  xPageHandle_t ScrnOffs,
  BYTE * Bitmap)
{
  BYTE * pbDest = Bitmap;
  *pbDest++ = ( BYTE )iNibbleWidth;
  *pbDest++ = ( BYTE )iHeight;
  BYTE * pbSource = pbVGABuffer + ScrnOffs + ( ScrnLogicalByteWidth * Y ) + X / 4;
  BYTE * pbSourceCounter = pbSource;
  outp( GC_INDEX, READ_MAP );
  int iPlane = X & 3;
	//an adjustment mark for incrementing the start in video memory after
  //we've passed plane 4
  int iAdjust = 0;
  for( int iPlaneCounter = 4; iPlaneCounter != 0; --iPlaneCounter ) {
    pbSourceCounter = pbSource + iAdjust;
    pbDest = Bitmap + 2 + (4 - iPlaneCounter) * iNibbleWidth * iHeight;
  	outp( GC_INDEX + 1, iPlane );
    for ( int iRowCounter = iHeight; iRowCounter != 0; --iRowCounter ) {
      memcpy( pbDest, pbSourceCounter, iNibbleWidth );
      pbDest += iNibbleWidth;
      pbSourceCounter += ScrnLogicalByteWidth;
    }
    iPlane++;
    if ( iPlane == 4 ) {
      iAdjust = 1;
    }
    iPlane &= 3;
  }
}
