		----------------------------------------
		-- Machine Level Programming for 386+ --
		----------------------------------------

-- Warning: Some of these routines require a knowledge of 
-- machine-level programming. You could crash your system.
-- Only superficial checking of argument values is provided.

-- These routines, along with peek(), poke() and call(), let you access all 
-- of the features of your computer.  You can read and write to any memory 
-- location, and you can create and execute machine code subroutines.

-- Writing characters to screen memory with poke() is much faster than  
-- using puts().
-- address of start of text screen memory 
--       mono: #B0000
--      color: #B8000

-- see demo\callmach.ex for an example of calling a machine language routine

constant M_ALLOC = 16,
	 M_FREE = 17

-- biggest address on a 32-bit machine
constant MAX_ADDR = power(2, 32)-1

type machine_addr(atom a)
-- a legal machine address 
    return a > 0 and a <= MAX_ADDR and floor(a) = a
end type

global function allocate(integer n)
-- allocate n bytes of memory and return the address
    return machine_func(M_ALLOC, n)
end function

global procedure free(machine_addr a)
-- free the memory at address a
    machine_proc(M_FREE, a)
end procedure

global function int_to_bytes(atom x)
-- returns value of x as a sequence of 4 bytes 
-- that you can poke into memory 
--      {bits 0-7,  (least significant)
--       bits 8-15,
--       bits 16-23,
--       bits 24-31} (most significant)
-- This is the order of bytes in memory on 386+ machines.
    integer a,b,c,d
    
    a = remainder(x, #100)
    x = floor(x / #100)
    b = remainder(x, #100)
    x = floor(x / #100)
    c = remainder(x, #100)
    x = floor(x / #100)
    d = remainder(x, #100)
    return {a,b,c,d}
end function

global function bytes_to_int(sequence s)
-- converts 4-byte peek() sequence into an integer value
    return s[1] + 
	   s[2] * #100 + 
	   s[3] * #10000 + 
	   s[4] * #1000000
end function

global function int_to_bits(atom x, integer nbits)
-- Returns the low-order nbits bits of x as a sequence of 1's and 0's. 
-- Note that the least significant bits come first. You can use Euphoria's
-- and/or/not operators on sequences of bits. You can also subscript, 
-- slice, concatenate etc. to manipulate bits.
    sequence bits
    
    if x < 0 then
	x = x + power(2, nbits) -- provide 2's complement bit pattern
    end if
    bits = repeat(0, nbits)
    for i = 1 to nbits do
	bits[i] = remainder(x, 2) 
	x = floor(x / 2)
    end for
    return bits
end function

global function bits_to_int(sequence bits)
-- get the (positive) value of a sequence of "bits"
    atom value, p
    
    value = 0
    p = 1
    for i = 1 to length(bits) do
	if bits[i] then
	    value = value + p
	end if
	p = p + p
    end for
    return value
end function

