(**************************************)
(*   Programming:  Bob Dalton         *)
(*   DEMO OF DOOR FILE SETUP ROUTINE  *)
(**************************************)

PROGRAM LDEMO;    (* Initialization Program -- resets player file *)
{$R-}
{$S+}
{$I+}
{$N-}
{$M 65520,16384,655360}

Uses
 Crt,
 DOS,
 DDPlus,
 Elog,
 NETFILEP;

Const
  Version1 = '0.00';
  Author = 'Bob Dalton';
Type
  PlayerRecord = Record
                   PRecordNumber:Byte;
                   Item1: String[15]; {Player name}
                   Item2: LongInt;    {Player money}
                   Item3: Integer;    {Player soldiers}
                   Item4: Byte;       {Player cannons}
                   Item5: String[1];  {Is he King}
                 End;

  GlobRec = Record
             MaxPlayers:Byte;
             MaxMoney  :LongInt;
            End;

  PlayerList = File of PlayerRecord;
  GlobFile1 = File of GlobRec;

VAR
  Qty: String[7];
  Palias:String[15];
  GoAhead: Boolean;
  OpenAttempts:Byte;
  CurRecord : longint;
  PlayerFile: PlayerList;
  Player: PlayerRecord;
  Year,Month,Day,Dow: Word;
  Glob:GlobRec;
  GlobFile:GlobFile1;
  Y99: Byte;
  Good:Boolean;
  Code:Integer;
  Vmoney:Integer;

Function GetInput(s:string;Cap,Len:Integer):string;
 Var Ps:string;
 Begin
  Prompt(Ps,Len,false);
  GetInput:=Ps
 End;


FUNCTiON GetChar:Char;
 Var C:Char;
 Begin
  Sread_Char(C);
  GetChar:=C
 End;

PROCEDURE Nsp(I:LongInt);
VAR Convnum:String[25];
 BEGIN
  Str(I,Convnum);
  Swrite(Convnum)
 End;

PROCEDURE TC( Cor: Byte);
  Begin
   Set_Foreground(Cor)
  End;

PROCEDURE CP(X,Y: Integer);
 Begin
  Sgoto_XY(x,y)
 End;

PROCEDURE Pause1;
VAR C:char;
 Begin
  CP(1,23);
  TC(6);
  Swrite('Press any key to continue');
  Sread_Char(C);
 End;

Procedure ReadGlobalFile(VAR Glob:GlobRec); {Example of File Locking}
 Begin
  Assign(GlobFile,'GLOB.DAT');
  OpenAttempts:=1;
  Repeat
   {$I-}
   Reset(GlobFile); {opens the file}
   {$I+};
   GoAhead:= (IOResult = 0);
   If Not GoAhead then OpenAttempts :=OpenAttempts+1;
  Until (GoAhead) or (OpenAttempts>1000);
  Read(GlobFile,Glob);{reads the entire file}
  Close(GlobFile);{closes the file}
  SClrScr;
  SWriteLn('');
  SWriteLn('');
  SWriteLn('');
  SWrite('Max Players Allowed: ');NSP(Glob.MaxPlayers);
  SWriteln('');
  SWrite('Max Money Allowed  : ');NSP(Glob.MaxMoney);
  SWriteln('');
  Pause1;
  SClrScr;
 End;

Procedure WriteGlobalFile(VAR Glob:GlobRec); {Example of File Locking}
 Begin
  SClrScr;
  SWriteLn('');
  SWriteLn('');
  SWriteLn('');
  SWrite('Max Players Allowed: ');NSP(Glob.MaxPlayers);
  SWriteln('');
  Repeat
   SWriteLn('');
   SWrite('New maximum amount of players <Max of 100>: ');
   QTY:=GetInput('',0,15);
   VAL (Qty,Vmoney,code);
  UNTIL (Vmoney > 1) OR (Code <> 0);
  Glob.MaxPlayers:=Vmoney;
  SwriteLn('');
  SWrite('Max Money Allowed  : ');NSP(Glob.MaxMoney);
  SWriteln('');
  Repeat
   SWriteLn('');
   SWrite('New maximum amount of player money <Max of $5000>: ');
   QTY:=GetInput('',0,15);
   VAL (Qty,Vmoney,code);
  UNTIL (Vmoney > 1) OR (Code <> 0);
  Glob.MaxMoney:=Vmoney;
  SwriteLn('');
  SClrScr;
  IF ShareInst then FileMode:=64; {Prevents changes to file until YOU are done with it}
  Assign(GlobFile,'GLOB.DAT');
  OpenAttempts:=1;
  Repeat
   {$I-}
   Rewrite(GlobFile);{Writes a zero byte file}
   {$I+};
   GoAhead:= (IOResult = 0);
   If Not GoAhead then OpenAttempts :=OpenAttempts+1;
  Until (GoAhead) or (OpenAttempts>1000);
  Write(GlobFile,Glob);  {writes the information to the data file}
  Close(GlobFile);{closes the file}
  IF ShareInst then FileMode:=66; {Allows changes to file}
 End;

{The procedure below searches an entire data file of records until
 it finds a matching record.  Once we find that record we automatically
 know what the record number is because there is a variable in the record
 which tells us.}

PROCEDURE GetPlayerName( Palias: String;
                         VAR Gplay: PlayerRecord;
                         VAR Good: Boolean);
VAR Pfile: PlayerList;Temp: PlayerRecord;
 Begin
  Assign(Pfile,'PLAYER.DAT');
  OpenAttempts:=1;
  Repeat
   {$I-}
   Reset(Pfile); {Opens the file}
   {$I+};
   GoAhead:= (IOResult = 0);{Traps errors so program does not abort}
   If Not GoAhead then OpenAttempts :=OpenAttempts+1;  {Increments counter}
  Until (GoAhead) or (OpenAttempts>1000);{Loop just in case}
  Good:=False;
  If NOT EOF(Pfile) THEN {If not enod file continue checking}
   REPEAT
    Read(Pfile,Temp); {reads a record from the file and assigns it to TEMP}
    If Palias = Temp.Item1 THEN Good:=True  {If name matches then we got it!}
   UNTIL (GOOD) OR EOF(Pfile); {Until we find it or we reach the end of the file}
  Close(Pfile);{Gotta close it!}
  IF Good THEN Gplay:=Temp {assigns the temp record we found to GPLAY}
 End;

Procedure ReadAPlayerRecord(VAR Player: PlayerRecord); {Example of Record Locking}
VAR Palias:String[15];
 Begin
  SClrScr;
  SWriteLn('');
  SWriteLn('');
  Good:=False;
  Repeat
   Repeat
    SWriteLn('');
    SWriteLn('');
    SClrScr;
    SwriteLn('NOTE: Data you type is case sensitive!');
    SWrite('Who would you like to Display <try Hamlet first!>: ');
    Palias:=GetInput('',0,15);
   UNTIL PAlias <> '';
   GetPlayerName(Palias,Player,Good); {Procedure to search database file}
   If Good=False then
    Begin
     SwriteLn('No such player by that name - try again,');
    End;
  Until Good=True;
  Assign(PlayerFile,'PLAYER.DAT');
  OpenAttempts:=1;
  Repeat
   {$I-}
   Reset(PlayerFile); {Must do before reading/writing records!}
   {$I+}
   GoAhead:= (IOResult = 0); {Traps I/O errors so program does not abort}
   If Not GoAhead then OpenAttempts :=OpenAttempts+1;{increments loop counter}
  Until (GoAhead) or (OpenAttempts>1000); {A loop in case someone else is using it}
  CurRecord := Player.PRecordNumber;{Very important!!!}
  NetSeek( PlayerFile, CurRecord ); {Moves pointer to that record}
  NetLock( PlayerFile, CurRecord, 1 ); {Locks that record}
  NetRead( PlayerFile, Player); {Reads that record}
  NetUnlock( PlayerFile, CurRecord, 1 ); {Unlocks that record}
  Close(PlayerFile);{Closes the file}
  SClrScr;
  SWriteLn('');
  SWriteLn('');
  Swrite('PlayerRecord Number: ');NSP(Player.PRecordNumber);
  SWriteLn('');
  Swrite('Player Name: '+Player.Item1);
  SWriteLn('');
  Swrite('Player Money: $');;NSP(Player.Item2);
  SwriteLn('');
  SWrite('Player Soldiers: ');NSP(Player.Item3);
  SWriteLn('');
  SWrite('Player Cannons: ');NSP(Player.Item4);
  SWriteLn('');
  Swrite('Is he king <Y or N>: '+Player.Item5);
  Pause1;
 End;

FUNCTION YORN : CHAR;
  Var Choice:Char;
Begin
  Repeat
   Choice:=UPCASE(GetChar)
  UNTIL Choice IN ['Y','N'];
  YORN:=Choice
End;

Procedure WriteToAPlayerRecord (VAR Player: PlayerRecord);{Example of Record Locking}
VAR A1:String[1];
 Begin
  SClrScr;
  SWriteLn('');
  SWriteLn('');
  Good:=False;
  Repeat
   Repeat
    SWriteLn('');
    SWriteLn('');
    SClrScr;
    SwriteLn('NOTE: Data you type is case sensitive!');
    Swriteln('');
    SWrite('Who would you like to change <try Hamlet first!>: ');
    Palias:=GetInput('',0,15);
   UNTIL PAlias <> '';
   GetPlayerName(Palias,Player,Good); {Procedure to search database file}
   If Good=False then
    Begin
     SwriteLn('No such player by that name - try again,');
    End;
  Until Good=True;
  SClrScr;
  SWriteLn('');
  Swrite('Player Name: '+Player.Item1);
  Repeat
   SWriteLn('');
   SWrite('New name for player <Max of 15 characters>: ');
   Player.Item1:=GetInput('',0,15);
  UNTIL PAlias <> '';
  SWriteLn('');
  Swrite('Player Money: $');NSP(Player.Item2);
  Repeat
   SWriteLn('');
   SWrite('New amount of money <Max of $5000>: ');
   QTY:=GetInput('',0,15);
   VAL (Qty,Vmoney,code);
  UNTIL (Vmoney > 1) OR (Code <> 0);
  Player.Item2:=Vmoney;
  SwriteLn('');
  SWrite('Player Soldiers: ');NSP(Player.Item3);
  SWriteLn('');
  Repeat
   SWriteLn('');
   SWrite('New amount of soldiers <Max of 1000>: ');
   QTY:=GetInput('',0,15);
   VAL (Qty,Vmoney,code);
  UNTIL (Vmoney > 1) OR (Code <> 0);
  Player.Item3:=Vmoney;
  SWrite('Player Cannons: ');NSP(Player.Item4);
  SWriteLn('');
  Repeat
   SWriteLn('');
   SWrite('New amount of cannons <Max of 100>: ');
   QTY:=GetInput('',0,15);
   VAL (Qty,Vmoney,code);
  UNTIL (Vmoney > 1) OR (Code <> 0);
  Player.Item4:=Vmoney;
  Swrite('Is he king <Y or N>: '+Player.Item5);
  SWriteLn('');
  Repeat
   SWriteLn('');
   SWrite('Is this player the King? <Y or N>: ');
   A1:=YORN;
  UNTIL (A1='Y') or (A1='N');
  Player.Item5:=A1;
  SwriteLn('');
  SwriteLn('Saving the players changed record.');
  SwriteLn('');
  Assign(PlayerFile,'PLAYER.DAT');
  OpenAttempts:=1;
  Repeat
   {$I-}
   Reset(PlayerFile); {Must do before reading/writing records}
   {$I+}
   GoAhead:= (IOResult = 0); {Traps I/O errors so program does not abort}
   If Not GoAhead then OpenAttempts :=OpenAttempts+1;{increments counter}
  Until (GoAhead) or (OpenAttempts>1000); {Loop waits until file is opened}
  CurRecord := Player.PRecordNumber;  {Very important line!!!}
  NetSeek( PlayerFile, CurRecord );   {Moves pointer to that data record}
  NetLock( PlayerFile, CurRecord, 1 );{Locks that record}
  NetWrite( PlayerFile, Player);      {Writes to that record}
  NetUnlock( PlayerFile, CurRecord, 1 );{Unlocks that record}
  Close(PlayerFile);                  {Flushes the buffer and closes the file}
 End;

Procedure SetupGlob(VAR Glob:GlobRec);
 Begin
  Glob.MaxPlayers:=10;
  Glob.MaxMoney  :=1000;
 End;

Procedure MakeSomeTypeOfChoice;
VAR Qt:Char;
 Begin
  REPEAT
   SClrScr;
   SWriteLn('');
   SWriteLn('');
   SWriteLn('What would you like to do?');
   SWriteLn('');
   SWrite('A - Display the Global File: ');
   SWriteln('');
   SWrite('B - Make Changes to the Global File: ');
   SWriteln('');
   SWrite('C - Display a player record: ');
   SWriteln('');
   SWrite('D - Make changes to a player record: ');
   SWriteln('');
   SWrite('E - Quit this program: ');
   REPEAT
    TC(10);
    CP(3,18);
    SWrite('Enter Selection: ');
    Qt:=UPCASE(GetChar)
   UNTIL QT IN ['A','B','C','D','E'];
   CASE Qt OF
    'A': ReadGlobalFile(Glob);
    'B': WriteGlobalFile(Glob);
    'C': ReadAPlayerRecord(Player);
    'D': WriteToAPlayerRecord (Player);
   End;
  SClrScr;
 UNTIL QT='E';
End;


Procedure GetDate1(VAR Month:Word;
                   VAR day:Word;
                   VAR year:Word);
 VAR MyRegs:Registers;

 Begin
  MyRegs.AH:=$2A;
  MSDOS(MyRegs);
  Month:=MyRegs.DH;
  Day:=MyRegs.DL;
  Year:=MyRegs.CX;
 End;

Procedure SaveExit;
 Begin
 (**** Setup my Global values file ****)
  Assign(Globfile,'GLOB.DAT');
  ReWrite(Globfile);
  Write(GlobFile,Glob); {Makes the Glob Data file of a single record}
  Close(GlobFile);

 (**** Sets up my player information database ****)
   Assign (PlayerFile, 'PLAYER.DAT');
   Rewrite(PlayerFile);
   For Y99 := 1 to 10 DO   {Builds a typed data file of 10 records}
    Begin
     Player.PRecordNumber:=Y99-1; {Record numbers always start with 0}
     Player.Item1:='Hamlet';
     Player.Item2:=4500;
     Player.Item3:=1000;
     Player.Item4:=128;
     Player.Item5:='N';
     Write(PlayerFile,Player); {Writes this record to the file}
    End;
   Close(PlayerFile);
 End;

Begin
  SaveExitProc:=Exitproc;
  ExitProc:=@MyExit1;
  ShareInst;                  {Checks for presence of DOS Share}
  IF ShareInst then FileMode:=66; {Sets filemode if found-our program default}
  GetDate1(Month,Day,Year);   {Lets find out the date}
  INITDOORDRIVER('GAME.CTL'); {Starts the DDPlus portion of the program}
  SetupGlob(glob);            {Makes the Glob Data File}
  SaveExit;                   {Makes the Player database file of records}
  MakeSomeTypeOfChoice;       {Looping menu}
  SClrScr;                    {Clear the screen}
  SwriteLn('All done!!!');    {That's it folks!}
End.

