@ECHO OFF
CLS
ECHO.
ECHO                TEXT COLUMN INTERCHANGE PROGRAM
ECHO                            COLS.BAT
ECHO                 COPYRIGHT (C) 1995 CHUCK BERNT
ECHO                       ALL RIGHTS RESERVED
ECHO.

REM  This batch program determines if the user is using
REM  the short form or long form.  If the user is using the
REM  short form, this program creates the script LAST.INP and
REM  redirects that script into the QBASIC program.  This
REM  script is identical to the key strokes that a user would
REM  use in the long form.  If the user is using the long
REM  form, then the program starts the long form.
REM
REM  This file (as sent originally) has the short form defaults
REM  set to work with what is believed to be its' most likely 
REM  use and is compatible with the original fun files.  If
REM  another set of defaults is desired, then just make the
REM  desired changes in the defaults indicated below; but I
REM  would like to suggest that you make a copy of this file
REM  and change its' name slightly to indicate the new defaults.
REM  Then make the changes to that new file.  Then copy or
REM  move that file to your path directory that contains the
REM  original COLS.BAT.  Then when you need the new defaults,
REM  type the new filename on the command line.  If you run
REM  long files or would like to speed up the processing,
REM  specify a carriage return instead of y to the totals
REM  option (processing speed can nearly double).  A carriage
REM  return may be specified by typing ECHO.>> \COLS\LAST.INP

BREAK ON

IF "%1" == "L" GOTO LAST
IF "%1" == "LAST" GOTO LAST
IF "%1" == "l" GOTO LAST
IF "%1" == "last" GOTO LAST

IF NOT %2%%Z == %%Z IF EXIST %1.TXT GOTO LINE

ECHO.
ECHO                ***  COMMAND LINE SHORT CUT  ***
ECHO.
ECHO   SYNTAX:COLS filename outcol1 [outcol2] [outcol3] ... [outcol8]
ECHO.
ECHO                       SOME EXAMPLES
ECHO.
ECHO              COLS TEST1 1 2 3 TSUM C1+C2+C3
ECHO              COLS TEST1 1 2 3 TAVE (C1+C2+C3)/3
ECHO              COLS TEST1 1 TSQUARE C1^2 tbig-one c1^c1
ECHO              COLS TEST1 1 2^C1
ECHO.
ECHO  Some restrictions apply to the command line short cut that do not
ECHO  apply to the longer method that you are about to follow.  Please
ECHO  see the very short README.TXT.  The longer method will explain each
ECHO  step -- so please continue.
ECHO.


PAUSE

COPY \COLS\COLSTATU.BAS \COLS\TXTTMP.BAS
QBASIC /RUN \COLS\COLI
DEL \COLS\TXTTMP.BAS
GOTO THEEND

:LINE

ECHO.> \COLS\LAST.INP

REM  The next lines starting with an IF insert the output columns.
IF NOT %2%%Z == %%Z ECHO %2 >> \COLS\LAST.INP
IF NOT %3%%Z == %%Z ECHO %3 >> \COLS\LAST.INP
IF NOT %4%%Z == %%Z ECHO %4 >> \COLS\LAST.INP
IF NOT %5%%Z == %%Z ECHO %5 >> \COLS\LAST.INP
IF NOT %6%%Z == %%Z ECHO %6 >> \COLS\LAST.INP
IF NOT %7%%Z == %%Z ECHO %7 >> \COLS\LAST.INP
IF NOT %8%%Z == %%Z ECHO %8 >> \COLS\LAST.INP
IF NOT %9%%Z == %%Z ECHO %9 >> \COLS\LAST.INP

REM The next line ends the output column insertion.
ECHO.>> \COLS\LAST.INP

REM  The next line inserts the filename.
ECHO %1 >> \COLS\LAST.INP

REM  The next line specifies the delimiter (use c for comma).
ECHO.>> \COLS\LAST.INP

REM  The next line specifies the number of input columns or
REM  carriage return for no error checking.
ECHO.>> \COLS\LAST.INP

REM  The next line specifies whether totaling will be done (y or no).
ECHO y >> \COLS\LAST.INP


:LAST
COPY \COLS\COLLINE.BAS \COLS\TXTTMP.BAS
QBASIC /RUN \COLS\COLI < \COLS\LAST.INP
DEL \COLS\TXTTMP.BAS

ECHO ATTEMPTING to start YOUR editor (your file may be too large).

REM  The next line will automatically start the editor called
REM  EDIT on the output file at the end of the short command
REM  line form.  If you favorite editor has another name, please
REM  change it below.

IF NOT %2%%Z == %%Z IF EXIST %1.TXT EDIT %1.LIS

:THEEND
