/* ANNOUNCE.CMD - REXX program to generate a File Announcement
with MaxFile/PM for new files. Also formats file descriptions, sorts
files.bbs', purges dupes (new!) and re-archives to desired packer (new!).
(Still doesn't wash windows, though. Darn! <g>)

Donations for this program may be sent to:

     Elliott Goodman        
     PO Box 500038          
     Palmdale, CA 93591-0038

 Modify as desired.  Version 1.4

Includes snippets from code of Craig Morrison, identified.

  - 12 January, 1995 by Elliott Goodman, 1:102/1319 - 805-264-0200
                           Miles Enterprises BBS
*/

/* gracefully exit if problems */
signal on halt name Halt1
signal on syntax name Halt2
                                                                 
/* check whether RxFuncs are loaded. If not, load them. */       
if RxFuncQuery('SysLoadFuncs') then                              
do                                                               
        call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
        call SysLoadFuncs                                        
end                                                              

/* Just to let the user know what's going on.... */
say 'Searching thru file areas for new files to announce.'
say 'Please wait....';
say ' ';

/* create a tracking file */
report = 'd:\lora\file\mpbeta\1anounce.txt'

/* delete old tracking file, if present */
call SysFileDelete(report)

m_txt = 'Report of ANNOUNCE.CMD activity'
call lineout report, m_txt
m_txt = date('U')
call lineout report, m_txt

/* get and set date index for today */
parse var m_txt month '/' day '/' year        
mm = word('1 2 3 4 5 6 7 8 9 10 11 12', month)
new_date = mm || '/' || day || '/' || year    

m_txt = ''
call lineout report, m_txt

/* set some defaults */

files.0 = 0			/* will increment */
file_index = 0

lmargin = 16         /* how far from the left margin the ED Marker should be */
llength = 45                 /* this is how long each line segment should be */
EDMarker = '>'        /* Set EDMarker to your extended description character */

/* Creates string of spaces with the EDMarker at the end */
spaces = SubStr(Copies(' ', 80), 1, lmargin)||EDMarker||' '

/* set up the array elements of FILES which will be used by
MPM_AnnounceFiles() at the end of all this processing.
See TANN.CMD included with MaxFile/PM for details.
Modify this area for your own use.   */

files.msgpath = 'D:\LORA\MSG\USERS'
files.msgtype = 'SQUISH'
files.msgflag = 'CRASH'
files.to = 'ALL'
files.toaddr = '1:102/1316.0'
files.header = 'New files online at Miles Enterprises BBS'
files.from = 'Elliott Goodman'
files.fromaddr = '1:102/1319.0'
files.footer = '- Elliott'

/* your origin info */
files.origin = 'Miles Enterprises * 805-264-0200 *'

rc = MPM_QueryAreaList('arealist')         

/* cycle thru all areas. If Hide-CD is selected, they won't be searched. */
do impm = 1 to arealist.0

   mpmarea = arealist.impm.area

/* get drive/subdir of next file area */
   area_path = arealist.impm.path

/* notify user of our progress */
   say  mpmarea area_path
   say ' '

/* use SysFileTree here to check for new files */
   call SysFileTree area_path, stuff, 'F'

/* reset before each file area */
   found_new = 0
   nfile.0 = 0

/* assume at least one file in the file area (files.bbs!) */
   do i = 1 to stuff.0		/* cycle thru files in one area */

/* get info on each file in the area */
   parse var stuff.i,
         file_date,
         file_time,
         file_size,
         file_attr,
         file_name

/* test if next file is dated today, hence NEW */
   if file_date = new_date then do

/* remove trailing space */
     file_name = strip( file_name )

/* remove drive/subdir info from filename */
     parse var file_name (area_path) file_name

/* convert to caps, in case it's lower cased */
     file_name = translate( file_name )

/* get extention. We don't want to announce FILES.BBS or FILES.BAK! 
Doing this here before setting the found flag will skip announcing 
them.  We're also going to need the extension to check archive type. */
     parse var file_name junk '.' extn

     if extn = 'BAK' | extn = 'BBS' then do
        iterate
        end

/* set flag if new file found */
        found_new = 1

/* increment number of new files found */
        nfile.0 = nfile.0 + 1

/* update index and save file name */
        t_index = nfile.0
        nfile.t_index = file_name

/* save extension for testing later on */
        nfile.t_index.ext = extn

        end /* if file_test = day_index */
     end /* do i = 1 to stuff.0 */

/* now, if we found one or more new files in this area... */
   if found_new = 1 then do

/* we have to open the files.bbs file so we can get the
description */
      rc = MPM_OpenArea(mpmarea)

/* This gives the system time to open the file. Necessary, at least
on my system. */
Call SysSleep 1

/* ....cycle thru the new files for this area */
      do k = 1 to nfile.0

/* rearchive if not ZIP - New Function! ***********/
          if nfile.k.ext = 'ARJ' |,
             nfile.k.ext = 'LZH' |,
             nfile.k.ext = 'ARC' |,
             nfile.k.ext = 'ZOO' then do
                rc = MPM_SelectFile(mpmarea, nfile.k)
                rc = MPM_ReArchive(mpmarea, ZIP)

/* display for Sysop */
                say 'old name: ' nfile.k

/* if successful changing to ZIP, change name in array so
announcement will be for correct filename */
                if rc = 'OK' then do
                   parse var nfile.k first '.' old_extn
                   nfile.k = first||'.'||'ZIP'

/* display in case Sysop is looking.... */
                   say 'new name: ' nfile.k
                end /* if rc = ok */

/* not successful re-archiving. Note in tracking file. */
                else do
                   m_txt = 'Error re-archiving 'nfile.k
                   call lineout report, m_txt
                end /* else if */
             end /* if nfile.k.ext = */

/* continue storing elements in Files array */
         files.0 = files.0 + 1
         file_index = file_index + 1
         files.file_index.path = area_path
         files.file_index.file = nfile.k

/* get file description so we can format it */
         text = MPM_QueryFileInfo(mpmarea, nfile.k, '3')

/* just in case no description was Tic'd... */
         if text = 'ERROR' then do
            text = '*****   No Description!'
            end

/* here's where we format the file description! This routine was
written by Craig Morrison (with slight changes on my part). */

/* Translate all CRs, LFs and Extended Description Markers into spaces */
         ntext = Translate(text, '   ', x2c('0d')||x2c('0a')||EDMarker)                 

/* do first part of description */
         text = GetOneLine(llength, ntext)
         ntext = Space(DelWord(ntext, 1, Words(text)), 1)     

/* do the rest of the description */
         Do While Length(ntext) \= 0                          

/* Add some extra length to remaining lines since there is no
filename on those lines */
            wText = GetOneLine((llength + 10), ntext)

            text = text||x2c('0a')||spaces||wtext

/* I'm getting extra carriage returns in my listing even though it displays
okay in Lora. So I used the above line. If you are missing one, use the
below line and comment out the above one. */
/*         text = text||x2c('0d')||x2c('0a')||spaces||wText */

            ntext = Space(DelWord(ntext, 1, Words(wText)), 1)
            End

/* the following two lines replace the extra space between
parentesis that was removed: (  0) */
         text = overlay(' ',text,1,1)
         text = '('||text            

/* write formatted file description into files.bbs */
         rc = MPM_SetFileInfo(mpmarea, nfile.k, '2', text)

/* save formatted description for announcement after first
cleaning it up a little */
         text = Space(Translate(text, ' ', '>'), 1)
         files.file_index.desc = text

         end /* do k to nfile.0 */

/* New Sort Function! */
   rc = MPM_FileAreaSort(mpmarea, 'Name', 'Asc', 'All') 

/* New Purge Dupes function! ***************/
   rc = MPM_PurgeDupes(mpmarea)

/* write updated files.bbs to disk before closing window */
   rc = MPM_SaveFilesBBS(mpmarea)                       

/* close the files.bbs file to avoid problems */
      rc = MPM_CloseArea(mpmarea)

/* give system time to write files.bbs */
      Call SysSleep 1
      end /* if  found = 1 */

   end /* do impm (cycling thru file areas) */

/* if no new files: exit */
if files.0 = 0 then do
   m_txt = 'No new files found'
   call lineout report, m_txt
   call lineout report
   call SysSleep 2
   exit
   end

/* there are new files. Save the info so we can use the
list for a new files announcement, locally */

m_txt = 'List of New Files'
call lineout report, m_txt
m_txt = ' '
call lineout report, m_txt

do j = 1 to files.0
   m_txt = '**    File Name = ' files.j.file
   call lineout report, m_txt
   m_txt = 'File Path = ' files.j.path
   call lineout report, m_txt
   m_txt = 'File Description = ' files.j.desc
   call lineout report, m_txt
   m_txt = ' '
   call lineout report, m_txt
   end  

/* actually make the announcement */
rc = MPM_AnnounceFiles('files')

if files.0 = 1 then
   m_txt = 'One new file found!'
   else
   m_txt = files.0 'new files found!'
call lineout report, m_txt

/* close the report file */
call lineout report

/* this pause seems to be needed, at least on my system */
call SysSleep 2

/* and we're done */
exit

/*   This subroutine and all format description routines written by
      Craig Morrison, author of MaxFilePM. Description is his:

    GetOneLine takes a variable length string and returns a blank delimited   
    string that is a substring of inText and is no longer than llen           
    characters.                                                               
                                                                              
    A single word that is longer than llen is simply truncated at llen when it
    would be the only word in a line segment and not wrappable. Its cheesy and
    cheap, but hey, it works.. ;-)                                            
*/                                                                            

GetOneLine:                                        
                                                   
    Parse Arg llen, inText                         
                                                   
    cText = ''                                     
    Do While Length(cText' 'Word(inText, 1)) < llen
        cText = cText' 'Word(inText, 1)            
        inText = DelWord(inText, 1, 1)             
        If inText = '' Then Leave                  
    End                                            
                                                   
    if cText = '' Then Do                          
        cText = Left(inText, llen)                 
    End                                            
                                                   
Return Space(cText, 1)                             

Halt1:

m_txt = 'Signal called for Halt condition'
call lineout report, m_txt
call lineout report
call SysSleep 2
exit

Halt2:

m_txt = 'Signal called for Syntax condition'
call lineout report, m_txt
call lineout report
call SysSleep 2
exit

