PROGRAM Sort_or_Analyze_Conference_Participation_Tracker_Database;
{$M 5120,0,655360}
{$N-,E- overhead of math support not worth slight increase in speed}
{$X- function calls may not be discarded}
{$I-} {disable I/O checking - trap errors by checking IOResult}
USES DOS, NUMDAYS, CPT_CODE;

{$IFDEF sort}
  CONST progname='CPT-Sort';
{$ENDIF}
{$IFDEF stat}
  CONST progname='CPT-Stat';
{$ENDIF}

VAR SavedExitProc: POINTER;

{===========================================================================}

PROCEDURE CustomExit; FAR;
  {---- Always exit through here ----}
CONST

{$IFDEF sort}
  progdesc = progname+' - Free DOS utility: Sort CPT Database.';
{$ENDIF}
{$IFDEF stat}
  progdesc = progname+' - Free DOS utility: Produce statistics from CPT Database.';
{$ENDIF}

  usage    = 'Usage: '+progname+' <CPT file> <sort order(s) [see below]>';
  name_a   = '    name     = sort by first name, ascending (A to Z)';
  name_d   = '   -name     = sort by first name, descending (Z to A)';
  sent_a   = '    sent     = sort by messages sent, ascending (fewest messages at top)';
  sent_d   = '   -sent     = sort by messages sent, descending (most messages at top)';
  oldest_a = '    oldest   = sort by oldest message, ascending (new people at end)';
  oldest_d = '   -oldest   = sort by oldest message, descending (new people at top)';
  newest_a = '    newest   = sort by newest message, ascending (current posters at end)';
  newest_d = '   -newest   = sort by newest message, descending (current posters at top)';
  example1 = 'Example:  '+progname+' cnf_123.dat -sent';
  example2 = 'Example:  '+progname+' 45.mem -sent name';

BEGIN
  ExitProc := SavedExitProc;
  cursorOn;
  IF (ExitCode > 0) THEN BEGIN
    WriteLn (progdesc);
    WriteLn (author);    WriteLn;
    WriteLn (usage);     WriteLn;
    WriteLn (name_a);    WriteLn (name_d);
    WriteLn (sent_a);    WriteLn (sent_d);
    WriteLn (oldest_a);  WriteLn (oldest_d);
    WriteLn (newest_a);  WriteLn (newest_d);  WriteLn;
    WriteLn (example1);
    WriteLn (example2);  WriteLn;
  END;
  IF ErrorAddr <> NIL THEN
  BEGIN
    WriteLn ('An unanticipated error occurred, please contact DDA with the following data:');
    WriteLn ('Address = ', Seg (ErrorAddr^), ':', Ofs (ErrorAddr^));
    WriteLn ('Code    = ', ExitCode);
    ErrorAddr := NIL;
  END
  ELSE
    IF (ExitCode > 0) AND (ExitCode < 255) THEN
      WriteError (ExitCode);
END;
{===========================================================================}

VAR MemberInfo  : MemLink;
  Members     : WORD;
  MemFileName : PATHSTR;
  PCount      : BYTE;
  DotPos      : BYTE;

BEGIN
  SavedExitProc := ExitProc;
  ExitProc := @CustomExit;

  IF ParamCount < 2 THEN Halt (255);
  
  MemFileName := GetConfNUMBER (ParamStr (1));
  IF NOT fileexists (MemFileName) THEN Halt (1);

{$IFDEF sort}
  WriteLn (progname,' resorting ', MemFileName);
{$ENDIF}
{$IFDEF stat}
  WriteLn (progname,' analyzing ', MemFileName);
{$ENDIF}

  Members := BuildList (MemberInfo, MemFileName); WriteLn;

  IF MemberInfo <> NIL THEN BEGIN
    FOR PCount := ParamCount DOWNTO 2 DO BEGIN
      GetSortField (ParamStr (Pcount));
      SortLinkedList (MemberInfo); WriteLn;
    END;

{$IFDEF sort}
    WriteList (MemberInfo, MemFileName, Members); WriteLn;
{$ENDIF}
{$IFDEF stat}
    DotPos := Pos ('.', MemFileName);
    IF DotPos > 0 THEN
      Delete (MemFileName, DotPos, 1 + Length (MemFileName) - DotPos);
    WriteStats (MemberInfo, MemFileName+ '.STT', Members); WriteLn;
    WriteLn ('Statistics are in: ', MemFileName+ '.STT');
{$ENDIF}

  END;
  WriteLn ('Mission accomplished!');
END.
