{$I-}   {File error checking must be off.}

{    Program to monitor the log file from QL2FAX and set the error level
     appropriately.  -  Peter Summers  24 Apr 94 }

program logmon;

uses crt;

const
  logfilename : string = 'c:\ql2fax\faxsend.log';
  index    : byte = 1;
  tabcount : byte = 0;

var
  logfile : text;
  line    : string;

  begin
    if paramcount>0 then
      if paramstr(1)='/?' then
        begin
          writeln('LOGMON: waits for a QL2FAX log file to appear and then sets');
          writeln('        the DOS errorlevel according to the result - 6 Feb 1995.');
          writeln('  by Peter Summers <peter@cardiology.medrmh.unimelb.edu.au>');
          writeln;
          writeln('SYNTAX: LOGMON [<logfilename>]');
          halt(1);
        end
      else
        logfilename:=paramstr(1);

    assign(logfile,logfilename);

    repeat
      writeln('Trying to open '+logfilename+', Press Esc key to quit.');
      if keypressed and (readkey=chr(27)) then halt(1);
      reset(logfile);
      delay(10000);
    until IOResult=0;

    readln(logfile,line);
    if (IOResult<>0) then
      begin
        writeln('Can''t read from '+logfilename+'.');
        halt(2);
      end;

    repeat
      if line[index]=chr(9) then tabcount := tabcount + 1;
      index := index + 1;
    until (tabcount=8) or (index>length(line));

    if line[index]='E' then
      begin
        writeln('Fax log indicates error in sending fax.');
        halt(3);
      end;

    writeln('Fax log indicates fax sent correctly.');
    halt(0);
  end.