
Comment
==========================================================

This section allows for a screen crawl on the bottom line of the screen.
It reads a file and displays it over and over.

If TODAY.TXT doesn't exist then no crawl will be displayed.

Blank lines in the TODAY.TXT file cause * * * to appear.

==========================================================
EndComment


;----- Background Tasking

var
  CrawlFile = 'TODAY.TXT'     ;name of the file you want to display
  CrawlDelay = 30             ;seconds to wait to start
  CrawlSpeed = 2              ;bigger number crawls slower
  ThisLine
  NextLine
  LinePtr
  OldTimer
  RereadFileCounter
  Crawl


;----- Setup

OldTimer = Timer

if IdleProgram = nil
   IdleProgram = Loc CrawlTask
endif


;----- Procedures

Procedure FillLine
   while length(ThisLine) < (ScreenWidth - 2)
      if NextLine = ''
         NextLine = Crawl[LinePtr]
         LinePtr = LinePtr + 1
         if NextLine = ''
            NextLine = '* * * '
         else
            NextLine = NextLine + ' '
         endif
      endif
      ThisLine = ThisLine + Left(NextLine,1)
      delete(NextLine,1,1)
   endwhile
EndProc


Procedure ReadCrawlFile

   ;----- Read the text file.

   CrawlFile = ExistOnPath(CrawlFile)
   if CrawlFile = ''
      IdleProgram = Nil
      Return
   endif
   ReadTextFile (CrawlFile,Crawl)
   if NumberOfElements(Crawl) > 0
      if Crawl[NumberOfElements(Crawl)] > ''
         AppendArray(Crawl,'')
      endif
      AppendArray(Crawl,'###')
      AppendArray(Crawl,'')
   else
      Return
   endif

EndProc


Procedure CrawlTask
var X

   ;- Delay for CrawlDelay Seconds

   while not KbdReady and (Timer - OldTimer < (CrawlDelay * 18))
   EndWhile

   OldTimer = Timer
   if KbdReady then Return

   ThisLine = ' * * * * * * * * * * '
   LinePtr = 1
   NextLine = ''

   ;----- Read the text file.

   if NumberOfElements(Crawl) = 0
      ReadCrawlFile
   endif

   if NumberOfElements(Crawl) > 0
      SetTopWindow StatusWindow      ;select bottom line of screen
      while not KbdReady
         if LinePtr > NumberOfElements(Crawl)
            LinePtr = 1

            ;- RereadFileCounter allows you to change message files and
            ;- have the new file appear on the users screen

            RereadFileCounter = RereadFileCounter + 1
            if RereadFileCounter >= 5
               RereadFileCounter = 0
               ReadCrawlFile
            endif

         endif
         FillLine
         X = Timer
         if (X mod CrawlSpeed = 0) and (X <> OldTimer)
            GotoXY 2 1
            Write ThisLine
            delete(ThisLine,1,1)
            OldTimer = X
         endif
      endwhile

      ClearScreen
      WriteCenter StatusLineText
      SetWindowUnder (StatusWindow,StatusWindow + 1) ;restore top window
   endif
   OldTimer = Timer
EndProc


