/* ---------------------------------------------------- */
/* (c) 1995 Niksoft International                       */
/* SPRITE CUTTER UTILITY v2.0                           */
/* ---------------------------------------------------- */
/* PICVIEW.H                                            */
/* Image file management module                         */
/* ---------------------------------------------------- */

#ifndef __RGBCOLOR

#define __RGBCOLOR

typedef struct {

                char red;
                char green;
                char blue;

               } RGB_color;

#endif


#ifndef __PICTURE

#define __PICTURE

typedef struct {

                RGB_color palette[256];
                char far *buffer;

               } picture;

#endif

#define PALETTE_MASK       0x3C6
#define PALETTE_REG_READ   0x3C7
#define PALETTE_REG_WRITE  0x3C8
#define PALETTE_DATA       0x3C9

#define NO_SET             0
#define SET                1

extern int init_PIC(picture *);
/* Initializes the structure that holds the image datas.              */
/* Returns -1 if there's not enough memory to hold that image bitmap. */

extern int PCX_load(char *, picture *);
/* Loads into the structure a .PCX format image file */
/* Returns -1 if an error occurs.                    */


extern void Show_picture(picture *, unsigned);
/* Puts the image stored in the structure.      */
/* It sets the palette if requested.            */

extern void PIC_free(picture *);
/* Frees the image structure buffer. */
