/* pp.h    header file for pforge.c program    jpb 5/27/95 */

#include <stdio.h>

#define PGM  0
#define TGA  1
#define PNG  2
#define PG8  3
#define DOS  yuck                     /* compiling on DOS system */

FILE *fpout;                          /* pointer to image output file */

typedef struct image_data_struct {
  double *dim;
  double *dscale;
  int d_factors;
  double powscale;
  double xfrac, yfrac;
  unsigned int rseed;
  int meshsize;
  int peakspec;
  int adimspec;
} image_data;

static unsigned int max_pixval = 65535; /* sixteen bit pixel values */

int pp_filetype;                      /* file format type: PGM, TGA etc */
int pm_keymatch(char* str, char* key, int minchar);  /* keyword matcher */
void pperror( char* str);               /* print an error string and exit */
void write_info(FILE *f, image_data img);     /* write data header */
void pp_writepixel(unsigned int p);            /* write pixel to output file */
void pp_openfile(char *fname, image_data img);   /* open output file */
int pp_closefile();                            /* close output file */
void fpc(unsigned char c);                     /* print byte to file */

char *output_filename;                /* output filename string */
char *string;                         /* temp string */


