/* libpbm1.c - pbm utility library part 1  (grossly hacked jpb 1995)
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <ctype.h>
#include <stdlib.h>
#include <stdarg.h>
#include "pp.h"

#undef tolower          /* annoying detail required for ANSI compat. */

/* Case-insensitive keyword matcher. */

int
pm_keymatch( char *str, char *keyword, int minchars )
{
    register int len;
    char c1, c2;

    len = strlen( str );
    if ( len < minchars )
	return 0;
    while ( --len >= 0 )
	{

	c1 = *str++;
	c2 = *keyword++;
	if ( c2 == '\0' )
	    return 0;
	if isupper( c1 )
	    c1 = tolower( c1 );
	if isupper( c2 )
	    c2 = tolower( c2 );
	if ( c1 != c2 )
	    return 0;
	}
    return 1;
    }

void pperror( char* str )
{
  printf("%s",str);
  exit(1);
}

void write_info(FILE *fpout, image_data img)
{
 int i;
    /* print out parameters so we know how we generated this file */

  fprintf(fpout,"# created by gforge: -dimension %.2f -power %.2f -mesh %d \n",
    	    img.dim[0], img.powscale, img.meshsize);
    if (img.peakspec) 
       fprintf(fpout,"# -peak %0.2f %0.2f \n",img.xfrac,img.yfrac);
    fprintf(fpout,"# -seed %d \n",img.rseed);
    
    if (img.adimspec) {
      for (i=1;i<img.d_factors;i++) {
       fprintf(fpout,"# -ad %0.2f %0.2f \n",img.dim[i],img.dscale[i]);
       }
      }
}

/* --------------------------------------- */

void pp_openfile(char* fname, image_data img)
{
 int temp;
  unsigned char xo, yo;
    unsigned char IDLength;             /* length of Identifier String */
    unsigned char CoMapType;            /* 0 = no map */
    unsigned char ImgType;              /* image type (see below for values) */
    unsigned char Index_lo, Index_hi;   /* index of first color map entry */
    unsigned char Length_lo, Length_hi; /* number of entries in color map */
    unsigned char CoSize;               /* size colormap entry (15,16,24,32) */
    unsigned char X_org_lo, X_org_hi;   /* x origin of image */
    unsigned char Y_org_lo, Y_org_hi;   /* y origin of image */
    unsigned char Width_lo, Width_hi;   /* width of image */
    unsigned char Height_lo, Height_hi; /* height of image */
    unsigned char PixelSize;            /* pixel size (8,16,24,32) */
    int xsize, ysize;

    xsize = img.meshsize;
    ysize = img.meshsize;

    xo = 0; yo = 0;
 
#ifdef DOS
  if ((fpout = fopen(fname,"wb")) == NULL )     /* don't add CR/LF to file */
       pperror("Couldn't open output file\n");
#else
  if ((fpout = fopen(fname,"w")) == NULL )
	pperror("Couldn't open output file\n");
#endif

  if (pp_filetype == TGA)
   {
     /* b0-b7 */
    IDLength = 0; CoMapType = 0; ImgType = 2; Index_lo = 0; Index_hi=0;
    Length_lo = 0; Length_hi = 0; CoSize = 0; X_org_lo = 0; X_org_hi = 0;
    temp = xsize / 256;
    Width_hi = (unsigned char) temp;     /* low and high bytes of x width */
    Width_lo = xsize % 256;
    temp = ysize / 256;
    Height_hi = (unsigned char) temp;
    Height_lo = ysize % 256;
    PixelSize = 24;
    Y_org_lo = 0;
    Y_org_hi = 0;

    fpc(IDLength);
    fpc(CoMapType);
    fpc(ImgType);
    fpc(Index_lo);
    fpc( Index_hi);
    fpc(Length_lo);
    fpc(Length_hi);
    fpc(CoSize);
    fpc(X_org_lo); fpc(X_org_hi);
    fpc(Y_org_lo); fpc(Y_org_hi);
    fpc(Width_lo);
    fpc(Width_hi);              /* file in lo-byte, hi-byte order b12,b13*/
    fpc(Height_lo);
    fpc(Height_hi);    /* ysize b14, b15 */
    fpc(PixelSize);
    fpc((unsigned char) 0x20);        /* descriptor byte b17 */

   }
  else if (pp_filetype == PGM)
    {
      fprintf(fpout,"P2\n");       /* PGM type 2: 16-bit ASCII data */
      write_info(fpout, img);
      fprintf(fpout,"%d %d\n",xsize,ysize);
      fprintf(fpout,"%u\n",max_pixval);
    }
  else if (pp_filetype == PG8)
    {
      fprintf(fpout,"P5\n");       /* PGM type 2: 8-bit binary data */
      write_info(fpout, img);

      fprintf(fpout,"%d %d\n",xsize,ysize);
      fprintf(fpout,"255\n");
    }
   else if (pp_filetype == PNG)
    {
      printf("oops, png???\n");
    }
}


void fpc(unsigned char c)       /* output a single byte to file */
  {
    fprintf(fpout,"%c",c);
  }

void pp_writepixel(unsigned int p)
{
 unsigned char r,g,b;
 r = 0; g =0; b = 0;
  if (pp_filetype == PGM)
    fprintf(fpout,"%u ",p);
  else if(pp_filetype == PG8)
    fprintf(fpout,"%c",(unsigned char)(p>>8));
  else if(pp_filetype == TGA)    /* TGA pixel order is BGR. R=hi, G=lo */
    {
      r = p >> 8;
      g = p % 256;
  /*    printf("p=%d: %d %d %d\n",p,(int)r,(int)g,(int)b); */
      fprintf(fpout,"%c%c%c",b,g,r);
    }
  else if(pp_filetype == PNG)
    { }
}


int pp_closefile()
{
  if(pp_filetype == PNG)
    {
      fprintf(fpout,"END-PNG\n");
    }
  return(fclose(fpout));               /* close the file */
}
