/*
	Totally hacked code, entirely lifted from "ppmforge.c" (a "fractal
	forgery generator") for the PBMPLUS toolkit. All the elegant code
	is from the PPM source. All errors are from me. The comments below
	are from the original code.
	(John Beale <beale@jumpjibe.stanford.edu> 1995)
	-------------------------------------------------------------

	Originally  designed  and  implemented  in December of 1989 by
	John Walker as a stand-alone program for the  Sun  and  MS-DOS
	under  Turbo C.  Adapted in September of 1991 for use with Jef
	Poskanzer's raster toolkit.

	References cited in the comments are:

	    Foley, J. D., and Van Dam, A., Fundamentals of Interactive
		Computer  Graphics,  Reading,  Massachusetts:  Addison
		Wesley, 1984.

	    Peitgen, H.-O., and Saupe, D. eds., The Science Of Fractal
		Images, New York: Springer Verlag, 1988.

	    Press, W. H., Flannery, B. P., Teukolsky, S. A., Vetterling,
		W. T., Numerical Recipes In C, New Rochelle: Cambridge
		University Press, 1988.

    Author:
	    John Walker
	    kelvin@fourmilab.ch
	    <http://www.fourmilab.ch/>
	    (current as of May 26 1995)

    Permission  to  use, copy, modify, and distribute this software and
    its documentation  for  any  purpose  and  without  fee  is  hereby
    granted,  without any conditions or restrictions.  This software is
    provided "as is" without express or implied warranty.

*/


#include <stdlib.h>
#include <stdio.h>  
#include <time.h>
#include <math.h>
#include "pp.h"

#define VERSION "gforge v0.1c 28May95 - John Beale beale@jump.stanford.edu\n"

#undef max
#define max(a,b) ((a) > (b) ? (a) : (b))
#undef min
#define min(a,b) ((a) < (b) ? (a) : (b))
#undef abs
#define abs(a) ((a) >= 0 ? (a) : -(a))
#undef odd
#define odd(n) ((n) & 1)

#ifndef M_PI
#define M_PI    3.14159265358979323846
#endif
#ifndef M_E
#define M_E     2.7182818284590452354
#endif

/* Definitions used to address real and imaginary parts in a two-dimensional
   array of complex numbers as stored by fourn(). */

#define Real(v, x, y)  v[1 + (((x) * meshsize) + (y)) * 2]
#define Imag(v, x, y)  v[2 + (((x) * meshsize) + (y)) * 2]

/* Definition for obtaining random numbers. */

#define nrand 4                       /* Gauss() sample count */
#define Cast(low, high) ((low)+(((high)-(low)) * ((rand() & 0x7FFF) / arand)))

/* Utility definition to get an  array's  element  count  (at  compile
   time).   For  example:  

       int  arr[] = {1,2,3,4,5};
       ... 
       printf("%d", ELEMENTS(arr));

   would print a five.  ELEMENTS("abc") can also be used to  tell  how
   many  bytes are in a string constant INCLUDING THE TRAILING NULL. */
   
#define ELEMENTS(array) (sizeof(array)/sizeof((array)[0]))

/*  Data types  */

typedef int Boolean;
#define FALSE 0
#define TRUE 1
#define V     (void)

/*  Local variables  */

static double arand, gaussadd, gaussfac; /* Gaussian random parameters */
static double fracdim;                /* Fractal dimension */
static double powscale;               /* Power law scaling exponent */
static int meshsize;                  /* FFT mesh size */
static int screenxsize, screenysize;  /* output image size in pixels */
static int xstart, ystart;            /* offset in data array for image */
static float xfrac, yfrac;            /* peak location in image */
static double dim[10], dscale[10];    /* 1/f powers and relative scales */
static int d_factors;                 /* number of 1/f powers defined */
static unsigned int rseed = 3;        /* Current random seed */
static image_data img;                /* struct for info to file open */
static Boolean seedspec = FALSE;      /* Did the user specify a seed ? */
static Boolean peakspec = FALSE;      /* Specified fixed peak location ? */

/*      FOURN  --  Multi-dimensional fast Fourier transform

	Called with arguments:

	   data       A  one-dimensional  array  of  floats  (NOTE!!!   NOT
		      DOUBLES!!), indexed from one (NOTE!!!   NOT  ZERO!!),
		      containing  pairs of numbers representing the complex
		      valued samples.  The Fourier transformed results  are
		      returned in the same array.

	   nn         An  array specifying the edge size in each dimension.
		      THIS ARRAY IS INDEXED FROM  ONE,  AND  ALL  THE  EDGE
		      SIZES MUST BE POWERS OF TWO!!!

	   ndim       Number of dimensions of FFT to perform.  Set to 2 for
		      two dimensional FFT.

	   isign      If 1, a Fourier transform is done; if -1 the  inverse
		      transformation is performed.

	This  function  is essentially as given in Press et al., "Numerical
	Recipes In C", Section 12.11, pp.  467-470.
*/

static void fourn(float *data, int *nn, int ndim, int isign)
{
    register int i1, i2, i3;
    int i2rev, i3rev, ip1, ip2, ip3, ifp1, ifp2;
    int ibit, idim, k1, k2, n, nprev, nrem, ntot;
    float tempi, tempr;
    double theta, wi, wpi, wpr, wr, wtemp;

#define SWAP(a,b) tempr=(a); (a) = (b); (b) = tempr

    ntot = 1;
    for (idim = 1; idim <= ndim; idim++)
	ntot *= nn[idim];
    nprev = 1;
    for (idim = ndim; idim >= 1; idim--) {
	n = nn[idim];
	nrem = ntot / (n * nprev);
	ip1 = nprev << 1;
	ip2 = ip1 * n;
	ip3 = ip2 * nrem;
	i2rev = 1;
	for (i2 = 1; i2 <= ip2; i2 += ip1) {
	    if (i2 < i2rev) {
		for (i1 = i2; i1 <= i2 + ip1 - 2; i1 += 2) {
		    for (i3 = i1; i3 <= ip3; i3 += ip2) {
			i3rev = i2rev + i3 - i2;
			SWAP(data[i3], data[i3rev]);
			SWAP(data[i3 + 1], data[i3rev + 1]);
		    }
		}
	    }
	    ibit = ip2 >> 1;
	    while (ibit >= ip1 && i2rev > ibit) {
		i2rev -= ibit;
		ibit >>= 1;
	    }
	    i2rev += ibit;
	}
	ifp1 = ip1;
	while (ifp1 < ip2) {
	    ifp2 = ifp1 << 1;
	    theta = isign * (M_PI * 2) / (ifp2 / ip1);
	    wtemp = sin(0.5 * theta);
	    wpr = -2.0 * wtemp * wtemp;
	    wpi = sin(theta);
	    wr = 1.0;
	    wi = 0.0;
	    for (i3 = 1; i3 <= ifp1; i3 += ip1) {
		for (i1 = i3; i1 <= i3 + ip1 - 2; i1 += 2) {
		    for (i2 = i1; i2 <= ip3; i2 += ifp2) {
			k1 = i2;
			k2 = k1 + ifp1;
			tempr = wr * data[k2] - wi * data[k2 + 1];
			tempi = wr * data[k2 + 1] + wi * data[k2];
			data[k2] = data[k1] - tempr;
			data[k2 + 1] = data[k1 + 1] - tempi;
			data[k1] += tempr;
			data[k1 + 1] += tempi;
		    }
		}
		wr = (wtemp = wr) * wpr - wi * wpi + wr;
		wi = wi * wpr + wtemp * wpi + wi;
	    }
	    ifp1 = ifp2;
	}
	nprev *= n;
    }
}
#undef SWAP

/*  INITGAUSS  --  Initialise random number generators.  As given in
		   Peitgen & Saupe, page 77. */

static void initgauss(unsigned int seed)
{
    /* Range of random generator */
    arand = pow(2.0, 15.0) - 1.0;
    gaussadd = sqrt(3.0 * nrand);
    gaussfac = 2 * gaussadd / (nrand * arand);
    srand(seed);
}

/*  GAUSS  --  Return a Gaussian random number.  As given in Peitgen
	       & Saupe, page 77. */

static double gauss()
{
    int i;
    double sum = 0.0;

    for (i = 1; i <= nrand; i++) {
	sum += (rand() & 0x7FFF);
    }
    return gaussfac * sum - gaussadd;
}

	/* fill array with 1/f gaussian noise */
static void fillarray(float *a, int n, double h, double scale)
{
 int i, j, i0, j0;
 double rad, phase, rcos, rsin;

 /*   printf("h = %f scale = %f\n",h, scale);  */

    printf("filling random array ...");
    for (i = 0; i <= n / 2; i++) {
	for (j = 0; j <= n / 2; j++) {
	    phase = 2 * M_PI * ((rand() & 0x7FFF) / arand);
	    if (i != 0 || j != 0) {
		rad = pow((double) (i * i + j * j), -(h + 1) / 2) * gauss();
	    } else {
		rad = 0;
	    }
	    rcos = rad * cos(phase)*scale;
	    rsin = rad * sin(phase)*scale;
	    Real(a, i, j) += rcos;
	    Imag(a, i, j) += rsin;
	    i0 = (i == 0) ? 0 : n - i;
	    j0 = (j == 0) ? 0 : n - j;
	    Real(a, i0, j0) += rcos*scale;
	    Imag(a, i0, j0) += - rsin*scale;
	}
    }
    printf("\n");
    Imag(a, n / 2, 0) = 0;
    Imag(a, 0, n / 2) = 0;
    Imag(a, n / 2, n / 2) = 0;
    for (i = 1; i <= n / 2 - 1; i++) {
	for (j = 1; j <= n / 2 - 1; j++) {
	    phase = 2 * M_PI * ((rand() & 0x7FFF) / arand);
	    rad = pow((double) (i * i + j * j), -(h + 1) / 2) * gauss();
	    rcos = rad * cos(phase);
	    rsin = rad * sin(phase);
	    Real(a, i, n - j) += rcos*scale;
	    Imag(a, i, n - j) += rsin*scale;
	    Real(a, n - i, j) += rcos*scale;
	    Imag(a, n - i, j) += - rsin*scale;
	}
    }

}

/*  SPECTRALSYNTH  --  Spectrally  synthesised  fractal  motion in two
		       dimensions.  This algorithm is given under  the
		       name   SpectralSynthesisFM2D  on  page  108  of
		       Peitgen & Saupe. */

static void spectralsynth(float **x, unsigned int n)
{
    int i,j,nsize[3];
    unsigned long bl;
    float *a;

    bl = ((((unsigned long) n) * n) + 1) * 2 * sizeof(float);
    a = (float *) malloc( (n+2)*(n+2)*2 * sizeof(float));
    if (a == (float *) 0) {
	printf("Cannot allocate %d x %d result array (%lu bytes).\n",
	   n, n, bl);
	}
    else
       printf("Success allocating %d x %d result array (%lu bytes).\n",
	   n, n, bl);
    *x = a;

    for (j=0;j<n;j++)   {       /* initialize array to zeros */
      for (i=0;i<n;i++)   {
	Real(a,i,j) = 0;
	Imag(a,i,j) = 0;
      }
    }
 /*   printf("factors = %d\n",d_factors); */
    for(i=0;i<d_factors;i++) {
     /*   printf("i:%d pwr:%5.3f scl:%5.3f\n",i,dim[i],dscale[i]); */
	fillarray(a, n, 3.0-dim[i], dscale[i]);   /* put 1/f noise into array */
      }    

 /* printf("array filled...\n");
    for (j=0;j<n;j++)   {
      for (i=0;i<n;i++)   {
	printf("%1.3f/%1.3f ", Real(a,i,j),Imag(a,i,j) );
      }
      printf("\n");
    }
 */

    nsize[0] = 0;
    nsize[1] = nsize[2] = n;          /* Dimension of frequency domain array */
    printf("Calculating inverse FFT\n");
    fourn(a, nsize, 2, -1);           /* Take inverse 2D Fourier transform */

/*    printf("returned from fft\n");
    for (j=0;j<n;j++)   {
      for (i=0;i<n;i++)   {
	printf("%2.3f/%2.3f ", Real(a,i,j),Imag(a,i,j) );
      }
      printf("\n");
    }
  */
}

/*  INITSEED  --  Generate initial random seed, if needed.  */

static void initseed()
{
    int i = time(NULL) ^ 0xF37C;
    V srand(i);
    for (i = 0; i < 7; i++)
	V rand();
    rseed = rand();
}


/* genscape -- Write the pixmap from [n x n] elevation array. */

static void genscape(float *a, unsigned int n)
{
    int i, j;
    int ii, jj;
    int xsize, ysize;
    unsigned int p16;           /* storage for 16-bit pixel  jpb */
	
    xsize = n; ysize = n;
    ii = 0; jj = 0;             /* pacify the compiler */

    for (j = 0; j < n; j++) {
	    if (peakspec) jj = (ysize + j + ystart) % ysize;
	      else jj = j;
	    for (i = 0; i < n; i++) {
	      if (peakspec) ii = (xsize + i + xstart) % xsize;   
		else ii = i;
	      p16 = (unsigned int) (Real(a, ii, jj) * (float) max_pixval);
	      pp_writepixel(p16);
	    }
	}
    pp_closefile();       /* close output file */
    printf("file written\n");   
 
}

/*  PLANET  --  Make the fBm landscape.  */

static Boolean planet(int meshsize)
{
    float *a = (float *) 0;
    int i, j, n;
    double r;
    double rmin = 1e50, rmax = -1e50;
    double rmean, rrange;
    int imax=0, jmax=0;             /* index of maximum picture element */

    if (!seedspec) {
	initseed();
    }

    printf("-seed %d\n",rseed);
    img.rseed = rseed;

    pp_openfile(output_filename,img);

    initgauss(rseed);
		/* generate the height array via IFFT on 1/f scaled noise */
	spectralsynth(&a, meshsize);
	if (a == (float *) 0) {
	    return FALSE;
	}

    n = meshsize;

/*    for (j=0;j<n;j++)   {
      for (i=0;i<n;i++)   {
	printf("%2.3f/%2.3f ", Real(a,i,j),Imag(a,i,j) );
      }
      printf("\n");
    }
*/
	/* Compute extrema for autoscaling. */

	for (i = 0; i < meshsize; i++) {
	    for (j = 0; j < meshsize; j++) {
		r = Real(a, i, j);
		rmin = min(rmin, r);
		if (r > rmax) {
		  rmax = r;
		  imax = i;
		  jmax = j;
		}
	    }
	}
  /*    printf("\nmin=%f  max = %f\n",rmin,rmax);  */
	rmean = (rmin + rmax) / 2;
	rrange = (rmax - rmin);

	/* rescale all data to lie in the range [0..1]  */

	for (i = 0; i < meshsize; i++) {
	    for (j = 0; j < meshsize; j++) {
		Real(a, i, j) = (Real(a, i, j) - rmin) / rrange;
	    }
	}
/*
    printf("rescaled:\n");
    for (j=0;j<n;j++)   {
      for (i=0;i<n;i++)   {
	printf("%2.3f ", Real(a,i,j) );
      }
      printf("\n");
    }
*/
	/* Apply power law scaling if non-unity scale is requested. */

/* printf("power = %f\n",powscale); */

	if (powscale != 1.0) {
	    for (i = 0; i < meshsize; i++) {
		for (j = 0; j < meshsize; j++) {
		    r = Real(a, i, j);
		    if (r != 0)
		     Real(a, i, j) = pow(r, powscale);
		}
	    }
	}

/*    printf("powered: \n");
    for (j=0;j<n;j++)   {
      for (i=0;i<n;i++)   {
	printf("%2.3f ", Real(a,i,j));
      }
      printf("\n");
    }
 */

	rmean = (rmin + rmax) / 2;
	rrange = (rmax - rmin);
	xstart = imax - (int)((float)screenxsize * xfrac);
	ystart = jmax - (int)((float)screenysize * yfrac);

    genscape(a, meshsize);
    if (a != (float *) 0) {
	free((char *) a);
    }
     return TRUE;
}


/*  MAIN  --  Main gforge program: read command line, set vars.  */

int main(int argc, char **argv)
{
int i;
char *usage = "Usage: \n\
   gforge [-mesh <n>] [-dimension <f> [-adim <f> <sf>]] [-power <f> ] \n\
   [-peak <x> <y>] [-seed <n>] [-name <fname>] [-type tga|pgm|pg8] \n\
   [-version]\n";

    Boolean dimspec = FALSE, meshspec = FALSE, powerspec = FALSE,
	    namespec = FALSE, typespec = FALSE, adimspec = FALSE;

/* -------------------------------------------------- */
    /*       scan command line args                */

    i=1;
    d_factors = 1;
    while ((i < argc) && (argv[i][0] == '-') && (argv[i][1] != '\0')) {

       if (pm_keymatch(argv[i], "-dimension", 2)) {
	    if (dimspec) {
		pperror("already specified a dimension\n");
	    }
	    i++;
	    if ((i == argc) || (sscanf(argv[i], "%lf", &dim[0])  != 1))
		pperror(usage);
	    if (dim[0] <= 0.0) {
		pperror("fractal dimension must be greater than 0\n");
	    }
	    dscale[0] = 1;
	    dimspec = TRUE;
	} else if (pm_keymatch(argv[i], "-adim", 2)) {
	    if (d_factors > 9) pperror("sheesh! maximum of 10 dimensions\n");
	    i++;
	    if ((i == argc) || (sscanf(argv[i], "%lf", &dim[d_factors]) != 1))
		pperror(usage);
	    if (dim[d_factors] < 0.0) pperror("require dimension > 0\n");
	    i++;
	    if ((i==argc) || (sscanf(argv[i],"%lf",&dscale[d_factors]) != 1))
		pperror(usage);
	    adimspec = TRUE;    /* may be set more than once */
	    d_factors++;
     } else if (pm_keymatch(argv[i], "-mesh", 2)) {
	    unsigned int j;

	    if (meshspec) {
		pperror("already specified a mesh size\n");
	    }
	    i++;
	    if ((i == argc) || (sscanf(argv[i], "%d", &meshsize) != 1))
		pperror(usage);
	    if (meshsize <= 0)
	      pperror("A mesh size greater than zero is suggested!\n");

	    /* Force FFT mesh to the next larger power of 2. */

	    for (j = meshsize; (j & 1) == 0; j >>= 1) ;

	    if (j != 1) {
		for (j = 2; j < meshsize; j <<= 1) ;
		meshsize = j;
	    }
	    meshspec = TRUE;
	} else if (pm_keymatch(argv[i], "-power", 3)) {
	    if (powerspec) {
		pperror("already specified a power factor\n");
	    }
	    i++;
	    if ((i == argc) || (sscanf(argv[i], "%lf", &powscale) != 1))
		pperror(usage);
	    if (powscale <= 0.0) {
		pperror("power factor must be greater than 0\n");
	    }
	    powerspec = TRUE;
     } else if (pm_keymatch(argv[i], "-seed", 2)) {
	    if (seedspec) {
		pperror("already specified a random seed\n");
	    }
	    i++;
	    if ((i == argc) || (sscanf(argv[i], "%d", &rseed) != 1))
		pperror(usage);
	    seedspec = TRUE;
	} else if (pm_keymatch(argv[i], "-peak", 3)) {
	    if (peakspec) pperror("already specified peak location\n");
	    i++;
	    if ((i == argc) || (sscanf(argv[i], "%f", &xfrac) != 1))
		pperror(usage);
	    i++;
	    if ((i == argc) || (sscanf(argv[i], "%f", &yfrac) != 1))
		pperror("-peak requires two arguments, xfrac and yfrac.\n");
	    if ((xfrac<0)||(xfrac>1)||(yfrac<0)||(yfrac>1))
		pperror("-peak arguments lie in the range [0..1]\n");
	    peakspec = TRUE;
	} else if (pm_keymatch(argv[i], "-name", 2)) {
	    if (namespec) {
		pperror("already specified a filename\n");
	      }
	    i++;
	    if (i == argc)
		pperror(usage);
	    output_filename=(char *)argv[i];
	    namespec = TRUE;
	  } else if (pm_keymatch(argv[i], "-version",2)) {
	      pperror(VERSION);
	  } else if (pm_keymatch(argv[i], "-type", 2)) {
	    if (typespec) {
		pperror("already specified a filetype\n");
	      }
	    i++;
	    if (i == argc)
		pperror(usage);
	    if (pm_keymatch(argv[i], "TGA", 2))
		pp_filetype = TGA;
	     else if (pm_keymatch(argv[i], "PGM", 3))
		pp_filetype = PGM;
	     else if (pm_keymatch(argv[i], "PG8", 3))
		pp_filetype = PG8;
	     else if (pm_keymatch(argv[i], "PNG", 2))
		pp_filetype = PNG;
	     else pperror("Don't understand that file type.\n");
	    typespec = TRUE;
       } else {
	    pperror(usage);
	  }
       i++;
    }

/* -------------------------------------------------- */

      /* Set defaults when explicit specifications were not given.  */

    if (!dimspec) {
	if (adimspec) pperror("-apower requires the -power option");
	dim[0] = 2.15;
	dscale[0] = 1.0;
	d_factors = 1;      /* number of powers defined */

	fracdim = 2.15;
    }
    if (!powerspec) {
	powscale = 1.2;
    }
    if (!meshspec) {
	meshsize = 128;
      }
    if (!typespec) {
	pp_filetype = TGA;
      }
    if (!namespec) {
	if ((pp_filetype == PGM) || (pp_filetype == PG8)  )
	  output_filename = "output.pgm";
	else if (pp_filetype == TGA)
	  output_filename = "output.tga";
	else if (pp_filetype == PNG)
	  output_filename = "output.png";
      }
 
    screenxsize = meshsize;
    screenysize = meshsize;

	  /* prepare graphics file output */

    /* print out parameters so we know how we generated this file */

    printf("Parameters: -dimension %.2f -power %.2f -mesh %d -name %s\n",
	    dim[0], powscale, meshsize, output_filename);
    printf("            ");
    if (peakspec) 
       printf("-peak %0.2f %0.2f ",xfrac,yfrac);
    
    if (adimspec) {
      for (i=1;i<d_factors;i++) {
       printf("-ad %0.2f %0.2f ",dim[i],dscale[i]);
       }
      }

    img.dim= (double *)malloc(10*sizeof(double));
    img.dscale = (double *)malloc(10*sizeof(double));
		       
    for (i=0;i<d_factors;i++) {
      img.dim[i] = dim[i];
      img.dscale[i] = dscale[i];
    }
    img.powscale = powscale;
    img.xfrac = xfrac;
    img.yfrac = yfrac;
    img.rseed = rseed;
    img.d_factors = d_factors;
    img.peakspec = peakspec;
    img.adimspec = adimspec;
    img.meshsize = meshsize;

    return(planet(meshsize) ? 0 : 1);   /* run the algorithm; output results */

}

